<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package VW Lawyer Attorney
 */
?>
<header>
	<h2 class="entry-title"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_no_results_page_title',__('Nothing Found','vw-lawyer-attorney')));?></h2>
</header>

<?php if (is_home() && current_user_can('publish_posts')):?>

	<p><?php printf(esc_html__('Ready to publish your first post? Get started here.', 'vw-lawyer-attorney'), esc_url(admin_url('post-new.php')));?></p>
<?php  elseif (is_search()):?>
	<p><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_no_results_page_content',__('Sorry, but nothing matched your search terms. Please try again with some different keywords.','vw-lawyer-attorney')));?></p><br />
<?php get_search_form();?>
	<?php  else :?>
		<p><?php esc_html_e('Dont worry&hellip it happens to the best of us.', 'vw-lawyer-attorney');?></p><br />
		<div class="read-moresec">
			<a href="<?php echo esc_url();?>" class="button hvr-sweep-to-right"><?php esc_html_e('Return to Home Page', 'vw-lawyer-attorney');?><span class="screen-reader-text"><?php esc_html_e( 'Return to Home Page','vw-lawyer-attorney' );?></span></a>
		</div>
<?php endif;?>