<?php
add_action( 'admin_menu', 'vw_lawyer_attorney_gettingstarted' );
function vw_lawyer_attorney_gettingstarted() {    	
	add_theme_page( esc_html__('About VW Lawyer Attorney', 'vw-lawyer-attorney'), esc_html__('Theme Demo Import', 'vw-lawyer-attorney'), 'edit_theme_options', 'vw_lawyer_attorney_guide', 'vw_lawyer_attorney_mostrar_guide');   
}

function vw_lawyer_attorney_admin_theme_style() {
   wp_enqueue_style('vw-lawyer-attorney-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstart/getstart.css');
   wp_enqueue_script('vw-lawyer-attorney-tabs', esc_url(get_template_directory_uri()) . '/inc/getstart/js/tab.js');

   // Admin notice code START
	wp_register_script('vw-lawyer-attorney-notice', esc_url(get_template_directory_uri()) . '/inc/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('vw-lawyer-attorney-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'vw_lawyer_attorney_admin_theme_style');

function vw_lawyer_attorney_mostrar_guide() { 
	$vw_lawyer_attorney_return = add_query_arg( array()) ;
	$vw_lawyer_attorney_theme = wp_get_theme( 'vw-lawyer-attorney' );
?>

<div class="wrap getting-started">
	<div class="getting-started__header">
	    <div>
            <h2 class="tgmpa-notice-warning"></h2>
        </div>
	</div>
	<div class="tab-sec">
		<div class="tab">
			<button role="tab" class="tablinks home" onclick="vw_lawyer_attorney_openCity(event, 'bwp_getstart')"><?php esc_html_e( 'Getting Started', 'vw-lawyer-attorney' ); ?></button>
			<button role="tab" class="tablinks" onclick="vw_lawyer_attorney_openCity(event, 'bwp_setup')"><?php esc_html_e( 'Free Theme Information', 'vw-lawyer-attorney' ); ?></button>
			<button role="tab" class="tablinks" onclick="vw_lawyer_attorney_openCity(event, 'bwp_premium_info')"><?php esc_html_e( 'Premium Theme Information', 'vw-lawyer-attorney' ); ?></button>
			<a class="tablinks tablinks-demo" role="tab" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_LIVE_DEMO ); ?>" target="_blank">
				<?php esc_html_e( 'Live Demo', 'vw-lawyer-attorney' ); ?>
			</a>
			<a class="tablinks tablinks-pro" role="tab" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_BUY_NOW ); ?>" target="_blank">
				<?php esc_html_e( 'Buy Pro', 'vw-lawyer-attorney' ); ?>
			</a>
		</div>
		<div  id="bwp_getstart" class="tabcontent">
			<div class="row">
				<div class="col-md-5 intro">
					<div class="pad-box">
						<h2><?php esc_html_e( 'Welcome to VW Lawyer Attorney ', 'vw-lawyer-attorney' ); ?>
						<span><?php esc_html_e( 'Version: ', 'vw-lawyer-attorney' ); ?><?php echo esc_html($vw_lawyer_attorney_theme['Version']);?></span>
						</h2>
						<span class="intro__version"><?php esc_html_e( 'Congratulations! You are about to use the most easy to use and flexible WordPress theme.', 'vw-lawyer-attorney' ); ?>
						</span>
						<div class="powered-by">
							
							<div class="demo-content">
								<?php
									/* Demo Import */
									require get_parent_theme_file_path( '/inc/getstart/demo-content.php' );
								?>
							</div>
							<div id="demo-import-loader">
								<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstart/images/spinner.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'vw-lawyer-attorney'); ?>" />
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-7">
					<div class="install-plugins">
						<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstart/images/responsive-free.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'vw-lawyer-attorney'); ?>" />
					</div>
				</div>
			</div>
			<div class="dashboard__blocks">
				<div class="row">
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Get Support','vw-lawyer-attorney'); ?></h3>
						<ol>
							<li><a target="_blank" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_SUPPORT ); ?>"><?php esc_html_e( 'Free Theme Support','vw-lawyer-attorney'); ?></a></li>
							<li><a target="_blank" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_PRO_SUPPORT ); ?>"><?php esc_html_e( 'Premium Theme Support','vw-lawyer-attorney'); ?></a></li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Getting Started','vw-lawyer-attorney'); ?></h3>
						<ol>
							<li><?php esc_html_e( 'Start','vw-lawyer-attorney'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','vw-lawyer-attorney'); ?></a> <?php esc_html_e( 'your website.','vw-lawyer-attorney'); ?> </li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Help Docs','vw-lawyer-attorney'); ?></h3>
						<ol>
							<li><a target="_blank" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_FREE_THEME_DOC ); ?>"><?php esc_html_e( 'Free Theme Documentation','vw-lawyer-attorney'); ?></a></li>
							<li><a target="_blank" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_PRO_DOC ); ?>"><?php esc_html_e( 'Premium Theme Documentation','vw-lawyer-attorney'); ?></a></li>
						</ol>
					</div>
					<div class="col-md-3">
						<h3><?php esc_html_e( 'Buy Premium','vw-lawyer-attorney'); ?></h3>
						<ol>
							<a href="<?php echo esc_url( VW_LAWYER_ATTORNEY_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'vw-lawyer-attorney'); ?></a>
						</ol>
					</div>
				</div>
			</div>
		</div>
		<div  id="bwp_setup" class="tabcontent">
			<h2 class="tg-docs-section intruction-title" id="section-4"><?php esc_html_e( '1) Setup VW Lawyer Attorney Theme', 'vw-lawyer-attorney' ); ?></h2>
			<div class="row">
				<div class="theme-instruction-block col-md-7">
					<div class="pad-box">
						<p><?php esc_html_e( 'VW Lawyer Attorney is a sleek and user-friendly digital storefront designed for watch retailers and enthusiasts. With a modern and stylish layout, this theme creates a visually appealing online space, showcasing a wide range of watches in an easy-to-navigate format. Crafted for businesses in the watch industry, the theme offers an engaging online shopping experience for customers seeking quality timepieces. Its design is clean and sophisticated, ensuring that visitors can effortlessly browse through various watch collections, explore detailed product information, and make informed purchasing decisions. Tailored to cater to the needs of watch stores, this theme is not only aesthetically pleasing but also functional. This theme can be used by watch shop,Retail, Online Store, Watches, E-commerce, Fashion, watch store, minimal watch store, watch seller, watch business, watch vendor or a clock shop. Whwether you have jewelry store, glass wear, makeup, women fashion or perfume and fragrance, You can customize this theme for your niche. It provides a seamless and secure platform for transactions, enabling customers to explore the latest watch models, check prices, and complete their purchases with confidence. The responsive design ensures a consistent and enjoyable experience across different devices, including desktops, tablets, and smartphones. For businesses looking to establish a distinctive online presence, the VW Lawyer Attorney WordPress Theme allows for easy customization. You can personalize elements such as logos, colors, and fonts to align with your brand identity, creating a cohesive and memorable representation. The VW Lawyer Attorney WordPress Theme is an ideal solution for watch retailers aiming to thrive in the digital space. Its user-friendly design, functional features, and customization options make it a valuable tool for creating an attractive and efficient online watch store, catering to both the needs of the business and the preferences of watch enthusiasts.', 'vw-lawyer-attorney' ); ?><p><br>
						<ol>
							<li><?php esc_html_e( 'Start','vw-lawyer-attorney'); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizing','vw-lawyer-attorney'); ?></a> <?php esc_html_e( 'your website.','vw-lawyer-attorney'); ?> </l>
							<li><?php esc_html_e( 'VW Lawyer Attorney','vw-lawyer-attorney'); ?> <a target="_blank" href="<?php echo esc_url( VW_LAWYER_ATTORNEY_FREE_THEME_DOC ); ?>"><?php esc_html_e( 'Documentation','vw-lawyer-attorney'); ?></a> </li>
						</ol>
					</div>
				</div>
				<div class="col-md-5">
					<div class="pad-box">
							<img class="logo" src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstart/images/screenshot.png'); ?>"/>
					</div>
				</div>	
			</div>
		</div>
		<div class="col-md-12 text-block tabcontent"  id="bwp_premium_info">
			<h2 class="dashboard-install-title"><?php esc_html_e( '2) Premium Theme Information.','vw-lawyer-attorney'); ?></h2>
			<div class="row">
				<div class="col-md-7">
					<img src="<?php echo esc_url(get_template_directory_uri() . '/inc/getstart/images/responsive-pro.png'); ?>" alt="<?php echo esc_attr( 'responsive-image', 'vw-lawyer-attorney'); ?>">
					<div class="pad-box">
						<h3><?php esc_html_e( 'Pro Theme Description','vw-lawyer-attorney'); ?></h3>
						<p class="pad-box-p"><?php esc_html_e( 'The Watch Store WordPress Theme is a premium solution tailored for watch retailers looking to enhance their online presence and boost sales. This theme is designed with the modern consumer in mind, combining aesthetic appeal with robust functionality. It boasts a fully responsive design, ensuring that your store looks fantastic on any device, whether its a smartphone, tablet, or desktop. With a user-friendly interface, customers can effortlessly browse through your collection of watches, complete with high-quality images and detailed descriptions. The theme supports multiple post formats, allowing you to share valuable content about watch care, styling tips, and industry news, helping to engage and educate your audience while enhancing your SEO strategy.', 'vw-lawyer-attorney' ); ?><p>
					</div>
				</div>
				<div class="col-md-5 install-plugin-right">
					<div class="pad-box">
						<h3><?php esc_html_e( 'Pro Theme Features','vw-lawyer-attorney'); ?></h3>
						<div class="dashboard-install-benefit">
							<ul>
								<li><?php esc_html_e( 'One click demo importer','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Global color option','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Responsive design','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Favicon, logo, title, and tagline customization','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Advanced color options and color pallets','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( '100+ font family options','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Simple menu option','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'SEO friendly','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Pagination option','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Compatible with different WordPress famous plugins like contact form 7','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Enable-Disable options on all sections','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Well sanitized as per WordPress standards.','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Responsive Layout for All Devices','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Footer customization options','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Fully integrated with the latest font awesome','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Background image option','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Custom Page Templates','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Allow To Set Site Title, Tagline, Logo','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Sticky post & comment threads','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Section reordering','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Customizable home page','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Footer widgets & editor style','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Social media feature','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Slider with unlimited number of slides','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Our Cleaning Services Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Testimonial Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Our Team Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Counter Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Our Project Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'How We Work Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Pricing Plan Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Brand Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Instagram Feed','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Newsletter Section','vw-lawyer-attorney'); ?></li>
								<li><?php esc_html_e( 'Blog post section','vw-lawyer-attorney'); ?></li>							
								<li><?php esc_html_e( 'Contact page template','vw-lawyer-attorney'); ?></li>	
								<li><?php esc_html_e( 'Shortcodes for the Custom Posttype','vw-lawyer-attorney'); ?></li>	
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php } ?>