<div class="theme-offer">
	<?php 
        // Check if the demo import has been completed
        $vw_lawyer_attorney_demo_import_completed = get_option('vw_lawyer_attorney_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($vw_lawyer_attorney_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-lawyer-attorney') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-lawyer-attorney') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

            // ------- Create Nav Menu --------
            $vw_lawyer_attorney_menuname = 'Main Menus';
            $vw_lawyer_attorney_bpmenulocation = 'primary';
            $vw_lawyer_attorney_menu_exists = wp_get_nav_menu_object($vw_lawyer_attorney_menuname);

            if (!$vw_lawyer_attorney_menu_exists) {
                $vw_lawyer_attorney_menu_id = wp_create_nav_menu($vw_lawyer_attorney_menuname);

                // Create Home Page
                $vw_lawyer_attorney_home_title = 'Home';
                $vw_lawyer_attorney_home = array(
                    'post_type' => 'page',
                    'post_title' => $vw_lawyer_attorney_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $vw_lawyer_attorney_home_id = wp_insert_post($vw_lawyer_attorney_home);
                // Assign Home Page Template
                add_post_meta($vw_lawyer_attorney_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $vw_lawyer_attorney_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'vw-lawyer-attorney'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_lawyer_attorney_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $vw_lawyer_attorney_pages_title = 'Pages';
                $vw_lawyer_attorney_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_lawyer_attorney_pages = array(
                    'post_type' => 'page',
                    'post_title' => $vw_lawyer_attorney_pages_title,
                    'post_content' => $vw_lawyer_attorney_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $vw_lawyer_attorney_pages_id = wp_insert_post($vw_lawyer_attorney_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'vw-lawyer-attorney'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_lawyer_attorney_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $vw_lawyer_attorney_about_title = 'About Us';
                $vw_lawyer_attorney_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_lawyer_attorney_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_lawyer_attorney_about_title,
                    'post_content' => $vw_lawyer_attorney_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_lawyer_attorney_about_id = wp_insert_post($vw_lawyer_attorney_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'vw-lawyer-attorney'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_lawyer_attorney_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                /* 
                * Practice Area Page
                *  */
                $vw_lawyer_attorney_practice_title = 'Practice Area';
                $vw_lawyer_attorney_practice_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br><br>
                We provide legal services across multiple practice areas including civil law, criminal defense, corporate law, family law, and legal consultation.';

                $vw_lawyer_attorney_practice = array(
                    'post_type'    => 'page',
                    'post_title'   => $vw_lawyer_attorney_practice_title,
                    'post_content' => $vw_lawyer_attorney_practice_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'practice-area'
                );
                $vw_lawyer_attorney_practice_id = wp_insert_post($vw_lawyer_attorney_practice);

                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title'     => __('Practice Area', 'vw-lawyer-attorney'),
                    'menu-item-classes'  => 'practice-area',
                    'menu-item-url'      => home_url('/practice-area/'),
                    'menu-item-status'   => 'publish',
                    'menu-item-object-id'=> $vw_lawyer_attorney_practice_id,
                    'menu-item-object'   => 'page',
                    'menu-item-type'     => 'post_type'
                ));


                /* 
                * Attorney Page
                *  */
                $vw_lawyer_attorney_attorney_title = 'Attorney';
                $vw_lawyer_attorney_attorney_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br><br>
                Meet our experienced attorneys dedicated to delivering professional legal representation and trusted advice.';

                $vw_lawyer_attorney_attorney = array(
                    'post_type'    => 'page',
                    'post_title'   => $vw_lawyer_attorney_attorney_title,
                    'post_content' => $vw_lawyer_attorney_attorney_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'attorney'
                );
                $vw_lawyer_attorney_attorney_id = wp_insert_post($vw_lawyer_attorney_attorney);

                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title'     => __('Attorney', 'vw-lawyer-attorney'),
                    'menu-item-classes'  => 'attorney',
                    'menu-item-url'      => home_url('/attorney/'),
                    'menu-item-status'   => 'publish',
                    'menu-item-object-id'=> $vw_lawyer_attorney_attorney_id,
                    'menu-item-object'   => 'page',
                    'menu-item-type'     => 'post_type'
                ));

                /* 
                * Case Study Page
                *  */
                $vw_lawyer_attorney_case_title = 'Case Study';
                $vw_lawyer_attorney_case_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br><br>
                Explore our successful case studies that demonstrate our expertise and commitment to justice.';

                $vw_lawyer_attorney_case = array(
                    'post_type'    => 'page',
                    'post_title'   => $vw_lawyer_attorney_case_title,
                    'post_content' => $vw_lawyer_attorney_case_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'case-study'
                );
                $vw_lawyer_attorney_case_id = wp_insert_post($vw_lawyer_attorney_case);

                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title'     => __('Case Study', 'vw-lawyer-attorney'),
                    'menu-item-classes'  => 'case-study',
                    'menu-item-url'      => home_url('/case-study/'),
                    'menu-item-status'   => 'publish',
                    'menu-item-object-id'=> $vw_lawyer_attorney_case_id,
                    'menu-item-object'   => 'page',
                    'menu-item-type'     => 'post_type'
                ));


                /* 
                * News Page
                *  */
                $vw_lawyer_attorney_news_title = 'News';
                $vw_lawyer_attorney_news_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br><br>
                Stay updated with the latest legal news, articles, and firm announcements.';

                $vw_lawyer_attorney_news = array(
                    'post_type'    => 'page',
                    'post_title'   => $vw_lawyer_attorney_news_title,
                    'post_content' => $vw_lawyer_attorney_news_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'news'
                );
                $vw_lawyer_attorney_news_id = wp_insert_post($vw_lawyer_attorney_news);

                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title'     => __('News', 'vw-lawyer-attorney'),
                    'menu-item-classes'  => 'news',
                    'menu-item-url'      => home_url('/news/'),
                    'menu-item-status'   => 'publish',
                    'menu-item-object-id'=> $vw_lawyer_attorney_news_id,
                    'menu-item-object'   => 'page',
                    'menu-item-type'     => 'post_type'
                ));


                /* 
                * Contact Page
                *  */
                $vw_lawyer_attorney_contact_title = 'Contact';
                $vw_lawyer_attorney_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br><br>
                Contact us today for professional legal consultation and case evaluation.';

                $vw_lawyer_attorney_contact = array(
                    'post_type'    => 'page',
                    'post_title'   => $vw_lawyer_attorney_contact_title,
                    'post_content' => $vw_lawyer_attorney_contact_content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                    'post_slug'    => 'contact'
                );
                $vw_lawyer_attorney_contact_id = wp_insert_post($vw_lawyer_attorney_contact);

                wp_update_nav_menu_item($vw_lawyer_attorney_menu_id, 0, array(
                    'menu-item-title'     => __('Contact', 'vw-lawyer-attorney'),
                    'menu-item-classes'  => 'contact',
                    'menu-item-url'      => home_url('/contact/'),
                    'menu-item-status'   => 'publish',
                    'menu-item-object-id'=> $vw_lawyer_attorney_contact_id,
                    'menu-item-object'   => 'page',
                    'menu-item-type'     => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($vw_lawyer_attorney_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($locations)) {
                        $locations = array();
                    }
                    $locations[$vw_lawyer_attorney_bpmenulocation] = $vw_lawyer_attorney_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }               
        }
        
            // Set the demo import completion flag
    		update_option('vw_lawyer_attorney_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-lawyer-attorney') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-lawyer-attorney') . '</a></span>';
            //end 


            // Top Bar //
            set_theme_mod( 'vw_lawyer_attorney_call', '+00 123 456 7890' );  
            set_theme_mod( 'vw_lawyer_attorney_call1', 'support@example.com' );
            set_theme_mod( 'vw_lawyer_attorney_location', '1900 New Your USA' );  
            set_theme_mod( 'vw_lawyer_attorney_location1', 'New Yark, USA' );
            set_theme_mod( 'vw_lawyer_attorney_time', 'Mon-Fri 9:00 - 17:00' );  
            set_theme_mod( 'vw_lawyer_attorney_time1', 'Sat: 10:00 - 14:00 Sunday: Closed' );  


            // slider section start //      
            set_theme_mod( 'vw_lawyer_attorney_slider_button_text', 'KNOW MORE' );
            set_theme_mod( 'vw_lawyer_attorney_slider_button_link_text2', '#' );

            for($vw_lawyer_attorney_i=1;$vw_lawyer_attorney_i<=3;$vw_lawyer_attorney_i++){
               $vw_lawyer_attorney_slider_title = 'You Deserve The Best Lawyers, ....With Our 20 Years of Law Practice! ';
               $vw_lawyer_attorney_slider_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book.';
                  // Create post object
               $my_post = array(
               'post_title'    => wp_strip_all_tags( $vw_lawyer_attorney_slider_title ),
               'post_content'  => $vw_lawyer_attorney_slider_content,
               'post_status'   => 'publish',
               'post_type'     => 'page',
               );

               // Insert the post into the database
               $vw_lawyer_attorney_post_id = wp_insert_post( $my_post );

               if ($vw_lawyer_attorney_post_id) {
                 // Set the theme mod for the slider page
                 set_theme_mod('vw_lawyer_attorney_slider_page' . $vw_lawyer_attorney_i, $vw_lawyer_attorney_post_id);

                  $vw_lawyer_attorney_image_url = get_template_directory_uri().'/images/slider'.$vw_lawyer_attorney_i.'.png';

                $vw_lawyer_attorney_image_id = media_sideload_image($vw_lawyer_attorney_image_url, $vw_lawyer_attorney_post_id, null, 'id');

                    if (!is_wp_error($vw_lawyer_attorney_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($vw_lawyer_attorney_post_id, $vw_lawyer_attorney_image_id);
                    }
                }
            }    
            

            // Service Section //
            set_theme_mod( 'vw_lawyer_attorney_about_small_text', 'Welcome to The Lawyer Theme' );
            set_theme_mod( 'vw_lawyer_attorney_about_name', 'DISCOVER MORE ABOUT US' );

            // Define post title and content
             $vw_lawyer_attorney_post_title = '20 Years Experience';
             $vw_lawyer_attorney_post_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.';
 
             // Create post object
             $vw_lawyer_attorney_my_post = array(
                 'post_title'    => wp_strip_all_tags($vw_lawyer_attorney_post_title),
                 'post_content'  => $vw_lawyer_attorney_post_content,
                 'post_status'   => 'publish',
                 'post_type'     => 'post',
             );
 
             // Insert the post into the database
             $vw_lawyer_attorney_post_id = wp_insert_post($vw_lawyer_attorney_my_post);
 
             // Check if the post was successfully created
             if (!is_wp_error($vw_lawyer_attorney_post_id)) {
                 // Set the theme mod for the post ID
                 set_theme_mod('vw_lawyer_attorney_about_setting', $vw_lawyer_attorney_post_id);
 
                
             } else {
                 // Handle the error if the post creation failed
                 error_log('Post creation failed: ' . $vw_lawyer_attorney_post_id->get_error_message());             
            }


            // Why Choose Us Section
            set_theme_mod('vw_lawyer_attorney_main_title', 'Why Choose Us?');
            set_theme_mod('vw_lawyer_attorney_blogcategory_setting', 'category1');

            // Define post category names and post titles
            $vw_lawyer_attorney_category_names = array('category1', 'category2');
            $vw_lawyer_attorney_title_array = array(
                array("Our History", "Our Mission"),
                array("Our Mission", "Our History")
            );

            foreach ($vw_lawyer_attorney_category_names as $vw_lawyer_attorney_index => $vw_lawyer_attorney_category_name) {
                // Create or retrieve the post category term ID
                $vw_lawyer_attorney_term = term_exists($vw_lawyer_attorney_category_name, 'category');
                if ($vw_lawyer_attorney_term === 0 || $vw_lawyer_attorney_term === null) {
                    // If the term does not exist, create it
                    $vw_lawyer_attorney_term = wp_insert_term($vw_lawyer_attorney_category_name, 'category');
                }
                if (is_wp_error($vw_lawyer_attorney_term)) {
                    error_log('Error creating category: ' . $vw_lawyer_attorney_term->get_error_message());
                    continue; // Skip to the next iteration if category creation fails
                }

                for ($vw_lawyer_attorney_i = 0; $vw_lawyer_attorney_i < 2; $vw_lawyer_attorney_i++) {
                    // Create post content
                    $vw_lawyer_attorney_title = $vw_lawyer_attorney_title_array[$vw_lawyer_attorney_index][$vw_lawyer_attorney_i];
                    $vw_lawyer_attorney_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. ';

                    // Create post post object
                    $vw_lawyer_attorney_my_post = array(
                        'post_title'    => wp_strip_all_tags($vw_lawyer_attorney_title),
                        'post_content'  => $vw_lawyer_attorney_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'post', // Post type set to 'post'
                    );

                    // Insert the post into the database
                    $vw_lawyer_attorney_post_id = wp_insert_post($vw_lawyer_attorney_my_post);

                    if (is_wp_error($vw_lawyer_attorney_post_id)) {
                        error_log('Error creating post: ' . $vw_lawyer_attorney_post_id->get_error_message());
                        continue; // Skip to the next post if creation fails
                    }

                    // Assign the category to the post
                    wp_set_post_categories($vw_lawyer_attorney_post_id, array((int)$vw_lawyer_attorney_term['term_id']));

                    // Handle the featured image using media_sideload_image
                    $vw_lawyer_attorney_image_url = get_template_directory_uri() . '/images/service' . ($vw_lawyer_attorney_i + 1) . '.png';
                    $vw_lawyer_attorney_image_id = media_sideload_image($vw_lawyer_attorney_image_url, $vw_lawyer_attorney_post_id, null, 'id');

                    if (is_wp_error($vw_lawyer_attorney_image_id)) {
                        error_log('Error downloading image: ' . $vw_lawyer_attorney_image_id->get_error_message());
                        continue; // Skip to the next post if image download fails
                    }
                    // Assign featured image to post
                    set_post_thumbnail($vw_lawyer_attorney_post_id, $vw_lawyer_attorney_image_id);
                }
            }   


            //Copyright Text
            set_theme_mod( 'vw_lawyer_attorney_footer_text', 'By VWThemes' );  
     
        }
    ?>


    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=vw_lawyer_attorney_guide" method="POST" onsubmit="return validate(this);">
         <?php if (!get_option('vw_lawyer_attorney_demo_import_completed')) : ?>
             <form method="post">
                <p class="run-import-text"><?php esc_html_e('Click On The Below Run Importer Button To Import Demo Content Of VW Lawyer Attorney','vw-lawyer-attorney'); ?></p>
                <p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for VW Lawyer Attorney','vw-lawyer-attorney'); ?></p>
                 <input class= "run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer','vw-lawyer-attorney'); ?>" class="button button-primary button-large">
             </form>
         <?php endif; ?>
     </form>
    <script type="text/javascript">
                 function validate(valid) {
                          if(confirm("Do you really want to import the theme demo content?")){
                            // Show loader
                            document.getElementById('demo-import-loader').style.display = 'block';
                            // Submit form
                            document.forms[0].submit();
                         }
                     else {
                             return false;
                     }
                 }
    </script>
</div>

