<?php
/**
 * VW Lawyer Attorney Theme Customizer
 *
 * @package VW Lawyer Attorney
 */
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function vw_lawyer_attorney_custom_controls() {

    load_template( trailingslashit( get_template_directory() ) . '/inc/custom-controls.php' );
}
add_action( 'customize_register', 'vw_lawyer_attorney_custom_controls' );

function vw_lawyer_attorney_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage'; 
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array( 
		'selector' => '.logo .site-title a', 
	 	'render_callback' => 'vw_lawyer_attorney_customize_partial_blogname', 
	)); 

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array( 
		'selector' => 'p.site-description', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_blogdescription', 
	));

	//Homepage Settings
	$wp_customize->add_panel( 'vw_lawyer_attorney_homepage_panel', array(
		'title' => esc_html__( 'Homepage Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_panel_id',
		'priority' => 20,
	));

	//Top Bar(topbar)
	$wp_customize->add_section('vw_lawyer_attorney_contact',array(
		'title'	=> __('Top Bar Settings','vw-lawyer-attorney'),
		'description'	=> __('Add contact us here','vw-lawyer-attorney'),
		'priority'	=> null,
		'panel' => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_hide_show_topbar_section',array(
	  	'default' => 1,
	  	'transport' => 'refresh',
	  	'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	));
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_hide_show_topbar_section',array(
	  	'label' => esc_html__( 'Show / Hide Topbar','vw-lawyer-attorney' ),
	  	'section' => 'vw_lawyer_attorney_contact',
  	)));

   // Header Background color

	$wp_customize->add_setting('vw_lawyer_attorney_header_background_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_header_background_color', array(
		'label'    => __('Header Background Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_contact',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_header_img_position',array(
	  'default' => 'center top',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_header_img_position',array(
		'type' => 'select',
		'label' => __('Header Image Position','vw-lawyer-attorney'),
		'section' => 'vw_lawyer_attorney_contact',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'vw-lawyer-attorney' ),
			'center top'   => esc_html__( 'Top', 'vw-lawyer-attorney' ),
			'right top'   => esc_html__( 'Top Right', 'vw-lawyer-attorney' ),
			'left center'   => esc_html__( 'Left', 'vw-lawyer-attorney' ),
			'center center'   => esc_html__( 'Center', 'vw-lawyer-attorney' ),
			'right center'   => esc_html__( 'Right', 'vw-lawyer-attorney' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'vw-lawyer-attorney' ),
			'center bottom'   => esc_html__( 'Bottom', 'vw-lawyer-attorney' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'vw-lawyer-attorney' ),
		),
	));

	$wp_customize->add_setting('vw_lawyer_attorney_topbar_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_topbar_padding_top_bottom',array(
		'label'	=> __('Topbar Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_contact',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_search_hide_show',
       array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_search_hide_show',
       array(
      'label' => esc_html__( 'Show / Hide Search','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_contact'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_search_icon',array(
		'default'	=> 'fas fa-search',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_search_icon',array(
		'label'	=> __('Add Search Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_contact',
		'setting'	=> 'vw_lawyer_attorney_search_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_search_close_icon',array(
		'default'	=> 'fa fa-window-close',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_search_close_icon',array(
		'label'	=> __('Add Search Close Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_contact',
		'setting'	=> 'vw_lawyer_attorney_search_close_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting('vw_lawyer_attorney_search_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_search_font_size',array(
		'label'	=> __('Search Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_contact',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_search_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_search_padding_top_bottom',array(
		'label'	=> __('Search Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_contact',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_search_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_search_padding_left_right',array(
		'label'	=> __('Search Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_contact',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_search_border_radius', array(
		'default'              => "",
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_search_border_radius', array(
		'label'       => esc_html__( 'Search Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_contact',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_search_placeholder',array(
       'default' => esc_html__('Search','vw-lawyer-attorney'),
       'sanitize_callback'	=> 'sanitize_text_field'
    ));
    $wp_customize->add_control('vw_lawyer_attorney_search_placeholder',array(
       'type' => 'text',
       'label' => __('Search Placeholder Text','vw-lawyer-attorney'),
       'section' => 'vw_lawyer_attorney_contact'
    ));

    //Sticky Header
	$wp_customize->add_setting( 'vw_lawyer_attorney_sticky_header',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_sticky_header',array(
        'label' => esc_html__( 'Show / Hide Sticky Header','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_contact'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_sticky_header_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_sticky_header_padding',array(
		'label'	=> __('Sticky Header Padding','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_contact',
		'type'=> 'text'
	));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_call', array( 
		'selector' => '.contact p.diff-lay', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_call', 
	));

	$wp_customize->add_setting('vw_lawyer_attorney_call',array(
		'default'	=> '',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_phone_number'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_call',array(
		'label'	=> __('Phone Number','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_call1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_call1',array(
		'label'	=> __('Email Address','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_location',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_location',array(
		'label'	=> __('Address 1','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_location1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_location1',array(
		'label'	=> __('Address 2','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_time',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_time',array(
		'label'	=> __('Opening time.','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_time1',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	
	$wp_customize->add_control('vw_lawyer_attorney_time1',array(
		'label'	=> __('Closing Time','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_contact',
		'type'		=> 'text'
	));

	//Menus Settings
	$wp_customize->add_section( 'vw_lawyer_attorney_menu_section' , array(
    	'title' => __( 'Menus Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_homepage_panel'
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_navigation_menu_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_navigation_menu_font_size',array(
		'label'	=> __('Menus Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_menu_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_navigation_menu_font_weight',array(
        'default' => 600,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_navigation_menu_font_weight',array(
        'type' => 'select',
        'label' => __('Menus Font Weight','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_menu_section',
        'choices' => array(
        	'100' => __('100','vw-lawyer-attorney'),
            '200' => __('200','vw-lawyer-attorney'),
            '300' => __('300','vw-lawyer-attorney'),
            '400' => __('400','vw-lawyer-attorney'),
            '500' => __('500','vw-lawyer-attorney'),
            '600' => __('600','vw-lawyer-attorney'),
            '700' => __('700','vw-lawyer-attorney'),
            '800' => __('800','vw-lawyer-attorney'),
            '900' => __('900','vw-lawyer-attorney'),
        ),
	) );

	// text trasform
	$wp_customize->add_setting('vw_lawyer_attorney_menu_text_transform',array(
		'default'=> 'Uppercase',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_menu_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Menus Text Transform','vw-lawyer-attorney'),
		'choices' => array(
            'Uppercase' => __('Uppercase','vw-lawyer-attorney'),
            'Capitalize' => __('Capitalize','vw-lawyer-attorney'),
            'Lowercase' => __('Lowercase','vw-lawyer-attorney'),
        ),
		'section'=> 'vw_lawyer_attorney_menu_section',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_menus_item_style',array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_menus_item_style',array(
        'type' => 'select',
        'section' => 'vw_lawyer_attorney_menu_section',
		'label' => __('Menu Item Hover Style','vw-lawyer-attorney'),
		'choices' => array(
            'None' => __('None','vw-lawyer-attorney'),
            'Zoom In' => __('Zoom In','vw-lawyer-attorney'),
        ),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_header_menus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_header_menus_color', array(
		'label'    => __('Menus Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_menu_section',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_header_menus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_header_menus_hover_color', array(
		'label'    => __('Menus Hover Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_menu_section',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_header_submenus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_header_submenus_color', array(
		'label'    => __('Sub Menus Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_menu_section',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_header_submenus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_header_submenus_hover_color', array(
		'label'    => __('Sub Menus Hover Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_menu_section',
	)));

	//home page slider
    $wp_customize->add_section( 'vw_lawyer_attorney_slidersettings' , array(
      	'title'      => __( 'Slider Settings', 'vw-lawyer-attorney' ),
		'description' => "Free theme has 3 slides options, For unlimited slides and more options </br><a class='go-pro-btn' target='_blank' href='". esc_url(VW_LAWYER_ATTORNEY_GO_PRO) ." '>GET PRO</a>",
      	'priority'   => null,
      	'panel' => 'vw_lawyer_attorney_homepage_panel'
    ) );

    $wp_customize->add_setting( 'vw_lawyer_attorney_slider_hide_show',
       array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_slider_hide_show',
       array(
      'label' => esc_html__( 'Show / Hide Slider','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_slidersettings'
    )));

      $wp_customize->add_setting('vw_lawyer_attorney_slider_type',array(
        'default' => 'Default slider',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	) );
	$wp_customize->add_control('vw_lawyer_attorney_slider_type', array(
        'type' => 'select',
        'label' => __('Slider Type','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_slidersettings',
        'choices' => array(
            'Default slider' => __('Default slider','vw-lawyer-attorney'),
            'Advance slider' => __('Advance slider','vw-lawyer-attorney'),
        ),
	));

	$wp_customize->add_setting('vw_lawyer_attorney_advance_slider_shortcode',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_advance_slider_shortcode',array(
		'label'	=> __('Add Slider Shortcode','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_advance_slider'
	));

    //Selective Refresh
    $wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_slider_hide_show',array(
		'selector'        => '.slider .inner_carousel h1',
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_slider_hide_show',
	));

    for ( $count = 1; $count <= 3; $count++ ) {
	    // Add color scheme setting and control.
	    $wp_customize->add_setting( 'vw_lawyer_attorney_slider_page' . $count, array(
	      'default'           => '',
	      'sanitize_callback' => 'vw_lawyer_attorney_sanitize_dropdown_pages'
	    ) );
	    $wp_customize->add_control( 'vw_lawyer_attorney_slider_page' . $count, array(
	      'label'    => __( 'Select Slide Image Page', 'vw-lawyer-attorney' ),
	      'description' => __('Slider image size (1500 x 765)','vw-lawyer-attorney'),
	      'section'  => 'vw_lawyer_attorney_slidersettings',
	      'type'     => 'dropdown-pages',
	      'active_callback' => 'vw_lawyer_attorney_default_slider'
	    ) );
	    
    }

    $wp_customize->add_setting('vw_lawyer_attorney_slider_button_text',array(
		'default'=> 'KNOW MORE',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_slider_button_text',array(
		'label'	=> __('Add Slider Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'KNOW MORE', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_slider_button_link_text2',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('vw_lawyer_attorney_slider_button_link_text2',array(
		'label'	=> __('Add Button URL','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_slidersettings',
		'setting'	=> 'vw_lawyer_attorney_slider_button_link_text2',
		'type'	=> 'url',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	));


    //content layout
	$wp_customize->add_setting('vw_lawyer_attorney_slider_content_option',array(
        'default' => 'Left',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Image_Radio_Control($wp_customize, 'vw_lawyer_attorney_slider_content_option', array(
        'type' => 'select',
        'label' => __('Slider Content Layouts','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_slidersettings',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/images/slider-content1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/slider-content2.png',
            'Right' => esc_url(get_template_directory_uri()).'/images/slider-content3.png',
    ),'active_callback' => 'vw_lawyer_attorney_default_slider'
    )));

    //Slider content padding
    $wp_customize->add_setting('vw_lawyer_attorney_slider_content_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_slider_content_padding_top_bottom',array(
		'label'	=> __('Slider Content Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in %. Example:20%','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_slider_content_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_slider_content_padding_left_right',array(
		'label'	=> __('Slider Content Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in %. Example:20%','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	));

    //Slider excerpt
	$wp_customize->add_setting( 'vw_lawyer_attorney_slider_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_slider_excerpt_number', array(
		'label'       => esc_html__( 'Slider Excerpt Length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_slidersettings',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_slider_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),'active_callback' => 'vw_lawyer_attorney_default_slider'
	) );

	//Slider height
	$wp_customize->add_setting('vw_lawyer_attorney_slider_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_slider_height',array(
		'label'	=> __('Slider Height','vw-lawyer-attorney'),
		'description'	=> __('Specify the slider height (px).','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '500px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_slider_speed', array(
		'default'  => 4000,
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_float'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_slider_speed', array(
		'label' => esc_html__('Slider Transition Speed','vw-lawyer-attorney'),
		'section' => 'vw_lawyer_attorney_slidersettings',
		'type'  => 'number',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	) );

	//Opacity
	$wp_customize->add_setting('vw_lawyer_attorney_slider_opacity_color',array(
      'default'              => 0.6,
      'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));

	$wp_customize->add_control( 'vw_lawyer_attorney_slider_opacity_color', array(
		'label'       => esc_html__( 'Slider Image Opacity','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_slidersettings',
		'type'        => 'select',
		'settings'    => 'vw_lawyer_attorney_slider_opacity_color',
		'choices' => array(
	      '0' =>  esc_attr( __('0','vw-lawyer-attorney')),
	      '0.1' =>  esc_attr( __('0.1','vw-lawyer-attorney')),
	      '0.2' =>  esc_attr( __('0.2','vw-lawyer-attorney')),
	      '0.3' =>  esc_attr( __('0.3','vw-lawyer-attorney')),
	      '0.4' =>  esc_attr( __('0.4','vw-lawyer-attorney')),
	      '0.5' =>  esc_attr( __('0.5','vw-lawyer-attorney')),
	      '0.6' =>  esc_attr( __('0.6','vw-lawyer-attorney')),
	      '0.7' =>  esc_attr( __('0.7','vw-lawyer-attorney')),
	      '0.8' =>  esc_attr( __('0.8','vw-lawyer-attorney')),
	      '0.9' =>  esc_attr( __('0.9','vw-lawyer-attorney'))
	),'active_callback' => 'vw_lawyer_attorney_default_slider'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_slider_image_overlay',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_slider_image_overlay',array(
      	'label' => esc_html__( 'Show / Hide Slider Image Overlay','vw-lawyer-attorney' ),
      	'section' => 'vw_lawyer_attorney_slidersettings',
      	'active_callback' => 'vw_lawyer_attorney_default_slider'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_slider_image_overlay_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_slider_image_overlay_color', array(
		'label'    => __('Slider Image Overlay Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_slidersettings',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_slider_arrow_hide_show',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_slider_arrow_hide_show',array(
		'label' => esc_html__( 'Show / Hide Slider Arrows','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_slidersettings',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_slider_prev_icon',array(
		'default'	=> 'fas fa-angle-left',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new vw_lawyer_attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_slider_prev_icon',array(
		'label'	=> __('Add Slider Prev Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_slidersettings',
		'setting'	=> 'vw_lawyer_attorney_slider_prev_icon',
		'type'		=> 'icon',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_slider_next_icon',array(
		'default'	=> 'fas fa-angle-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new vw_lawyer_attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_slider_next_icon',array(
		'label'	=> __('Add Slider Next Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_slidersettings',
		'setting'	=> 'vw_lawyer_attorney_slider_next_icon',
		'type'		=> 'icon',
		'active_callback' => 'vw_lawyer_attorney_default_slider'
	)));


	//Consultation Section
	$wp_customize->add_section('vw_lawyer_attorney_consultation', array(
		'title'       => __('Consultation Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_consultation_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_consultation_text',array(
		'description' => __('<p>1. More options for Consultation section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Consultation section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_consultation',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_consultation_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_consultation_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_consultation',
		'type'=> 'hidden'
	));
    
	//About
	$wp_customize->add_section('vw_lawyer_attorney_about1',array(
		'title'	=> __('About Section','vw-lawyer-attorney'),
		'description' => "For more options of about section </br><a class='go-pro-btn' target='_blank' href='". esc_url(VW_LAWYER_ATTORNEY_GO_PRO) ." '>GET PRO</a>",
		'panel' => 'vw_lawyer_attorney_homepage_panel',
	));

	$args = array('numberposts' => -1);
	$post_list = get_posts($args);
	$posts[]='Select';	
	foreach($post_list as $post){
		$posts[$post->ID] = $post->post_title;
	}
	
	$wp_customize->add_setting('vw_lawyer_attorney_about_setting',array(
		'sanitize_callback' => 'sanitize_text_field',
	));

	$wp_customize->add_control('vw_lawyer_attorney_about_setting',array(
		'type'    => 'select',
		'choices' => $posts,
		'label' => __('Select post','vw-lawyer-attorney'),
		'section' => 'vw_lawyer_attorney_about1',
	));

    $wp_customize->add_setting('vw_lawyer_attorney_about_small_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_about_small_text',array(
		'label'	=> __('Add About Small Text','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_about1',
		'type'=> 'text',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_lawyer_attorney_about_name', array( 
		'selector' => '.about .testbutton a', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_about_name',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_about_name',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_about_name',array(
		'label'	=> __('Add About Button Text','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_about1',
		'type'=> 'text'
	));

	//About excerpt
	$wp_customize->add_setting( 'vw_lawyer_attorney_about_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_about_excerpt_number', array(
		'label'       => esc_html__( 'About Excerpt Length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_about1',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_about_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Why Choose us
	$wp_customize->add_section('vw_lawyer_attorney_amenities_section',array(
		'title'	=> __('Why Choose Us','vw-lawyer-attorney'),
		'description' => "For more options of why choose us section </br><a class='go-pro-btn' target='_blank' href='". esc_url(VW_LAWYER_ATTORNEY_GO_PRO) ." '>GET PRO</a>",
		'priority'	=> null,
		'panel' => 'vw_lawyer_attorney_homepage_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_lawyer_attorney_main_title', array( 
		'selector' => '.choose h3', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_main_title',
	));
	
	$wp_customize->add_setting('vw_lawyer_attorney_main_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));

	$wp_customize->add_control('vw_lawyer_attorney_main_title',array(
		'label'	=> __('Title','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_amenities_section',
		'type'	=> 'text'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cats[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cats[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('vw_lawyer_attorney_blogcategory_setting',array(
		'default'	=> 'select',
		'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices',
	));

	$wp_customize->add_control('vw_lawyer_attorney_blogcategory_setting',array(
		'type'    => 'select',
		'choices' => $cats,
		'label' => __('Select Category to display Latest Post','vw-lawyer-attorney'),
		'section' => 'vw_lawyer_attorney_amenities_section',
	));

	//About excerpt
	$wp_customize->add_setting( 'vw_lawyer_attorney_choose_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_choose_excerpt_number', array(
		'label'       => esc_html__( 'About Excerpt length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_amenities_section',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_choose_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	//Our Services Section
	$wp_customize->add_section('vw_lawyer_attorney_services', array(
		'title'       => __('Our Services Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_services_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_services_text',array(
		'description' => __('<p>1. More options for Our Services section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Our Services section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_services',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_services_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_services_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_services',
		'type'=> 'hidden'
	));

	//Practise Section
	$wp_customize->add_section('vw_lawyer_attorney_practise', array(
		'title'       => __('Practise Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_practise_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_practise_text',array(
		'description' => __('<p>1. More options for Practise section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Practise section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_practise',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_practise_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_practise_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_practise',
		'type'=> 'hidden'
	));

	//How It Works Section
	$wp_customize->add_section('vw_lawyer_attorney_how it_works', array(
		'title'       => __('How It Works Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_how it_works_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_how it_works_text',array(
		'description' => __('<p>1. More options for How It Works section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for How It Works section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_how it_works',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_how it_works_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_how it_works_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_how it_works',
		'type'=> 'hidden'
	));

	//Attorney Section
	$wp_customize->add_section('vw_lawyer_attorney_sec_attorney', array(
		'title'       => __('Attorney Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_sec_attorney_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_sec_attorney_text',array(
		'description' => __('<p>1. More options for Attorney section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Attorney section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_sec_attorney',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_sec_attorney_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_sec_attorney_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_sec_attorney',
		'type'=> 'hidden'
	));

	//Key To Success Section
	$wp_customize->add_section('vw_lawyer_attorney_success', array(
		'title'       => __('Key To Success Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_success_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_success_text',array(
		'description' => __('<p>1. More options for Key To Success section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Key To Success section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_success',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_success_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_success_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_success',
		'type'=> 'hidden'
	));

	//Testimonials Section
	$wp_customize->add_section('vw_lawyer_attorney_testimonials', array(
		'title'       => __('Testimonials Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_testimonials_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_testimonials_text',array(
		'description' => __('<p>1. More options for Testimonials section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Testimonials section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_testimonials',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_testimonials_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_testimonials_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_testimonials',
		'type'=> 'hidden'
	));

	//Our Client Section
	$wp_customize->add_section('vw_lawyer_attorney_client', array(
		'title'       => __('Our Client Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_client_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_client_text',array(
		'description' => __('<p>1. More options for Our Client section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Our Client section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_client',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_client_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_client_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_client',
		'type'=> 'hidden'
	));

	//Latest Post Section
	$wp_customize->add_section('vw_lawyer_attorney_latest_post', array(
		'title'       => __('Latest Post Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_latest_post_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_latest_post_text',array(
		'description' => __('<p>1. More options for Latest Post section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Latest Post section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_latest_post',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_latest_post_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_latest_post_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_latest_post',
		'type'=> 'hidden'
	));

	//Newsletter Section
	$wp_customize->add_section('vw_lawyer_attorney_newsletter', array(
		'title'       => __('Newsletter Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_newsletter_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_newsletter_text',array(
		'description' => __('<p>1. More options for Newsletter section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Newsletter section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_newsletter',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_newsletter_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_newsletter_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_newsletter',
		'type'=> 'hidden'
	));

	//Faqs Section
	$wp_customize->add_section('vw_lawyer_attorney_faqs', array(
		'title'       => __('Faqs Section', 'vw-lawyer-attorney'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-lawyer-attorney'),
		'priority'    => null,
		'panel'       => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_faqs_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_faqs_text',array(
		'description' => __('<p>1. More options for Faqs section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for Faqs section.</p>','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_faqs',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_faqs_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_faqs_btn',array(
		'description' => "<a class='go-pro' target='_blank' href=".esc_url(VW_LAWYER_ATTORNEY_GO_PRO).">More Info</a>",
		'section'=> 'vw_lawyer_attorney_faqs',
		'type'=> 'hidden'
	));

	//footer
	$wp_customize->add_section('vw_lawyer_attorney_footer_section',array(
		'title'	=> __('Footer Text','vw-lawyer-attorney'),
		'description' => "For more options of footer section </br><a class='go-pro-btn' target='_blank' href='". esc_url(VW_LAWYER_ATTORNEY_GO_PRO) ." '>GET PRO</a>",
		'priority'	=> null,
		'panel' => 'vw_lawyer_attorney_homepage_panel',
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_footer_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
   ));
   $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_footer_hide_show',array(
      'label' => esc_html__( 'Show / Hide Footer','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_footer_section'
   )));

 	// font size
	$wp_customize->add_setting('vw_lawyer_attorney_button_footer_font_size',array(
		'default'=> 20,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_footer_font_size',array(
		'label'	=> __('Footer Heading Font Size','vw-lawyer-attorney'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_lawyer_attorney_footer_section',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_button_footer_heading_letter_spacing',array(
		'default'=> 2,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_footer_heading_letter_spacing',array(
		'label'	=> __('Heading Letter Spacing','vw-lawyer-attorney'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
	),
		'section'=> 'vw_lawyer_attorney_footer_section',
	));

	// text trasform
	$wp_customize->add_setting('vw_lawyer_attorney_button_footer_text_transform',array(
		'default'=> 'Capitalize',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_footer_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Heading Text Transform','vw-lawyer-attorney'),
		'choices' => array(
      'Uppercase' => __('Uppercase','vw-lawyer-attorney'),
      'Capitalize' => __('Capitalize','vw-lawyer-attorney'),
      'Lowercase' => __('Lowercase','vw-lawyer-attorney'),
    ),
		'section'=> 'vw_lawyer_attorney_footer_section',
	));

	$wp_customize->add_setting('vw_lawyer_attorney_footer_heading_weight',array(
        'default' => 600,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_heading_weight',array(
        'type' => 'select',
        'label' => __('Heading Font Weight','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'choices' => array(
        	'100' => __('100','vw-lawyer-attorney'),
            '200' => __('200','vw-lawyer-attorney'),
            '300' => __('300','vw-lawyer-attorney'),
            '400' => __('400','vw-lawyer-attorney'),
            '500' => __('500','vw-lawyer-attorney'),
            '600' => __('600','vw-lawyer-attorney'),
            '700' => __('700','vw-lawyer-attorney'),
            '800' => __('800','vw-lawyer-attorney'),
            '900' => __('900','vw-lawyer-attorney'),
        ),
	) );

   $wp_customize->add_setting('vw_lawyer_attorney_footer_template',array(
      'default'	=> esc_html('vw_lawyer_attorney-footer-one'),
      'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'	
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_template',array(
      'label'	=> esc_html__('Footer style','vw-lawyer-attorney'),
      'section'	=> 'vw_lawyer_attorney_footer_section',
      'setting'	=> 'vw_lawyer_attorney_footer_template',
      'type' => 'select',
      'choices' => array(
         'vw_lawyer_attorney-footer-one' => esc_html__('Style 1', 'vw-lawyer-attorney'),
         'vw_lawyer_attorney-footer-two' => esc_html__('Style 2', 'vw-lawyer-attorney'),
         'vw_lawyer_attorney-footer-three' => esc_html__('Style 3', 'vw-lawyer-attorney'),
         'vw_lawyer_attorney-footer-four' => esc_html__('Style 4', 'vw-lawyer-attorney'),
         'vw_lawyer_attorney-footer-five' => esc_html__('Style 5', 'vw-lawyer-attorney'),
      )
	));

	$wp_customize->add_setting('vw_lawyer_attorney_footer_background_color', array(
		'default'           => '#090909',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_footer_background_color', array(
		'label'    => __('Footer Background Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_footer_section',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_footer_background_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'vw_lawyer_attorney_footer_background_image',array(
        'label' => __('Footer Background Image','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_footer_img_position',array(
	  'default' => 'center center',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','vw-lawyer-attorney'),
		'section' => 'vw_lawyer_attorney_footer_section',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'vw-lawyer-attorney' ),
			'center top'   => esc_html__( 'Top', 'vw-lawyer-attorney' ),
			'right top'   => esc_html__( 'Top Right', 'vw-lawyer-attorney' ),
			'left center'   => esc_html__( 'Left', 'vw-lawyer-attorney' ),
			'center center'   => esc_html__( 'Center', 'vw-lawyer-attorney' ),
			'right center'   => esc_html__( 'Right', 'vw-lawyer-attorney' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'vw-lawyer-attorney' ),
			'center bottom'   => esc_html__( 'Bottom', 'vw-lawyer-attorney' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'vw-lawyer-attorney' ),
		),
	));

	// Footer
	$wp_customize->add_setting('vw_lawyer_attorney_img_footer',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_img_footer',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','vw-lawyer-attorney'),
		'choices' => array(
            'fixed' => __('fixed','vw-lawyer-attorney'),
            'scroll' => __('scroll','vw-lawyer-attorney'),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
	));

	// footer padding
	$wp_customize->add_setting('vw_lawyer_attorney_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_padding',array(
		'label'	=> __('Footer Top Bottom Padding','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
      'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
    ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_footer_copy', array( 
		'selector' => '.footer-2 .copyright p', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_footer_copy', 
	));

	$wp_customize->add_setting('vw_lawyer_attorney_footer_widgets_heading',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_widgets_heading',array(
        'type' => 'select',
        'label' => __('Footer Widget Heading','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'choices' => array(
        	'Left' => __('Left','vw-lawyer-attorney'),
            'Center' => __('Center','vw-lawyer-attorney'),
            'Right' => __('Right','vw-lawyer-attorney')
        ),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_footer_widgets_content',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_footer_widgets_content',array(
        'type' => 'select',
        'label' => __('Footer Widget Content','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'choices' => array(
        	'Left' => __('Left','vw-lawyer-attorney'),
            'Center' => __('Center','vw-lawyer-attorney'),
            'Right' => __('Right','vw-lawyer-attorney')
        ),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_copyright_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_copyright_hide_show',array(
      'label' => esc_html__( 'Show / Hide Copyright','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_footer_section'
    )));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_background_color', array(
		'default'           => '#090909',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_footer_section',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_text_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_copyright_text_color', array(
		'label'    => __('Copyright Text Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_footer_section',
	)));
	
	$wp_customize->add_setting('vw_lawyer_attorney_footer_copy',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('vw_lawyer_attorney_footer_copy',array(
		'label'	=> __('Copyright Text','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_footer_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_copyright_font_size',array(
		'label'	=> __('Copyright Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_font_weight',array(
	  'default' => 400,
	  'transport' => 'refresh',
	  'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_copyright_font_weight',array(
	    'type' => 'select',
	    'label' => __('Copyright Font Weight','vw-lawyer-attorney'),
	    'section' => 'vw_lawyer_attorney_footer_section',
	    'choices' => array(
	    	'100' => __('100','vw-lawyer-attorney'),
	        '200' => __('200','vw-lawyer-attorney'),
	        '300' => __('300','vw-lawyer-attorney'),
	        '400' => __('400','vw-lawyer-attorney'),
	        '500' => __('500','vw-lawyer-attorney'),
	        '600' => __('600','vw-lawyer-attorney'),
	        '700' => __('700','vw-lawyer-attorney'),
	        '800' => __('800','vw-lawyer-attorney'),
	        '900' => __('900','vw-lawyer-attorney'),
    ),
	));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_copyright_padding_top_bottom',array(
		'label'	=> __('Copyright Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_copyright_alingment',array(
        'default' => 'center',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Image_Radio_Control($wp_customize, 'vw_lawyer_attorney_copyright_alingment', array(
        'type' => 'select',
        'label' => __('Copyright Alignment','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'settings' => 'vw_lawyer_attorney_copyright_alingment',
        'choices' => array(
            'left' => esc_url(get_template_directory_uri()).'/images/copyright1.png',
            'center' => esc_url(get_template_directory_uri()).'/images/copyright2.png',
            'right' => esc_url(get_template_directory_uri()).'/images/copyright3.png'
    ))));

	$wp_customize->add_setting( 'vw_lawyer_attorney_hide_show_scroll',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_hide_show_scroll',array(
      	'label' => esc_html__( 'Show / Hide Scroll To Top','vw-lawyer-attorney' ),
      	'section' => 'vw_lawyer_attorney_footer_section'
    )));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_scroll_top_icon', array( 
		'selector' => '.scrollup i', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_scroll_top_icon', 
	));

    $wp_customize->add_setting('vw_lawyer_attorney_scroll_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_scroll_top_icon',array(
		'label'	=> __('Add Scroll to Top Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_footer_section',
		'setting'	=> 'vw_lawyer_attorney_scroll_top_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_scroll_to_top_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_scroll_to_top_font_size',array(
		'label'	=> __('Icon Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_scroll_to_top_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_scroll_to_top_padding',array(
		'label'	=> __('Icon Top Bottom Padding','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_scroll_to_top_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_scroll_to_top_width',array(
		'label'	=> __('Icon Width','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_scroll_to_top_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_scroll_to_top_height',array(
		'label'	=> __('Icon Height','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_footer_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_scroll_to_top_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_scroll_to_top_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_footer_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_scroll_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Image_Radio_Control($wp_customize, 'vw_lawyer_attorney_scroll_top_alignment', array(
        'type' => 'select',
        'label' => __('Scroll To Top','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'settings' => 'vw_lawyer_attorney_scroll_top_alignment',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/images/layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/layout2.png',
            'Right' => esc_url(get_template_directory_uri()).'/images/layout3.png'
    ))));

    // footer social icon
	$wp_customize->add_setting( 'vw_lawyer_attorney_footer_icon',array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	) );
	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_footer_icon',array(
		'label' => esc_html__( 'Show / Hide Footer Social Icon','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_footer_section'
  	)));

    $wp_customize->add_setting('vw_lawyer_attorney_align_footer_social_icon',array(
        'default' => 'center',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_align_footer_social_icon',array(
        'type' => 'select',
        'label' => __('Social Icon Alignment ','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_footer_section',
        'choices' => array(
            'left' => __('Left','vw-lawyer-attorney'),
            'right' => __('Right','vw-lawyer-attorney'),
            'center' => __('Center','vw-lawyer-attorney'),
        ),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_copyright_sticky',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_copyright_sticky',array(
      'label' => esc_html__( 'Show / Hide Sticky Copyright','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_footer_section'
    )));

   $wp_customize->add_setting('vw_lawyer_attorney_footer_social_icons_font_size',array(
       'default'=> 16,
       'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('vw_lawyer_attorney_footer_social_icons_font_size',array(
    'label' => __('Social Icon Font Size','vw-lawyer-attorney'),
    	'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_lawyer_attorney_footer_section',
	 ));

	//Blog Post Settings
	$wp_customize->add_panel( 'vw_lawyer_attorney_blog_post_parent_panel', array(
		'title' => esc_html__( 'Blog Post Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_panel_id',
		'priority' => 20,
	));

	//Post Settings
	$wp_customize->add_section( 'vw_lawyer_attorney_post_settings', array(
		'title' => __( 'Post Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_blog_post_parent_panel',
	));

	//Blog layout
    $wp_customize->add_setting('vw_lawyer_attorney_blog_layout_option',array(
        'default' => 'Default',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
    ));
    $wp_customize->add_control(new VW_Lawyer_Attorney_Image_Radio_Control($wp_customize, 'vw_lawyer_attorney_blog_layout_option', array(
        'type' => 'select',
        'label' => __('Blog Layouts','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_post_settings',
        'choices' => array(
            'Default' => esc_url(get_template_directory_uri()).'/images/blog-layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/images/blog-layout2.png',
            'Left' => esc_url(get_template_directory_uri()).'/images/blog-layout3.png',
    ))));

	// Add Settings and Controls for Layout
	$wp_customize->add_setting('vw_lawyer_attorney_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'	        
	));
	$wp_customize->add_control('vw_lawyer_attorney_theme_options', array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','vw-lawyer-attorney'),
        'description' => __('Here you can change the sidebar layout for posts. ','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_post_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-lawyer-attorney'),
            'Right Sidebar' => __('Right Sidebar','vw-lawyer-attorney'),
            'One Column' => __('One Column','vw-lawyer-attorney'),
            'Three Columns' => __('Three Columns','vw-lawyer-attorney'),
            'Four Columns' => __('Four Columns','vw-lawyer-attorney'),
            'Grid Layout' => __('Grid Layout','vw-lawyer-attorney')
        ),
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_toggle_postdate', array( 
		'selector' => '.postbox h2 a', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_toggle_postdate', 
	));

  	$wp_customize->add_setting('vw_lawyer_attorney_toggle_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_toggle_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_post_settings',
		'setting'	=> 'vw_lawyer_attorney_toggle_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_toggle_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_toggle_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_post_settings'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_toggle_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_toggle_author_icon',array(
		'label'	=> __('Add Author Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_post_settings',
		'setting'	=> 'vw_lawyer_attorney_toggle_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_post_settings'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_toggle_comments_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_toggle_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_post_settings',
		'setting'	=> 'vw_lawyer_attorney_toggle_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_post_settings'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_toggle_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_toggle_time_icon',array(
		'label'	=> __('Add Time Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_post_settings',
		'setting'	=> 'vw_lawyer_attorney_toggle_time_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_post_settings'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_featured_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_featured_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_post_settings'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_featured_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Featured Image Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Featured Image
	$wp_customize->add_setting('vw_lawyer_attorney_blog_post_featured_image_dimension',array(
       'default' => 'default',
       'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
  	$wp_customize->add_control('vw_lawyer_attorney_blog_post_featured_image_dimension',array(
		'type' => 'select',
		'label'	=> __('Blog Post Featured Image Dimension','vw-lawyer-attorney'),
		'section'	=> 'vw_lawyer_attorney_post_settings',
		'choices' => array(
		'default' => __('Default','vw-lawyer-attorney'),
		'custom' => __('Custom Image Size','vw-lawyer-attorney'),
      ),
  	));

	$wp_customize->add_setting('vw_lawyer_attorney_blog_post_featured_image_custom_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
		));
	$wp_customize->add_control('vw_lawyer_attorney_blog_post_featured_image_custom_width',array(
		'label'	=> __('Featured Image Custom Width','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'vw-lawyer-attorney' ),),
		'section'=> 'vw_lawyer_attorney_post_settings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_blog_post_featured_image_dimension'
		));

	$wp_customize->add_setting('vw_lawyer_attorney_blog_post_featured_image_custom_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_blog_post_featured_image_custom_height',array(
		'label'	=> __('Featured Image Custom Height','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'vw-lawyer-attorney' ),),
		'section'=> 'vw_lawyer_attorney_post_settings',
		'type'=> 'text',
		'active_callback' => 'vw_lawyer_attorney_blog_post_featured_image_dimension'
	));

    $wp_customize->add_setting( 'vw_lawyer_attorney_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_post_settings',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-lawyer-attorney'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_post_settings',
		'type'=> 'text'
	));

    $wp_customize->add_setting('vw_lawyer_attorney_blog_page_posts_settings',array(
        'default' => 'Into Blocks',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_blog_page_posts_settings',array(
        'type' => 'select',
        'label' => __('Display Blog Posts','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_post_settings',
        'choices' => array(
        	'Into Blocks' => __('Into Blocks','vw-lawyer-attorney'),
            'Without Blocks' => __('Without Blocks','vw-lawyer-attorney')
        ),
	) );

    $wp_customize->add_setting('vw_lawyer_attorney_excerpt_settings',array(
        'default' => 'Excerpt',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_excerpt_settings',array(
        'type' => 'select',
        'label' => __('Post Content','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_post_settings',
        'choices' => array(
        	'Content' => __('Content','vw-lawyer-attorney'),
            'Excerpt' => __('Excerpt','vw-lawyer-attorney'),
            'No Content' => __('No Content','vw-lawyer-attorney')
        ),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_post_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_blog_pagination_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_blog_pagination_hide_show',array(
      'label' => esc_html__( 'Show / Hide Blog Pagination','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_post_settings'
    )));

	$wp_customize->add_setting( 'vw_lawyer_attorney_blog_pagination_type', array(
        'default'			=> 'blog-page-numbers',
        'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
    ));
    $wp_customize->add_control( 'vw_lawyer_attorney_blog_pagination_type', array(
        'section' => 'vw_lawyer_attorney_post_settings',
        'type' => 'select',
        'label' => __( 'Blog Pagination', 'vw-lawyer-attorney' ),
        'choices'		=> array(
            'blog-page-numbers'  => __( 'Numeric', 'vw-lawyer-attorney' ),
            'next-prev' => __( 'Older Posts/Newer Posts', 'vw-lawyer-attorney' ),
    )));

    // Button Settings
	$wp_customize->add_section( 'vw_lawyer_attorney_button_settings', array(
		'title' => __( 'Button Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_button_text', array( 
		'selector' => '.postbox .testbutton a', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_button_text', 
	));

	 $wp_customize->add_setting('vw_lawyer_attorney_button_text',array(
		'default'=> esc_html__( 'Read Full', 'vw-lawyer-attorney' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_text',array(
		'label'	=> __('Add Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Read Full', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_button_settings',
		'type'=> 'text'
	));

	// font size button
	$wp_customize->add_setting('vw_lawyer_attorney_button_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_font_size',array(
		'label'	=> __('Button Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_lawyer_attorney_button_settings',
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_button_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_button_border_radius', array(
		'label'       => esc_html__( 'Button Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_button_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_button_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_padding_top_bottom',array(
		'label'	=> __('Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_button_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_padding_left_right',array(
		'label'	=> __('Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_button_letter_spacing',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_letter_spacing',array(
		'label'	=> __('Button Letter Spacing','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_lawyer_attorney_button_settings',
	));

	// text trasform
	$wp_customize->add_setting('vw_lawyer_attorney_button_text_transform',array(
		'default'=> 'Uppercase',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_button_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Button Text Transform','vw-lawyer-attorney'),
		'choices' => array(
            'Uppercase' => __('Uppercase','vw-lawyer-attorney'),
            'Capitalize' => __('Capitalize','vw-lawyer-attorney'),
            'Lowercase' => __('Lowercase','vw-lawyer-attorney'),
        ),
		'section'=> 'vw_lawyer_attorney_button_settings',
	));

	// Related Post Settings
	$wp_customize->add_section( 'vw_lawyer_attorney_related_posts_settings', array(
		'title' => __( 'Related Posts Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_lawyer_attorney_related_post_title', array( 
		'selector' => '.related-post h3', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_related_post_title', 
	));

    $wp_customize->add_setting( 'vw_lawyer_attorney_related_post',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_post',array(
		'label' => esc_html__( 'Show / Hide Related Post','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_related_posts_settings'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_related_post_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_related_post_title',array(
		'label'	=> __('Add Related Post Title','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Related Post', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_related_posts_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('vw_lawyer_attorney_related_posts_count',array(
		'default'=> '3',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_float'
	));
	$wp_customize->add_control('vw_lawyer_attorney_related_posts_count',array(
		'label'	=> __('Add Related Post Count','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '3', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_related_posts_settings',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_posts_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_related_posts_excerpt_number', array(
		'label'       => esc_html__( 'Related Posts Excerpt length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_related_posts_settings',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_related_posts_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_toggle_postdate',array(
	   'default' => 1,
	   'transport' => 'refresh',
	   'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	));
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_toggle_postdate',array(
    	'label' => esc_html__( 'Show / Hide Post Date','vw-lawyer-attorney' ),
    	'section' => 'vw_lawyer_attorney_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_related_postdate_icon',array(
    	'default' => 'fas fa-calendar-alt',
    	'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_lawyer_attorney_related_postdate_icon',array(
    	'label' => __('Add Post Date Icon','vw-lawyer-attorney'),
    	'transport' => 'refresh',
    	'section' => 'vw_lawyer_attorney_related_posts_settings',
    	'setting' => 'vw_lawyer_attorney_related_postdate_icon',
    	'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	));
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_related_author_icon',array(
    	'default' => 'fas fa-user',
    	'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_lawyer_attorney_related_author_icon',array(
    	'label' => __('Add Author Icon','vw-lawyer-attorney'),
    	'transport' => 'refresh',
    	'section' => 'vw_lawyer_attorney_related_posts_settings',
    	'setting' => 'vw_lawyer_attorney_related_author_icon',
    	'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	) );
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_related_comments_icon',array(
    	'default' => 'fa fa-comments',
    	'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_lawyer_attorney_related_comments_icon',array(
    	'label' => __('Add Comments Icon','vw-lawyer-attorney'),
    	'transport' => 'refresh',
    	'section' => 'vw_lawyer_attorney_related_posts_settings',
    	'setting' => 'vw_lawyer_attorney_related_comments_icon',
    	'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	) );
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_related_time_icon',array(
    	'default' => 'fas fa-clock',
    	'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_lawyer_attorney_related_time_icon',array(
    	'label' => __('Add Time Icon','vw-lawyer-attorney'),
    	'transport' => 'refresh',
    	'section' => 'vw_lawyer_attorney_related_posts_settings',
    	'setting' => 'vw_lawyer_attorney_related_time_icon',
    	'type'    => 'icon'
  	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_related_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_related_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-lawyer-attorney'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_related_posts_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_related_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_related_posts_settings'
  	)));

  	$wp_customize->add_setting( 'vw_lawyer_attorney_related_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_related_image_box_shadow', array(
		'label'       => esc_html__( 'Related post Image Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_related_posts_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

  	$wp_customize->add_setting('vw_lawyer_attorney_related_button_text',array(
		'default'=> esc_html__('Read More','vw-lawyer-attorney'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_related_button_text',array(
		'label'	=> esc_html__('Add Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
      'placeholder' => esc_html__( 'Read More', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_related_posts_settings',
		'type'=> 'text'
	));

	// Single Posts Settings
	$wp_customize->add_section( 'vw_lawyer_attorney_single_blog_settings', array(
		'title' => __( 'Single Post Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_blog_post_parent_panel',
	));

  	$wp_customize->add_setting('vw_lawyer_attorney_single_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_single_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_single_blog_settings',
		'setting'	=> 'vw_lawyer_attorney_single_postdate_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_single_postdate',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_postdate',array(
	    'label' => esc_html__( 'Show / Hide Date','vw-lawyer-attorney' ),
	   'section' => 'vw_lawyer_attorney_single_blog_settings'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_single_author_icon',array(
		'label'	=> __('Add Author Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_single_blog_settings',
		'setting'	=> 'vw_lawyer_attorney_single_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_single_author',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_author',array(
	    'label' => esc_html__( 'Show / Hide Author','vw-lawyer-attorney' ),
	    'section' => 'vw_lawyer_attorney_single_blog_settings'
	)));

   	$wp_customize->add_setting('vw_lawyer_attorney_single_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_single_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_single_blog_settings',
		'setting'	=> 'vw_lawyer_attorney_single_comments_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_comments',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_comments',array(
	    'label' => esc_html__( 'Show / Hide Comments','vw-lawyer-attorney' ),
	    'section' => 'vw_lawyer_attorney_single_blog_settings'
	)));

  	$wp_customize->add_setting('vw_lawyer_attorney_single_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_single_time_icon',array(
		'label'	=> __('Add Time Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_single_blog_settings',
		'setting'	=> 'vw_lawyer_attorney_single_time_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_time',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	) );

	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_time',array(
	    'label' => esc_html__( 'Show / Hide Time','vw-lawyer-attorney' ),
	    'section' => 'vw_lawyer_attorney_single_blog_settings'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_post_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_post_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Breadcrumb','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_single_blog_settings'
    )));

    // Single Posts Category
  	$wp_customize->add_setting( 'vw_lawyer_attorney_single_post_category',array(
		'default' => true,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_post_category',array(
		'label' => esc_html__( 'Show / Hide Category','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_single_blog_settings'
    )));

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_tags',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_tags', array(
		'label' => esc_html__( 'Show / Hide Tags','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_single_blog_settings'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_singlepost_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_singlepost_image_box_shadow', array(
		'label'       => esc_html__( 'Single post Image Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_single_blog_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );


	$wp_customize->add_setting('vw_lawyer_attorney_single_post_meta_field_separator',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_single_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-lawyer-attorney'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_blog_post_navigation_show_hide',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_blog_post_navigation_show_hide', array(
		'label' => esc_html__( 'Show / Hide Post Navigation','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_single_blog_settings'
    )));

	//navigation text
	$wp_customize->add_setting('vw_lawyer_attorney_single_blog_prev_navigation_text',array(
		'default'=> 'PREVIOUS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_single_blog_prev_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'PREVIOUS', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_single_blog_next_navigation_text',array(
		'default'=> 'NEXT',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_single_blog_next_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'NEXT', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_single_blog_comment_title',array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_single_blog_comment_title',array(
		'label'	=> __('Add Comment Title','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Leave a Reply', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_single_blog_comment_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_single_blog_comment_button_text',array(
		'label'	=> __('Add Comment Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Post Comment', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_single_blog_comment_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_single_blog_comment_width',array(
		'label'	=> __('Comment Form Width','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in %. Example:50%','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '100%', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_single_blog_settings',
		'type'=> 'text'
	));

	// Grid layout setting
	$wp_customize->add_section( 'vw_lawyer_attorney_grid_layout_settings', array(
		'title' => __( 'Grid Layout Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_blog_post_parent_panel',
	));

  	$wp_customize->add_setting('vw_lawyer_attorney_grid_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new vw_lawyer_attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_grid_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_grid_layout_settings',
		'setting'	=> 'vw_lawyer_attorney_grid_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_lawyer_attorney_grid_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_grid_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_grid_layout_settings'
    )));

	$wp_customize->add_setting('vw_lawyer_attorney_grid_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new vw_lawyer_attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_grid_author_icon',array(
		'label'	=> __('Add Author Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_grid_layout_settings',
		'setting'	=> 'vw_lawyer_attorney_grid_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_grid_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_grid_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_grid_layout_settings'
    )));

   	$wp_customize->add_setting('vw_lawyer_attorney_grid_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new vw_lawyer_attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_grid_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_grid_layout_settings',
		'setting'	=> 'vw_lawyer_attorney_grid_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_grid_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_grid_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_grid_layout_settings'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_grid_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
	));
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_grid_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_grid_layout_settings'
  	)));
    
	$wp_customize->add_setting('vw_lawyer_attorney_grid_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_grid_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-lawyer-attorney'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-lawyer-attorney'),
		'section'=> 'vw_lawyer_attorney_grid_layout_settings',
		'type'=> 'text'
	));

	 $wp_customize->add_setting( 'vw_lawyer_attorney_grid_excerpt_number', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_grid_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_grid_layout_settings',
		'type'        => 'range',
		'settings'    => 'vw_lawyer_attorney_grid_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

  	$wp_customize->add_setting('vw_lawyer_attorney_grid_button_text',array(
		'default'=> esc_html__('Read More','vw-lawyer-attorney'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_grid_button_text',array(
		'label'	=> esc_html__('Add Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'Read More', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_grid_layout_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_display_grid_posts_settings',array(
        'default' => 'Into Blocks',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_display_grid_posts_settings',array(
        'type' => 'select',
        'label' => __('Display Grid Posts','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_grid_layout_settings',
        'choices' => array(
        	'Into Blocks' => __('Into Blocks','vw-lawyer-attorney'),
            'Without Blocks' => __('Without Blocks','vw-lawyer-attorney')
        ),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_grid_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_grid_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_grid_layout_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_grid_excerpt_settings',array(
      'default' => 'Excerpt',
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_grid_excerpt_settings',array(
      'type' => 'select',
      'label' => esc_html__('Grid Post Content','vw-lawyer-attorney'),
      'section' => 'vw_lawyer_attorney_grid_layout_settings',
      'choices' => array(
        	'Content' => esc_html__('Content','vw-lawyer-attorney'),
         'Excerpt' => esc_html__('Excerpt','vw-lawyer-attorney'),
         'No Content' => esc_html__('No Content','vw-lawyer-attorney')
      ),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_grid_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_grid_featured_image_border_radius', array(
		'label'       => esc_html__( 'Grid Featured Image Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_grid_layout_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_grid_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_grid_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Grid Featured Image Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_grid_layout_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Others Settings
	$wp_customize->add_panel( 'vw_lawyer_attorney_others_panel', array(
		'title' => esc_html__( 'Others Settings', 'vw-lawyer-attorney' ),
		'panel' => 'vw_lawyer_attorney_panel_id',
		'priority' => 20,
	));

	$wp_customize->add_section( 'vw_lawyer_attorney_left_right', array(
    	'title'      => esc_html__( 'General Settings', 'vw-lawyer-attorney' ),
		'priority'   => 30,
		'panel' => 'vw_lawyer_attorney_others_panel'
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_width_option',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Lawyer_Attorney_Image_Radio_Control($wp_customize, 'vw_lawyer_attorney_width_option', array(
        'type' => 'select',
        'label' => __('Width Layouts','vw-lawyer-attorney'),
        'description' => __('Here you can change the width layout of Website.','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_left_right',
        'choices' => array(
            'Full Width' => esc_url(get_template_directory_uri()).'/images/full-width.png',
            'Wide Width' => esc_url(get_template_directory_uri()).'/images/wide-width.png',
            'Boxed' => esc_url(get_template_directory_uri()).'/images/boxed-width.png',
    ))));

	$wp_customize->add_setting('vw_lawyer_attorney_page_layout',array(
        'default' => 'One Column',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_page_layout',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','vw-lawyer-attorney'),
        'description' => __('Here you can change the sidebar layout for pages. ','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-lawyer-attorney'),
            'Right Sidebar' => __('Right Sidebar','vw-lawyer-attorney'),
            'One Column' => __('One Column','vw-lawyer-attorney')
        ),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_single_page_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_single_page_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Page Breadcrumb','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_left_right'
    )));

	//Wow Animation
	$wp_customize->add_setting( 'vw_lawyer_attorney_animation',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_animation',array(
        'label' => esc_html__( 'Show / Hide Animations','vw-lawyer-attorney' ),
        'description' => __('Here you can disable overall site animation effect','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_left_right'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_reset_all_settings',array(
      'sanitize_callback'	=> 'sanitize_text_field',
   	));
   	$wp_customize->add_control(new VW_Lawyer_Attorney_Reset_Custom_Control($wp_customize, 'vw_lawyer_attorney_reset_all_settings',array(
      'type' => 'reset_control',
      'label' => __('Reset All Settings', 'vw-lawyer-attorney'),
      'description' => 'vw_lawyer_attorney_reset_all_settings',
      'section' => 'vw_lawyer_attorney_left_right'
   	)));

	//Pre-Loader
	$wp_customize->add_setting( 'vw_lawyer_attorney_loader_enable',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_loader_enable',array(
        'label' => esc_html__( 'Show / Hide Pre-Loader','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_left_right'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_preloader_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_preloader_bg_color', array(
		'label'    => __('Pre-Loader Background Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_left_right',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_preloader_border_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_preloader_border_color', array(
		'label'    => __('Pre-Loader Border Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_left_right',
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_preloader_bg_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'vw_lawyer_attorney_preloader_bg_img',array(
        'label' => __('Preloader Background Image','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_left_right'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_breadcrumbs_alignment',array(
        'default' => 'Left',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_breadcrumbs_alignment',array(
        'type' => 'select',
        'label' => __('Breadcrumbs Alignment','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_left_right',
        'choices' => array(
            'Left' => __('Left','vw-lawyer-attorney'),
            'Right' => __('Right','vw-lawyer-attorney'),
            'Center' => __('Center','vw-lawyer-attorney'),
        ),
	) );

    //404 Page Setting
	$wp_customize->add_section('vw_lawyer_attorney_404_page',array(
		'title'	=> __('404 Page Settings','vw-lawyer-attorney'),
		'panel' => 'vw_lawyer_attorney_others_panel',
	));	

	$wp_customize->add_setting('vw_lawyer_attorney_404_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_404_page_title',array(
		'label'	=> __('Add Title','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '404 Not Found', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_404_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_404_page_content',array(
		'label'	=> __('Add Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Looks like you have taken a wrong turn, Dont worry, it happens to the best of us.', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_404_page_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_404_page_button_text',array(
		'label'	=> __('Add Button Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Return to Home Page', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_404_page',
		'type'=> 'text'
	));

	//No Result Page Setting
	$wp_customize->add_section('vw_lawyer_attorney_no_results_page',array(
		'title'	=> __('No Results Page Settings','vw-lawyer-attorney'),
		'panel' => 'vw_lawyer_attorney_others_panel',
	));	

	$wp_customize->add_setting('vw_lawyer_attorney_no_results_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_no_results_page_title',array(
		'label'	=> __('Add Title','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Nothing Found', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_no_results_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_no_results_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_lawyer_attorney_no_results_page_content',array(
		'label'	=> __('Add Text','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_no_results_page',
		'type'=> 'text'
	));

	//Social Icon Setting
	$wp_customize->add_section('vw_lawyer_attorney_social_icon_settings',array(
		'title'	=> __('Social Icons Settings','vw-lawyer-attorney'),
		'panel' => 'vw_lawyer_attorney_others_panel',
	));	

	$wp_customize->add_setting('vw_lawyer_attorney_social_icon_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_social_icon_font_size',array(
		'label'	=> __('Icon Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_social_icon_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_social_icon_padding',array(
		'label'	=> __('Icon Padding','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_social_icon_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_social_icon_width',array(
		'label'	=> __('Icon Width','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_social_icon_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_social_icon_height',array(
		'label'	=> __('Icon Height','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_social_icon_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_social_icon_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_social_icon_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Responsive Media Settings
	$wp_customize->add_section('vw_lawyer_attorney_responsive_media',array(
		'title'	=> __('Responsive Media','vw-lawyer-attorney'),
		'panel' => 'vw_lawyer_attorney_others_panel',
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_resp_topbar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
  	));  
  	$wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_resp_topbar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Topbar','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_responsive_media'
  	)));

   $wp_customize->add_setting( 'vw_lawyer_attorney_stickyheader_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
   ));  
   $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_stickyheader_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sticky Header','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_responsive_media'
	)));

    $wp_customize->add_setting( 'vw_lawyer_attorney_resp_slider_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_resp_slider_hide_show',array(
      'label' => esc_html__( 'Show / Hide Slider','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_sidebar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_sidebar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sidebar','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_responsive_preloader_hide',array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_responsive_preloader_hide',array(
        'label' => esc_html__( 'Show / Hide Preloader','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_lawyer_attorney_resp_scroll_top_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_resp_scroll_top_hide_show',array(
      'label' => esc_html__( 'Show / Hide Scroll To Top','vw-lawyer-attorney' ),
      'section' => 'vw_lawyer_attorney_responsive_media'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_resp_menu_toggle_btn_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_lawyer_attorney_resp_menu_toggle_btn_bg_color', array(
		'label'    => __('Toggle Button Bg Color', 'vw-lawyer-attorney'),
		'section'  => 'vw_lawyer_attorney_responsive_media',
	)));

    $wp_customize->add_setting('vw_lawyer_attorney_res_open_menu_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_res_open_menu_icon',array(
		'label'	=> __('Add Open Menu Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_responsive_media',
		'setting'	=> 'vw_lawyer_attorney_res_open_menu_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_lawyer_attorney_res_close_menu_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Lawyer_Attorney_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_lawyer_attorney_res_close_menu_icon',array(
		'label'	=> __('Add Close Menu Icon','vw-lawyer-attorney'),
		'transport' => 'refresh',
		'section'	=> 'vw_lawyer_attorney_responsive_media',
		'setting'	=> 'vw_lawyer_attorney_res_close_menu_icon',
		'type'		=> 'icon'
	)));

    //Woocommerce settings
	$wp_customize->add_section('vw_lawyer_attorney_woocommerce_section', array(
		'title'    => __('WooCommerce Layout', 'vw-lawyer-attorney'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));	

    //Shop Page Featured Image
	$wp_customize->add_setting( 'vw_lawyer_attorney_shop_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_shop_featured_image_border_radius', array(
		'label'       => esc_html__( 'Shop Page Featured Image Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_lawyer_attorney_shop_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_shop_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Shop Page Featured Image Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_lawyer_attorney_woocommerce_shop_page_sidebar', array( 'selector' => '.post-type-archive-product .sidebar', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_woocommerce_shop_page_sidebar', ) );

	//Woocommerce Shop Page Sidebar
	$wp_customize->add_setting( 'vw_lawyer_attorney_woocommerce_shop_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_woocommerce_shop_page_sidebar',array(
		'label' => esc_html__( 'Show / Hide Shop Page Sidebar','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_woocommerce_section'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_shop_page_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_shop_page_layout',array(
        'type' => 'select',
        'label' => __('Shop Page Sidebar Layout','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-lawyer-attorney'),
            'Right Sidebar' => __('Right Sidebar','vw-lawyer-attorney'),
        ),
	) );

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_lawyer_attorney_woocommerce_single_product_page_sidebar', array( 'selector' => '.single-product .sidebar', 
		'render_callback' => 'vw_lawyer_attorney_customize_partial_vw_lawyer_attorney_woocommerce_single_product_page_sidebar', ) );

    //Woocommerce Single Product page Sidebar
	$wp_customize->add_setting( 'vw_lawyer_attorney_woocommerce_single_product_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_woocommerce_single_product_page_sidebar',array(
		'label' => esc_html__( 'Show / Hide Single Product Sidebar','vw-lawyer-attorney' ),
		'section' => 'vw_lawyer_attorney_woocommerce_section'
    )));

    $wp_customize->add_setting('vw_lawyer_attorney_single_product_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_single_product_layout',array(
        'type' => 'select',
        'label' => __('Single Product Sidebar Layout','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-lawyer-attorney'),
            'Right Sidebar' => __('Right Sidebar','vw-lawyer-attorney'),
        ),
	) );

    //Products per page
    $wp_customize->add_setting('vw_lawyer_attorney_products_per_page',array(
		'default'=> '9',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_float'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_per_page',array(
		'label'	=> __('Products Per Page','vw-lawyer-attorney'),
		'description' => __('Display on shop page','vw-lawyer-attorney'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'number',
	));

    //Products per row
    $wp_customize->add_setting('vw_lawyer_attorney_products_per_row',array(
		'default'=> '3',
		'sanitize_callback'	=> 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_per_row',array(
		'label'	=> __('Products Per Row','vw-lawyer-attorney'),
		'description' => __('Display on shop page','vw-lawyer-attorney'),
		'choices' => array(
            '2' => '2',
			'3' => '3',
			'4' => '4',
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'select',
	));

	//Products padding
	$wp_customize->add_setting('vw_lawyer_attorney_products_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_padding_top_bottom',array(
		'label'	=> __('Products Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_products_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_padding_left_right',array(
		'label'	=> __('Products Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	//Products box shadow
	$wp_customize->add_setting( 'vw_lawyer_attorney_products_box_shadow', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_products_box_shadow', array(
		'label'       => esc_html__( 'Products Box Shadow','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products border radius
    $wp_customize->add_setting( 'vw_lawyer_attorney_products_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_products_border_radius', array(
		'label'       => esc_html__( 'Products Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_products_btn_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_btn_padding_top_bottom',array(
		'label'	=> __('Products Button Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_products_btn_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_products_btn_padding_left_right',array(
		'label'	=> __('Products Button Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_products_button_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_products_button_border_radius', array(
		'label'       => esc_html__( 'Products Button Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products Sale Badge
	$wp_customize->add_setting('vw_lawyer_attorney_woocommerce_sale_position',array(
        'default' => 'right',
        'sanitize_callback' => 'vw_lawyer_attorney_sanitize_choices'
	));
	$wp_customize->add_control('vw_lawyer_attorney_woocommerce_sale_position',array(
        'type' => 'select',
        'label' => __('Sale Badge Position','vw-lawyer-attorney'),
        'section' => 'vw_lawyer_attorney_woocommerce_section',
        'choices' => array(
            'left' => __('Left','vw-lawyer-attorney'),
            'right' => __('Right','vw-lawyer-attorney'),
        ),
	) );

	$wp_customize->add_setting('vw_lawyer_attorney_woocommerce_sale_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_woocommerce_sale_font_size',array(
		'label'	=> __('Sale Font Size','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_woocommerce_sale_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_woocommerce_sale_padding_top_bottom',array(
		'label'	=> __('Sale Padding Top Bottom','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_lawyer_attorney_woocommerce_sale_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_lawyer_attorney_woocommerce_sale_padding_left_right',array(
		'label'	=> __('Sale Padding Left Right','vw-lawyer-attorney'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-lawyer-attorney'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-lawyer-attorney' ),
        ),
		'section'=> 'vw_lawyer_attorney_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_lawyer_attorney_woocommerce_sale_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_lawyer_attorney_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_lawyer_attorney_woocommerce_sale_border_radius', array(
		'label'       => esc_html__( 'Sale Border Radius','vw-lawyer-attorney' ),
		'section'     => 'vw_lawyer_attorney_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

  	// Related Product
    $wp_customize->add_setting( 'vw_lawyer_attorney_related_product_show_hide',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_lawyer_attorney_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Lawyer_Attorney_Toggle_Switch_Custom_Control( $wp_customize, 'vw_lawyer_attorney_related_product_show_hide',array(
        'label' => esc_html__( 'Show / Hide Related product','vw-lawyer-attorney' ),
        'section' => 'vw_lawyer_attorney_woocommerce_section'
    )));

	// Has to be at the top
	$wp_customize->register_panel_type( 'VW_Lawyer_Attorney_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'VW_Lawyer_Attorney_WP_Customize_Section' );
}
add_action( 'customize_register', 'vw_lawyer_attorney_customize_register' );

load_template( trailingslashit( get_template_directory() ) . '/inc/logo-resizer.php' );

if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class VW_Lawyer_Attorney_WP_Customize_Panel extends WP_Customize_Panel {
	    public $panel;
	    public $type = 'vw_lawyer_attorney_panel';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
 	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class VW_Lawyer_Attorney_WP_Customize_Section extends WP_Customize_Section { 	
	    public $section;
	    public $type = 'vw_lawyer_attorney_section';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}

// Enqueue our scripts and styles
function vw_lawyer_attorney_customize_controls_scripts() {
  wp_enqueue_script( 'customizer-controls', get_theme_file_uri( '/js/customizer-controls.js' ), array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'vw_lawyer_attorney_customize_controls_scripts' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class VW_Lawyer_Attorney_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'VW_Lawyer_Attorney_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(new VW_Lawyer_Attorney_Customize_Section_Pro($manager,
			'vw_lawyer_attorney_upgrade_pro_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'VW Lawyer Pro', 'vw-lawyer-attorney' ),
			'pro_text' => esc_html__( 'Upgarde Pro','vw-lawyer-attorney' ),
			'pro_url'  => esc_url('https://www.buywptemplates.com/products/premium-lawyer-wordpress-theme')
		)));

		// Register sections.
		$manager->add_section(new VW_Lawyer_Attorney_Customize_Section_Pro($manager,
			'vw_lawyer_attorney_get_started_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'Documentation', 'vw-lawyer-attorney' ),
			'pro_text' => esc_html__( 'Docs', 'vw-lawyer-attorney' ),
			'pro_url'  => esc_url( 'https://demos.buywptemplates.com/demo/docs/free-lawyer-attorney/' )
		)));
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'vw-lawyer-attorney-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'vw-lawyer-attorney-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/css/customize-controls.css' );

		wp_localize_script(
		'vw-lawyer-attorney-customize-controls',
		'vw_lawyer_attorney_customizer_params',
		array(
			'ajaxurl' =>	admin_url( 'admin-ajax.php' )
		));
	}
}

// Doing this customizer thang!
VW_Lawyer_Attorney_Customize::get_instance();