<?php
/**
 * VW Lawyer Attorney: Block Patterns
 *
 * @package VW Lawyer Attorney
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-lawyer-attorney',
		array( 'label' => __( 'VW Lawyer Attorney', 'vw-lawyer-attorney' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-lawyer-attorney/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-lawyer-attorney' ),
			'categories' => array( 'vw-lawyer-attorney' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png\",\"id\":3449,\"dimRatio\":60,\"align\":\"full\",\"className\":\"sliderbox\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-60 has-background-dim sliderbox\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider.png)\"><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"className\":\"mx-lg-5 mx-0 px-lg-5\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center mx-lg-5 mx-0 px-lg-5\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"55%\",\"className\":\"slider-content ps-lg-5 ms-lg-5 ps-4 ms-0 px-md-4\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center slider-content ps-lg-5 ms-lg-5 ps-4 ms-0 px-md-4\" style=\"flex-basis:55%\"><!-- wp:heading {\"level\":1,\"className\":\"mb-md-0 mb-4\",\"style\":{\"typography\":{\"fontSize\":30}}} -->\n<h1 class=\"mb-md-0 mb-4\" style=\"font-size:30px\"><strong>Lorem Ipsum&nbsp;is Simply Dummy Text of the Printing and</strong></h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":0,\"textColor\":\"white\",\"className\":\"hvr-sweep-to-right\"} -->\n<div class=\"wp-block-button hvr-sweep-to-right\"><a class=\"wp-block-button__link has-white-color has-text-color no-border-radius\">KNOW MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"className\":\"mt-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center mt-5\" style=\"flex-basis:33.33%\"><!-- wp:image {\"id\":3471,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"slider-img\"} -->\n<figure class=\"wp-block-image size-large slider-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider-img.png\" alt=\"\" class=\"wp-image-3471\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-lawyer-attorney/services-section',
		array(
			'title'      => __( 'Services Section', 'vw-lawyer-attorney' ),
			'categories' => array( 'vw-lawyer-attorney' ),
			'content'    => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"service-box mx-md-5 mx-0 mt-5\"} -->\n<div class=\"wp-block-columns alignwide service-box mx-md-5 mx-0 mt-5\"><!-- wp:column {\"className\":\"service-content mb-4\"} -->\n<div class=\"wp-block-column service-content mb-4\"><!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#333333\"}},\"className\":\"mb-3\"} -->\n<h2 class=\"wp-block-heading has-text-align-left mb-3 has-text-color\" style=\"color:#333333;font-size:18px\"><strong>Welcome to The Lawyer Theme</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontSize\":35},\"color\":{\"text\":\"#c29965\"}},\"className\":\"mb-2 mt-0\"} -->\n<h3 class=\"wp-block-heading mb-2 mt-0 has-text-color\" style=\"color:#c29965;font-size:35px\">20 Years Experience</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#333333\"}},\"className\":\"mb-4\"} -->\n<p class=\"mb-4 has-text-color\" style=\"color:#333333;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"hvr-sweep-to-right\"} -->\n<div class=\"wp-block-button hvr-sweep-to-right\"><a class=\"wp-block-button__link wp-element-button\">DISCOVER MORE ABOUT US</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"chooseus-box\"} -->\n<div class=\"wp-block-column chooseus-box\"><!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services-background.png\",\"id\":3292,\"dimRatio\":0,\"minHeight\":50} -->\n<div class=\"wp-block-cover\" style=\"min-height:50px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-3292\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services-background.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"style\":{\"typography\":{\"fontSize\":30}},\"className\":\"text-left\"} -->\n<h4 class=\"wp-block-heading has-text-align-left text-left\" style=\"font-size:30px\">Why Choose Us?</h4>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"17%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:17%\"><!-- wp:image {\"align\":\"center\",\"id\":3320,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/why-choose-us1.png\" alt=\"\" class=\"wp-image-3320\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"84%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:84%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":5,\"style\":{\"typography\":{\"fontSize\":15}},\"className\":\"mb-2 text-left\"} -->\n<h5 class=\"wp-block-heading has-text-align-left mb-2 text-left\" style=\"font-size:15px\"><strong>Our History</strong></h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":12}},\"className\":\"text-left\"} -->\n<p class=\"has-text-align-left text-left\" style=\"font-size:12px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"mb-0\"} -->\n<div class=\"wp-block-columns mb-0\"><!-- wp:column {\"width\":\"17%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:17%\"><!-- wp:image {\"align\":\"center\",\"id\":3335,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/why-choose-us2.png\" alt=\"\" class=\"wp-image-3335\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"84%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:84%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":5,\"style\":{\"typography\":{\"fontSize\":15}},\"className\":\"mb-2 text-left\"} -->\n<h5 class=\"wp-block-heading has-text-align-left mb-2 text-left\" style=\"font-size:15px\"><strong>Our Mission</strong></h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":12}},\"className\":\"text-left\"} -->\n<p class=\"has-text-align-left text-left\" style=\"font-size:12px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);
}