<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content-vw">
 *
 * @package VW Lawyer Attorney
 */

?><!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php if ( function_exists( 'wp_body_open' ) ) 
  {
    wp_body_open();
  }else{
    do_action('wp_body_open');
  } 
?>

<?php
  $vw_lawyer_attorney_search_hide_show = get_theme_mod( 'vw_lawyer_attorney_search_hide_show' );
  if ( 'Disable' == $vw_lawyer_attorney_search_hide_show ) {
    $colmd = 'col-lg-12 col-md-12';
  } else { 
    $colmd = 'col-lg-11 col-md-10 col-6';
  }
?>

<header role="banner">
  <a class="screen-reader-text skip-link" href="#maincontent"><?php esc_html_e( 'Skip to content', 'vw-lawyer-attorney' ); ?></a>
  <?php if (get_theme_mod('vw_lawyer_attorney_hide_show_topbar_section', true) == 1 || get_theme_mod( 'vw_lawyer_attorney_resp_topbar_hide_show', true) == 1) {  ?>
    <div class="topbar">
      <div class="container">
        <div class="row">
          <div class="col-lg-3 col-md-3">
            <div class="logo">   
              <?php if ( has_custom_logo() ) : ?>
                <div class="site-logo"><?php the_custom_logo(); ?></div>
              <?php endif; ?>
              <?php $blog_info = get_bloginfo( 'name' ); ?>
                <?php if ( ! empty( $blog_info ) ) : ?>
                  <?php if ( is_front_page() && is_home() ) : ?>
                  <?php if( get_theme_mod('vw_lawyer_attorney_logo_title_hide_show',true) == 1){ ?>
                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                  <?php } ?>
                  <?php else : ?>
                    <?php if( get_theme_mod('vw_lawyer_attorney_logo_title_hide_show',true) == 1){ ?>
                      <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                    <?php } ?>
                  <?php endif; ?>
                <?php endif; ?>
                <?php
                  $description = get_bloginfo( 'description', 'display' );
                  if ( $description || is_customize_preview() ) :
                ?>
                <?php if( get_theme_mod('vw_lawyer_attorney_tagline_hide_show',false) == 1){ ?>
                  <p class="site-description">
                    <?php echo esc_html( $description ); ?>
                  </p>
                <?php } ?>
              <?php endif; ?>
            </div>
          </div>        
          <div class="col-lg-9 col-md-9 align-self-lg-center">
            <div class="contact">
              <div class="row">
                <div class="col-lg-4 col-md-4 ">
                  <?php if( get_theme_mod( 'vw_lawyer_attorney_call','' ) != '' || get_theme_mod( 'vw_lawyer_attorney_call1','' ) != '') { ?>
                    <div class="row m-0">
                      <div class="col-lg-2 col-md-3 p-0">
                        <img src="<?php echo esc_url( get_template_directory_uri()) ?>/images/icon2.png" alt="Call Image" role="img">
                      </div>
                      <div class="col-lg-10 col-md-9 call-add">
                        <p class="diff-lay"><a href="tel:<?php echo esc_attr( get_theme_mod('vw_lawyer_attorney_call','') ); ?>"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_call',''));?></a></p>
                        <p class="con-email"><a href="mailto:<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_call1',''));?>"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_call1',''));?></a></p>         
                      </div>
                    </div>
                  <?php }?>
                </div>
                <div class="col-lg-4 col-md-4">
                  <?php if( get_theme_mod( 'vw_lawyer_attorney_location','' ) != '' || get_theme_mod( 'vw_lawyer_attorney_location1','' ) != '') { ?>
                    <div class="row m-0">
                      <div class="col-lg-2 col-md-3 p-0">
                        <img src="<?php echo esc_url( get_template_directory_uri() ) ?>/images/icon1.png" alt="Location Image" role="img">
                      </div>
                      <div class="col-lg-10 col-md-9 call-add">              
                        <p class="diff-lay"><?php echo esc_html( get_theme_mod('vw_lawyer_attorney_location','') ); ?></p>
                        <p><?php echo esc_html( get_theme_mod('vw_lawyer_attorney_location1','') ); ?></p>             
                      </div>
                    </div>
                  <?php }?>
                </div>
                <div class="col-lg-4 col-md-4 p-0">
                  <?php if( get_theme_mod( 'vw_lawyer_attorney_time','' ) != '' || get_theme_mod( 'vw_lawyer_attorney_time1','' ) != '') { ?>
                    <div class="row m-0">
                      <div class="col-lg-2 col-md-3 p-0">
                        <img src="<?php echo esc_url( get_template_directory_uri() ) ?>/images/icon3.png" alt="Time Image" role="img">
                      </div>
                      <div class="col-lg-10 col-md-9">            
                        <p class="diff-lay"><?php echo esc_html( get_theme_mod('vw_lawyer_attorney_time','') ); ?></p>
                        <p><?php echo esc_html( get_theme_mod('vw_lawyer_attorney_time1','') ); ?></p>
                      </div>
                    </div>
                  <?php }?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
  <?php }?>  
  <div class="header <?php if( get_theme_mod( 'vw_lawyer_attorney_sticky_header', false) == 1 || get_theme_mod( 'vw_lawyer_attorney_stickyheader_hide_show', false) == 1) { ?> header-sticky"<?php } else { ?>close-sticky <?php } ?>">
    <div class="container">
      <div class="row m-0">
        <div class="<?php echo esc_html( $colmd ); ?> align-self-center">
          <?php if(has_nav_menu('primary')){ ?>
            <div class="toggle-nav mobile-menu">
              <button onclick="vw_lawyer_attorney_menu_open_nav()" class="responsivetoggle"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_res_open_menu_icon','fas fa-bars')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Open Button','vw-lawyer-attorney'); ?></span></button>
            </div> 
          <?php } ?>
          <div id="mySidenav" class="nav sidenav">
            <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Top Menu', 'vw-lawyer-attorney' ); ?>">
              <?php 
                wp_nav_menu( array( 
                  'theme_location' => 'primary',
                  'container_class' => 'main-menu clearfix' ,
                  'menu_class' => 'clearfix',
                  'items_wrap' => '<ul id="%1$s" class="%2$s mobile_nav">%3$s</ul>',
                  'fallback_cb' => 'wp_page_menu',
                ) ); 
              ?>
              <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="vw_lawyer_attorney_menu_close_nav()"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_res_close_menu_icon','fas fa-times')); ?>"></i><span class="screen-reader-text"><?php esc_html_e('Close Button','vw-lawyer-attorney'); ?></span></a>
            </nav>
          </div>
        </div>
        <?php if ( 'Disable' != $vw_lawyer_attorney_search_hide_show ) {?>
        <div class="col-lg-1 col-md-2 col-6 p-0 align-self-center">
          <div class="search-box">
            <span><a href="#"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_search_icon','fas fa-search')); ?>"></i></a></span>
          </div>
        <?php } ?>
        </div>
        <div class="serach_outer">
          <div class="closepop"><a href="#maincontent"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_search_close_icon','fa fa-window-close')); ?>"></i></a></div>
          <div class="serach_inner">
            <?php get_search_form(); ?>
          </div>
        </div>
      </div>
    </div>
    <div class="clearfix"></div>
  </div>
</header>

<?php if(get_theme_mod('vw_lawyer_attorney_loader_enable',false) == 1) { ?>
  <div id="preloader">
    <div class="loader-inner">
      <div class="loader-line-wrap">
        <div class="loader-line"></div>
      </div>
      <div class="loader-line-wrap">
        <div class="loader-line"></div>
      </div>
      <div class="loader-line-wrap">
        <div class="loader-line"></div>
      </div>
      <div class="loader-line-wrap">
        <div class="loader-line"></div>
      </div>
      <div class="loader-line-wrap">
        <div class="loader-line"></div>
      </div>
    </div>
  </div>
<?php } ?>