<?php
/**
 * Vw Gardening Landscaping: Block Patterns
 *
 * @package VW Gardening Landscaping
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-gardening-landscaping',
		array( 'label' => __( 'VW Gardening Landscaping', 'vw-gardening-landscaping' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-gardening-landscaping/banner-section',
		array(
			'title'      => __( 'Silder Section', 'vw-gardening-landscaping' ),
			'categories' => array( 'vw-gardening-landscaping' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider1.png\",\"id\":1241,\"dimRatio\":10,\"minHeight\":600,\"align\":\"full\",\"className\":\"sliderbox\"} -->\n<div class=\"wp-block-cover alignfull sliderbox\" style=\"min-height:600px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-10 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-1241\" alt=\"\" src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/slider1.png\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"className\":\"ms-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center ms-5\" style=\"flex-basis:50%\"><!-- wp:group {\"className\":\"sliderbox-content ms-5\"} -->\n<div class=\"wp-block-group sliderbox-content ms-5\"><!-- wp:heading {\"level\":1,\"style\":{\"typography\":{\"fontSize\":45}},\"className\":\"mb-2\"} -->\n<h1 class=\"wp-block-heading mb-2\" style=\"font-size:45px\">Lorem Ipsum&nbsp;is simply dummy text&nbsp;</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"16px\"}}} -->\n<p style=\"font-size:16px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever &nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#73b21a\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:14px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" style=\"background-color:#73b21a\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-gardening-landscaping/services-section',
		array(
			'title'      => __( 'Services Section', 'vw-gardening-landscaping' ),
			'categories' => array( 'vw-gardening-landscaping' ),
			'content'    => "<!-- wp:group {\"align\":\"full\",\"className\":\"expertise-section mx-3 px-lg-4\"} -->\n<div class=\"wp-block-group alignfull expertise-section mx-3 px-lg-4\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"full\",\"style\":{\"typography\":{\"fontSize\":35}},\"className\":\"pt-5\"} -->\n<h2 class=\"wp-block-heading alignfull has-text-align-center pt-5\" style=\"font-size:35px\">OUR EXPERTISE</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"full\",\"className\":\"mx-lg-5 mx-0\"} -->\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center mx-lg-5 mx-0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"expertise-box p-4 my-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center expertise-box p-4 my-5\"><!-- wp:image {\"align\":\"center\",\"id\":1145,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/expertise1.png\" alt=\"\" class=\"wp-image-1145\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"20px\"},\"color\":{\"text\":\"#222222\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"wp-block-heading has-text-align-center mb-2 has-text-color\" style=\"color:#222222;font-size:20px\">Our Expertise Title 1</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#a9a9a9\"}},\"className\":\"text-center mb-2\"} -->\n<p class=\"has-text-align-center text-center mb-2 has-text-color\" style=\"color:#a9a9a9;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#73b21a\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:14px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" style=\"background-color:#73b21a\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"expertise-box p-4 my-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center expertise-box p-4 my-5\"><!-- wp:image {\"align\":\"center\",\"id\":1191,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/expertise2.png\" alt=\"\" class=\"wp-image-1191\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"20px\"},\"color\":{\"text\":\"#222222\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"wp-block-heading has-text-align-center mb-2 has-text-color\" style=\"color:#222222;font-size:20px\">Our Expertise Title 2</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#a9a9a9\"}},\"className\":\"text-center mb-2\"} -->\n<p class=\"has-text-align-center text-center mb-2 has-text-color\" style=\"color:#a9a9a9;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#73b21a\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:14px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" style=\"background-color:#73b21a\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"className\":\"expertise-box p-4 my-5\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center expertise-box p-4 my-5\"><!-- wp:image {\"align\":\"center\",\"id\":1189,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/expertise3.png\" alt=\"\" class=\"wp-image-1189\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"fontSize\":\"20px\"},\"color\":{\"text\":\"#222222\"}},\"className\":\"mb-2\"} -->\n<h3 class=\"wp-block-heading has-text-align-center mb-2 has-text-color\" style=\"color:#222222;font-size:20px\">Our Expertise Title 3</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#a9a9a9\"}},\"className\":\"text-center mb-2\"} -->\n<p class=\"has-text-align-center text-center mb-2 has-text-color\" style=\"color:#a9a9a9;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#73b21a\"},\"typography\":{\"fontSize\":\"14px\"}}} -->\n<div class=\"wp-block-button has-custom-font-size\" style=\"font-size:14px\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" style=\"background-color:#73b21a\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->",
		)
	);
}