<?php
/* Add to Dashboard main menu */
function vw_ecommerce_store_dashboard_menu() {
    add_menu_page(
        esc_html__( 'VW Ecommerce Store', 'vw-ecommerce-store' ), // Page title
        esc_html__( 'VW Ecommerce Store', 'vw-ecommerce-store' ), // Menu title
        'manage_options',                            // Capability
        'vw_ecommerce_store_guide',                        // Menu slug
        'vw_ecommerce_store_mostrar_guide',                // Callback
        get_template_directory_uri() . '/inc/getstart/images/menu-icon.svg', // Image icon
        59                                           // Position
    );
}
add_action( 'admin_menu', 'vw_ecommerce_store_dashboard_menu' );

// Add a Custom CSS file to WP Admin Area
function vw_ecommerce_store_admin_theme_style() {
   wp_enqueue_style('vw-ecommerce-store-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstart/getstart.css');
   wp_enqueue_script('vw-ecommerce-store-tabs', esc_url(get_template_directory_uri()) . '/inc/getstart/js/tab.js');

   // Admin notice code START
	wp_register_script('vw-ecommerce-store-notice', esc_url(get_template_directory_uri()) . '/inc/getstart/js/notice.js', array('jquery'), time(), true);
	wp_enqueue_script('vw-ecommerce-store-notice');
	// Admin notice code END
}
add_action('admin_enqueue_scripts', 'vw_ecommerce_store_admin_theme_style');

//guidline for about theme
function vw_ecommerce_store_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$vw_ecommerce_store_theme = wp_get_theme( 'vw-ecommerce-store' );
?>

<div class="wrapper-info">
	<div class="tab-sec">
    	
    	<div class="tab">
    		<button class="tablinks" onclick="vw_ecommerce_store_open_tab(event, 'theme_offer')"><?php esc_html_e( 'Demo Import', 'vw-ecommerce-store' ); ?></button>
			<button class="tablinks" onclick="vw_ecommerce_store_open_tab(event, 'lite_theme')"><?php esc_html_e( 'Setup With Customizer', 'vw-ecommerce-store' ); ?></button>
			<button class="tablinks" onclick="vw_ecommerce_store_open_tab(event, 'theme_pro')"><?php esc_html_e( 'Get Premium', 'vw-ecommerce-store' ); ?></button>
  			<button class="tablinks" onclick="vw_ecommerce_store_open_tab(event, 'free_pro')"><?php esc_html_e( 'Free VS Premium', 'vw-ecommerce-store' ); ?></button>
  			<button class="tablinks" onclick="vw_ecommerce_store_open_tab(event, 'get_bundle')"><?php esc_html_e( 'WP Theme Bundle', 'vw-ecommerce-store' ); ?></button>
		</div>

		<?php 
			$vw_ecommerce_store_plugin_custom_css = '';
			if(class_exists('Ibtana_Visual_Editor_Menu_Class')){
				$vw_ecommerce_store_plugin_custom_css ='display: block';
			}
		?>

		<div id="theme_offer" class="tabcontent open">
			<div class="demo-content">
				<div class="demo-text">
					<?php 
					/* Get Started. */ 
					require get_parent_theme_file_path( '/inc/getstart/demo-content.php' );
				 	?>
				</div>
				
			 	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/responsive.png" alt="" class="resp-img" />
			</div> 	
		</div>

		<div id="lite_theme" class="tabcontent">
		
			<div class="lite-theme-tab" style="<?php echo esc_attr($vw_ecommerce_store_plugin_custom_css); ?>">
				<h3><?php esc_html_e( 'Lite Theme Information', 'vw-ecommerce-store' ); ?></h3>
				<hr class="h3hr">
				<p><?php esc_html_e('VW Ecommerce store is a multipurpose category store not only for the online apparel and fashion accessories but it can be applied for various other businesses as well like the sports equipment shop, cosmetic shop, jewellery shop or any mobile and gadget store. If you are planning to start a business of supermarket or grocery or an online food delivery website, accessories, electronics shops, cloth, Shoes, mega sale, smart TV, craddle toys, handbags, Smart Watches, 3D Assets Stores, Electric Scooters, Jewelry Dropshipping, Baby Rompers, e-procurement, AR/VR Headsets, Hardware, Fitness Tools, Watch, Lifestyle Apparel, Smart Home Products, e-business, e-marketing, b2b, flowers, organic, sport shop, baby store, affiliate store, sports equipment, utility stores, kitchen online shop, online shopping, retail business, digital storefront, product sales, ecommerce, toy store, digital product store, digital Storefront, clothes shop, clothing wordpress, accessorie, baby shop, bag, shopkeeper, retail Store, book depot, E bazar, electronic, decorative stores, fashionable clothing store, merchant, cosmetics market, jewelry market, car workshop, barber shop, furniture shop, hand tools store, protective kits retailer, e shoppay, boutiques, VW ecommerce store is a very good option. It also can display the business information for the online product sale and can be used for multiple ecommerce stores right from fashion to technology. Known for its feature richness and some incredible features like multipurpose, CTA, Bootstrap framework, Threaded Comments, SEO friendly, Custom menu, multiple widget regions, three columns layout, optimised codes and much more, it is very good in case of opening the shop related to the home appliances or in case you are interested in the automobile shopping site, VW ecommerce store is a fine option. It is good for almost all types of stores under the sun like gadgets store, automobile shopping site, interior store, books store, photo store, movies store, foods and restaurants online order sites and more. It comes with the customization options, Woocommerce product swatches, WooCommerce Variation Swatches, and secondly it is translation ready, mobile friendly and interactive.','vw-ecommerce-store'); ?></p>
				<div class="lite-info">
					<div class="col-left-inner">
				  		<h4><?php esc_html_e( 'Theme Documentation', 'vw-ecommerce-store' ); ?></h4>
						<p><?php esc_html_e( 'If you need any assistance regarding setting up and configuring the Theme, our documentation is there.', 'vw-ecommerce-store' ); ?></p>
						<div class="info-link">
							<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_FREE_THEME_DOC ); ?>" target="_blank"> <?php esc_html_e( 'Documentation', 'vw-ecommerce-store' ); ?></a>
						</div>
						<hr>
						<h4><?php esc_html_e('Theme Customizer', 'vw-ecommerce-store'); ?></h4>
						<p> <?php esc_html_e('To begin customizing your website, start by clicking "Customize".', 'vw-ecommerce-store'); ?></p>
						<div class="info-link">
							<a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e('Customizing', 'vw-ecommerce-store'); ?></a>
						</div>
						<hr>
						<h4><?php esc_html_e('Having Trouble, Need Support?', 'vw-ecommerce-store'); ?></h4>
						<p> <?php esc_html_e('Our dedicated team is well prepared to help you out in case of queries and doubts regarding our theme.', 'vw-ecommerce-store'); ?></p>
						<div class="info-link">
							<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support Forum', 'vw-ecommerce-store'); ?></a>
						</div>
						<hr>
						<h4><?php esc_html_e('Reviews & Testimonials', 'vw-ecommerce-store'); ?></h4>
						<p> <?php esc_html_e('All the features and aspects of this WordPress Theme are phenomenal. I\'d recommend this theme to all.', 'vw-ecommerce-store'); ?></p>
						<div class="info-link">
							<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_REVIEW ); ?>" target="_blank"><?php esc_html_e('Reviews', 'vw-ecommerce-store'); ?></a>
						</div>

						<div class="link-customizer">
							<h4><?php esc_html_e( 'Link to customizer', 'vw-ecommerce-store' ); ?></h4>
							<div class="first-row">
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-buddicons-buddypress-logo"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[control]=custom_logo') ); ?>" target="_blank"><?php esc_html_e('Upload your logo','vw-ecommerce-store'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-category"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_topbar') ); ?>" target="_blank"><?php esc_html_e('Header','vw-ecommerce-store'); ?></a>
									</div>
								</div>

								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-slides"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_slidersettings') ); ?>" target="_blank"><?php esc_html_e('Slider Settings','vw-ecommerce-store'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-category"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_sale') ); ?>" target="_blank"><?php esc_html_e('Sale Banner Settings Section','vw-ecommerce-store'); ?></a>
									</div>
								</div>
							
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-category"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_right_sidebar_section') ); ?>" target="_blank"><?php esc_html_e('Right Sidebar Section','vw-ecommerce-store'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-menu"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=nav_menus') ); ?>" target="_blank"><?php esc_html_e('Menus','vw-ecommerce-store'); ?></a>
									</div>
								</div>
								
								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-admin-generic"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_left_right') ); ?>" target="_blank"><?php esc_html_e('General Settings','vw-ecommerce-store'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-format-gallery"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_post_settings') ); ?>" target="_blank"><?php esc_html_e('Post settings','vw-ecommerce-store'); ?></a>
									</div>
								</div>

								<div class="row-box">
									<div class="row-box1">
										<span class="dashicons dashicons-screenoptions"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[panel]=widgets') ); ?>" target="_blank"><?php esc_html_e('Footer Widget','vw-ecommerce-store'); ?></a>
									</div>
									<div class="row-box2">
										<span class="dashicons dashicons-text-page"></span><a href="<?php echo esc_url( admin_url('customize.php?autofocus[section]=vw_ecommerce_store_footer') ); ?>" target="_blank"><?php esc_html_e('Footer Text','vw-ecommerce-store'); ?></a>
									</div>
								</div>
							</div>
						</div>
				  	</div>
					<div class="col-right-inner">
						<h4 class="page-template"><?php esc_html_e('How to set up Home Page Template','vw-ecommerce-store'); ?></h4>
						<p><?php esc_html_e('Follow these instructions to setup Home page.','vw-ecommerce-store'); ?></p>
	                  	<p><span class="strong"><?php esc_html_e('1. Create a new page :','vw-ecommerce-store'); ?></span><?php esc_html_e(' Go to ','vw-ecommerce-store'); ?>
						  	<b><?php esc_html_e(' Dashboard >> Pages >> Add New Page','vw-ecommerce-store'); ?></b></p>
	                  	<p><?php esc_html_e('Name it as "Home" then select the template "Custom Home Page".','vw-ecommerce-store'); ?></p>
	                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/home-page-template.png" alt="" />
	                  	<p><span class="strong"><?php esc_html_e('2. Set the front page:','vw-ecommerce-store'); ?></span><?php esc_html_e(' Go to ','vw-ecommerce-store'); ?>
						  	<b><?php esc_html_e(' Settings >> Reading ','vw-ecommerce-store'); ?></b></p>
					  	<p><?php esc_html_e('Select the option of Static Page, now select the page you created to be the homepage, while another page to be your default page.','vw-ecommerce-store'); ?></p>
	                  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/set-front-page.png" alt="" />
	                  	<p><?php esc_html_e(' Once you are done with setup, then follow the','vw-ecommerce-store'); ?> <a class="doc-links" href="<?php echo esc_url( VW_ECOMMERCE_STORE_FREE_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','vw-ecommerce-store'); ?></a></p>
				  	</div>

				</div>
			  	
			</div>
		</div>

		<div id="theme_pro" class="tabcontent">		  	
			<div class="pro-info">
				<div class="col-left-pro">
					<h3><?php esc_html_e( 'Premium Theme Information', 'vw-ecommerce-store' ); ?></h3>
					<hr class="h3hr">
			    	<p><?php esc_html_e('WordPress Ecommerce theme is a theme of premium order and is highly suitable for the businesses like online apparel shops as well as the fashion accessory stores. It is also good for sports equipment shop, cosmetics shop, mobile and gadgets store, jewellery shop, furniture shop, supermarket, grocery store or online food delivering website. It has some incredible features to support and some of these are retina ready, professional, personalization options, testimonial section, customization options, multipurpose, translation ready and much more. This WordPress theme is totally designed for the ecommerce sites and there is an option to display the business information and the option of the product sale online. It is also specially designed for shops and eCommerce sites. It could be used for all types of e-commerce online stores, including Fashion, Shoes, Jewellery, Watch, Sport, Technology, Mobile.','vw-ecommerce-store'); ?></p>
			    	<div class="pro-links">
				    	<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_LIVE_DEMO ); ?>" target="_blank" class="demo-btn"><?php esc_html_e('Live Demo', 'vw-ecommerce-store'); ?></a>
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_BUY_NOW ); ?>" target="_blank" class="prem-btn"><?php esc_html_e('Buy Premium', 'vw-ecommerce-store'); ?></a>
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_PRO_DOC ); ?>" target="_blank" class="doc-btn"><?php esc_html_e('Documentation', 'vw-ecommerce-store'); ?></a>
					</div>
			    </div>
			    <div class="col-right-pro scroll-image-wrapper">
			    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/pro-theme.jpg" alt="" class="pro-img" />		    	
			    </div>
			</div>		    
		</div>

		<div id="free_pro" class="tabcontent">
		  	<div class="featurebox">
			    <h3><?php esc_html_e( 'Theme Features', 'vw-ecommerce-store' ); ?></h3>
				<hr class="h3hr">
				<div class="table-image">
					<table class="tablebox">
						<thead>
							<tr>
								<th></th>
								<th><?php esc_html_e('Free Themes', 'vw-ecommerce-store'); ?></th>
								<th><?php esc_html_e('Premium Themes', 'vw-ecommerce-store'); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td><?php esc_html_e('Theme Customization', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Responsive Design', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Logo Upload', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Social Media Links', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Banner Settings', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Template Pages', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('3', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('10', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Home Page Template', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('1', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Theme sections', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('2', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><?php esc_html_e('13', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Contact us Page Template / Support Templates', 'vw-ecommerce-store'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('1', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Blog Templates & Layout', 'vw-ecommerce-store'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Full width/Left/Right Sidebar)', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Page Templates & Layout', 'vw-ecommerce-store'); ?></td>
								<td class="table-img">0</td>
								<td class="table-img"><?php esc_html_e('3(Left/Right Sidebar)', 'vw-ecommerce-store'); ?></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Color Pallete For Particular Sections', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Global Color Option', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Reordering', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Demo Importer', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Allow To Set Site Title, Tagline, Logo', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Enable Disable Options On All Sections, Logo', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Full Documentation', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Latest WordPress Compatibility', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Support 3rd Party Plugins', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Secure and Optimized Code', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Exclusive Functionalities', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Section Enable / Disable', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Section Google Font Choices', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Video Gallery', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Simple & Mega Menu Option', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support to add custom CSS / JS ', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Shortcodes', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Background, Colors, Header, Logo & Menu', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Premium Membership', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Budget Friendly Value', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('Priority Error Fixing', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Custom Feature Addition', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr class="odd">
								<td><?php esc_html_e('All Access Theme Pass', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Seamless Customer Support', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Vw Ecommerce Store ', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Detail Services', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('About Business Page', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Team Member Page', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Project Description Page', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td><?php esc_html_e('Support Page', 'vw-ecommerce-store'); ?></td>
								<td class="table-img"><span class="dashicons dashicons-no"></span></td>
								<td class="table-img"><span class="dashicons dashicons-saved"></span></td>
							</tr>
							<tr>
								<td></td>
								<td class="table-img"></td>
								<td class="update-link"><a href="<?php echo esc_url( VW_ECOMMERCE_STORE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Upgrade to Pro', 'vw-ecommerce-store'); ?></a></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<div id="get_bundle" class="tabcontent">	
			<div class="bundle-info">
				<div class="col-left-pro">
			   		<h3><?php esc_html_e( 'WP Theme Bundle', 'vw-ecommerce-store' ); ?></h3>
			   		<hr class="h3hr">
			    	<p><?php esc_html_e('Enhance your website effortlessly with our WP Theme Bundle. Get access to 400+ premium WordPress themes and 5+ powerful plugins, all designed to meet diverse business needs. Enjoy seamless integration with any plugins, ultimate customization flexibility, and regular updates to keep your site current and secure. Plus, benefit from our dedicated customer support, ensuring a smooth and professional web experience.','vw-ecommerce-store'); ?></p>
			    	<div class="feature">
			    		<h4><?php esc_html_e( 'Features:', 'vw-ecommerce-store' ); ?></h4>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/tick.png" alt="" /><?php esc_html_e('400+ Premium Themes & 5+ Plugins.', 'vw-ecommerce-store'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/tick.png" alt="" /><?php esc_html_e('Seamless Integration.', 'vw-ecommerce-store'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/tick.png" alt="" /><?php esc_html_e('Customization Flexibility.', 'vw-ecommerce-store'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/tick.png" alt="" /><?php esc_html_e('Regular Updates.', 'vw-ecommerce-store'); ?></p>
			    		<p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/tick.png" alt="" /><?php esc_html_e('Dedicated Support.', 'vw-ecommerce-store'); ?></p>
			    	</div>
			    	<p><?php esc_html_e('Upgrade now and give your website the professional edge it deserves, all at an unbeatable price of $99!', 'vw-ecommerce-store'); ?></p>
			    	<div class="pro-links">
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_THEME_BUNDLE_BUY_NOW ); ?>" target="_blank" class="bundle-buy"><?php esc_html_e('Get Bundle', 'vw-ecommerce-store'); ?></a>
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_THEME_BUNDLE_DOC ); ?>" target="_blank" class="bundle-doc"><?php esc_html_e('Documentation', 'vw-ecommerce-store'); ?></a>
					</div>
			   	</div>
			   	<div class="col-right-pro scroll-image-wrapper">
			    	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/bundle.jpg" alt="" />
			   	</div>
			</div>	  	
		   			    
		</div>
	</div>
	<div class="coupen-code-section">
		<div class="sshot-section">
			<div class="sshot-inner">
				<h2><?php esc_html_e( 'Welcome To Vw Ecommerce Store', 'vw-ecommerce-store' ); ?></h2>
				<div class="on-pro">
					<span class="version"><?php esc_html_e( 'Version', 'vw-ecommerce-store' ); ?>: <?php echo esc_html($vw_ecommerce_store_theme['Version']);?></span>
					<span class="coupon-code"><?php esc_html_e('Get 20% Of On Pro Theme-Use Code: ','vw-ecommerce-store'); ?><span class="code-highlight"><?php esc_html_e('VWPRO20','vw-ecommerce-store'); ?></span>
				</div>
		    	<p><?php esc_html_e('All Our Wordpress Themes Are Modern, Minimalist, 100% Responsive, Seo-Friendly,Feature-Rich, And Multipurpose That Best Suit Designers, Bloggers And Other Professionals Who Are Working In The Creative Fields.','vw-ecommerce-store'); ?></p>
		    	<div class="btn-section">
			    	<div class="proo-links">
				    	<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_LIVE_DEMO ); ?>" target="_blank" class="demo-btn"><?php esc_html_e('Live Demo', 'vw-ecommerce-store'); ?></a>
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_BUY_NOW ); ?>" target="_blank" class="prem-btn"><?php esc_html_e('Buy Premium', 'vw-ecommerce-store'); ?></a>
						<a href="<?php echo esc_url( VW_ECOMMERCE_STORE_PRO_DOC ); ?>" target="_blank" class="doc-btn"><?php esc_html_e('Documentation', 'vw-ecommerce-store'); ?></a>
						
					</div>
			    	
			    </div>
			</div>
	    	<div class="bundle-banner">
	    		<div class="bundle-img">
	    			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getstart/images/bundle-notice.png" alt="" />
	    		</div>
	    		<div class="bundle-text">
		  			<h2><?php esc_html_e('WP THEME BUNDLE','vw-ecommerce-store'); ?></h2>
					<h4><?php esc_html_e('Get Access to 400+ Premium WordPress Themes At Just $99','vw-ecommerce-store'); ?></h4>
					<div class="bundle-button">
			  			<a href="<?php echo esc_url( 'https://www.vwthemes.com/discount/FREEBREF?redirect=/products/wp-theme-bundle'); ?>" target="_blank"><?php esc_html_e('Get 10% OFF On Bundle', 'vw-ecommerce-store'); ?></a>
			  		</div>
		  		</div>
		  		
	    	</div>
	    </div>
	    <div class="coupen-section">
	    	<div class="logo-section">
			  	<img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" alt="" />
		  	</div>
		  	<div class="logo-right">	
		  		<div class="logo-text">
		  			<h2><?php esc_html_e('GET PRO','vw-ecommerce-store'); ?></h2>
					<h4><?php esc_html_e('20% Off','vw-ecommerce-store'); ?></h4>
		  		</div>						
			</div>
	    </div>
	</div>
      
</div>
<?php } ?>