<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $vw_eco_nature_demo_import_completed = get_option('vw_eco_nature_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($vw_eco_nature_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-eco-nature') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-eco-nature') . '</a></span>';
        }

		//POST and update the customizer and other related data
        if (isset($_POST['submit'])) {

             // Check if woocommerce is installed and activated
            if (!is_plugin_active('woocommerce/woocommerce.php')) {
                // Install the plugin if it doesn't exist
                $vw_eco_nature_plugin_slug = 'woocommerce';
                $vw_eco_nature_plugin_file = 'woocommerce/woocommerce.php';
    
                // Check if plugin is installed
                $vw_eco_nature_installed_plugins = get_plugins();
                if (!isset($vw_eco_nature_installed_plugins[$vw_eco_nature_plugin_file])) {
                    include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                    include_once(ABSPATH . 'wp-admin/includes/file.php');
                    include_once(ABSPATH . 'wp-admin/includes/misc.php');
                    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    
                    // Install the plugin
                    $vw_eco_nature_upgrader = new Plugin_Upgrader();
                    $vw_eco_nature_upgrader->install('https://downloads.wordpress.org/plugin/woocommerce.latest-stable.zip');
                }
                // Activate the plugin
                activate_plugin($vw_eco_nature_plugin_file);
            }

            // Check if ibtana visual editor is installed and activated
            if (!is_plugin_active('ibtana-visual-editor/plugin.php')) {
              // Install the plugin if it doesn't exist
              $vw_eco_nature_plugin_slug = 'ibtana-visual-editor';
              $vw_eco_nature_plugin_file = 'ibtana-visual-editor/plugin.php';

              // Check if plugin is installed
              $vw_eco_nature_installed_plugins = get_plugins();
              if (!isset($vw_eco_nature_installed_plugins[$vw_eco_nature_plugin_file])) {
                  include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                  include_once(ABSPATH . 'wp-admin/includes/file.php');
                  include_once(ABSPATH . 'wp-admin/includes/misc.php');
                  include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

                  // Install the plugin
                  $vw_eco_nature_upgrader = new Plugin_Upgrader();
                  $vw_eco_nature_upgrader->install('https://downloads.wordpress.org/plugin/ibtana-visual-editor.latest-stable.zip');
              }
              // Activate the plugin
              activate_plugin($vw_eco_nature_plugin_file);
            }


            // ------- Create Nav Menu --------
            $vw_eco_nature_menuname = 'Main Menus';
            $vw_eco_nature_bpmenulocation = 'primary';
            $vw_eco_nature_menu_exists = wp_get_nav_menu_object($vw_eco_nature_menuname);

            if (!$vw_eco_nature_menu_exists) {
                $vw_eco_nature_menu_id = wp_create_nav_menu($vw_eco_nature_menuname);

                // Create Home Page
                $vw_eco_nature_home_title = 'Home';
                $vw_eco_nature_home = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $vw_eco_nature_home_id = wp_insert_post($vw_eco_nature_home);
                // Assign Home Page Template
                add_post_meta($vw_eco_nature_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $vw_eco_nature_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'vw-eco-nature'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));


                // Create About Us Page with Dummy Content
                $vw_eco_nature_about_title = 'About Us';
                $vw_eco_nature_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_eco_nature_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_about_title,
                    'post_content' => $vw_eco_nature_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_eco_nature_about_id = wp_insert_post($vw_eco_nature_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'vw-eco-nature'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Shop Page with Dummy Content
                $vw_eco_nature_about_title = 'Shop';
                $vw_eco_nature_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_eco_nature_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_about_title,
                    'post_content' => $vw_eco_nature_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_eco_nature_about_id = wp_insert_post($vw_eco_nature_about);
                // Add Shop Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('Shop', 'vw-eco-nature'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Services Page with Dummy Content
                $vw_eco_nature_about_title = 'Services';
                $vw_eco_nature_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_eco_nature_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_about_title,
                    'post_content' => $vw_eco_nature_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_eco_nature_about_id = wp_insert_post($vw_eco_nature_about);
                // Add Services Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('Services', 'vw-eco-nature'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $vw_eco_nature_pages_title = 'Pages';
                $vw_eco_nature_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_eco_nature_pages = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_pages_title,
                    'post_content' => $vw_eco_nature_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $vw_eco_nature_pages_id = wp_insert_post($vw_eco_nature_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'vw-eco-nature'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Blog Page 
                $vw_eco_nature_blog_page_title = 'Blog';

                $vw_eco_nature_blog_page_query = new WP_Query(array(
                    'post_type'      => 'page',
                    'name'           => sanitize_title($vw_eco_nature_blog_page_title),
                    'post_status'    => 'publish',
                    'posts_per_page' => 1
                ));
                if (!$vw_eco_nature_blog_page_query->have_posts()) {
                    $vw_eco_nature_blog_page = array(
                        'post_type'   => 'page',
                        'post_title'  => $vw_eco_nature_blog_page_title,
                        'post_status' => 'publish',
                        'post_author' => 1,
                    );
                    $vw_eco_nature_blog_page_id = wp_insert_post($vw_eco_nature_blog_page);
                    update_option('page_for_posts', $vw_eco_nature_blog_page_id);

                    wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                        'menu-item-title'      => __('Blog', 'vw-eco-nature'),
                        'menu-item-url'        => get_permalink($vw_eco_nature_blog_page_id),
                        'menu-item-status'     => 'publish',
                        'menu-item-object-id'  => $vw_eco_nature_blog_page_id,
                        'menu-item-object'     => 'page',
                        'menu-item-type'       => 'post_type',
                    ));
                }

                // Create Contact Page with Dummy Content
                $vw_eco_nature_about_title = 'Contact';
                $vw_eco_nature_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_eco_nature_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_eco_nature_about_title,
                    'post_content' => $vw_eco_nature_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_eco_nature_about_id = wp_insert_post($vw_eco_nature_about);
                // Add Contact Page to Menu
                wp_update_nav_menu_item($vw_eco_nature_menu_id, 0, array(
                    'menu-item-title' => __('Contact', 'vw-eco-nature'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_eco_nature_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($vw_eco_nature_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($locations)) {
                        $locations = array();
                    }
                    $locations[$vw_eco_nature_bpmenulocation] = $vw_eco_nature_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }

            }


            // Set the demo import completion flag
    		update_option('vw_eco_nature_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-eco-nature') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-eco-nature') . '</a></span>';
            //end


            // Top Bar //
          
            set_theme_mod( 'vw_eco_nature_location_icon', 'fas fa-map-marker-alt' );
            set_theme_mod( 'vw_eco_nature_location_text', 'LOCATION' );
            set_theme_mod( 'vw_eco_nature_location', '828 N. Iqyreesrs Street Liocnss Park' );
            set_theme_mod( 'vw_eco_nature_phone_number_icon', 'fas fa-phone' );
            set_theme_mod( 'vw_eco_nature_phone_number_text', 'PHONE' );

            set_theme_mod( 'vw_eco_nature_phone_number', '+00 987 654 1230' );
            set_theme_mod( 'vw_eco_nature_email_address_icon', 'far fa-envelope' );
            set_theme_mod( 'vw_eco_nature_email_address_text', 'EMAIL' );
            set_theme_mod( 'vw_eco_nature_email_address', 'example@gmail.com' );
            set_theme_mod( 'vw_eco_nature_donate_text', 'DONATE NOW' );
            set_theme_mod( 'vw_eco_nature_donate_url', '#' );
          
            // slider section start //
            set_theme_mod( 'vw_eco_nature_slider_button_text', 'START TODAY' );
            set_theme_mod( 'vw_eco_nature_slider_btn_link', '#' );
            set_theme_mod( 'vw_eco_nature_before_slider_button_icon', 'fas fa-plus' );

            for($vw_eco_nature_i=1;$vw_eco_nature_i<=3;$vw_eco_nature_i++){
               $vw_eco_nature_slider_title = 'Lorem Ipsum is simply dummy text of the printing';
               $vw_eco_nature_slider_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam..';
                  // Create post object
               $my_post = array(
               'post_title'    => wp_strip_all_tags( $vw_eco_nature_slider_title ),
               'post_content'  => $vw_eco_nature_slider_content,
               'post_status'   => 'publish',
               'post_type'     => 'page',
               );

               // Insert the post into the database
               $vw_eco_nature_post_id = wp_insert_post( $my_post );

               if ($vw_eco_nature_post_id) {
                 // Set the theme mod for the slider page
                set_theme_mod('vw_eco_nature_slider_page' . $vw_eco_nature_i, $vw_eco_nature_post_id);

                $vw_eco_nature_image_url = get_template_directory_uri().'/assets/images/slider'.$vw_eco_nature_i.'.png';

                $vw_eco_nature_image_id = media_sideload_image($vw_eco_nature_image_url, $vw_eco_nature_post_id, null, 'id');

                    if (!is_wp_error($vw_eco_nature_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($vw_eco_nature_post_id, $vw_eco_nature_image_id);
                    }
                }
            }

            // Our Services Settings
            set_theme_mod('vw_eco_nature_our_services', 'postcategory1');

            // Define post category names and post titles
            $vw_eco_nature_category_names = array('postcategory1', 'postcategory2');
            $vw_eco_nature_title_array = array(
                array("Feature Title 1", "Feature Title 2", "Feature Title 3"),
                array("Feature Title 1", "Feature Title 2", "Feature Title 3")
                
            );

            foreach ($vw_eco_nature_category_names as $vw_eco_nature_index => $vw_eco_nature_category_name) {
                // Create or retrieve the post category term ID
                $vw_eco_nature_term = term_exists($vw_eco_nature_category_name, 'category');
                if ($vw_eco_nature_term === 0 || $vw_eco_nature_term === null) {
                    // If the term does not exist, create it
                    $vw_eco_nature_term = wp_insert_term($vw_eco_nature_category_name, 'category');
                }
                if (is_wp_error($vw_eco_nature_term)) {
                    error_log('Error creating category: ' . $vw_eco_nature_term->get_error_message());
                    continue; // Skip to the next iteration if category creation fails
                }

                for ($vw_eco_nature_i = 0; $vw_eco_nature_i < 3; $vw_eco_nature_i++) {
                    // Create post content
                    $vw_eco_nature_title = $vw_eco_nature_title_array[$vw_eco_nature_index][$vw_eco_nature_i];
                    $vw_eco_nature_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';

                    // Create post post object
                    $vw_eco_nature_my_post = array(
                        'post_title'    => wp_strip_all_tags($vw_eco_nature_title),
                        'post_content'  => $vw_eco_nature_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'post', // Post type set to 'post'
                    );

                    // Insert the post into the database
                    $vw_eco_nature_post_id = wp_insert_post($vw_eco_nature_my_post);

                    if (is_wp_error($vw_eco_nature_post_id)) {
                        error_log('Error creating post: ' . $vw_eco_nature_post_id->get_error_message());
                        continue; // Skip to the next post if creation fails
                    }

                    // Assign the category to the post
                    wp_set_post_categories($vw_eco_nature_post_id, array((int)$vw_eco_nature_term['term_id']));

                    // Handle the featured image using media_sideload_image
                    $vw_eco_nature_image_url = get_template_directory_uri() . '/assets/images/service' . ($vw_eco_nature_i + 1) . '.png';
                    $vw_eco_nature_image_id = media_sideload_image($vw_eco_nature_image_url, $vw_eco_nature_post_id, null, 'id');

                    if (is_wp_error($vw_eco_nature_image_id)) {
                        error_log('Error downloading image: ' . $vw_eco_nature_image_id->get_error_message());
                        continue; // Skip to the next post if image download fails
                    }
                    // Assign featured image to post
                    set_post_thumbnail($vw_eco_nature_post_id, $vw_eco_nature_image_id);
                }
            }  
            // About us Settings

            set_theme_mod( 'vw_eco_nature_section_title', 'Lorem Ipsum is simply dummy' );

            $vw_eco_nature_banner_title = 'About Us';
            $vw_eco_nature_banner_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries.';
                  
            // Create post object
            $my_post = array(
            'post_title'    => wp_strip_all_tags( $vw_eco_nature_banner_title ),
            'post_content'  => $vw_eco_nature_banner_content,
            'post_status'   => 'publish',
            'post_type'     => 'page',
            );

            // Insert the post into the database
            $vw_eco_nature_post_id = wp_insert_post( $my_post );

            if ($vw_eco_nature_post_id) {
                // Set the theme mod for the slider page
            set_theme_mod('vw_eco_nature_about_page', $vw_eco_nature_post_id);

            $vw_eco_nature_image_url = get_template_directory_uri().'/assets/images/about-us.png';

            $vw_eco_nature_image_id = media_sideload_image($vw_eco_nature_image_url, $vw_eco_nature_post_id, null, 'id');

                if (!is_wp_error($vw_eco_nature_image_id)) {
                    // Set the downloaded image as the post's featured image
                    set_post_thumbnail($vw_eco_nature_post_id, $vw_eco_nature_image_id);
                }
            }

        }
    ?>

	<p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for VW Eco Nature', 'vw-eco-nature'); ?></p>
    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=vw_eco_nature_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('vw_eco_nature_demo_import_completed')) : ?>
            <input class="run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer', 'vw-eco-nature'); ?>" class="button button-primary button-large">
        <?php endif; ?>
        <div id="spinner" style="display:none;">         
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/spinner.png" alt="" />
        </div>
    </form>
    <script type="text/javascript">
        function validate(form) {
            if (confirm("Do you really want to import the theme demo content?")) {
                // Show the spinner
                document.getElementById('spinner').style.display = 'block';
                // Allow the form to be submitted
                return true;
            } 
            else {
                return false;
            }
        }
    </script>
</div>
