<div class="theme-offer">
	<?php
        // Check if the demo import has been completed
        $vw_corporate_business_demo_import_completed = get_option('vw_corporate_business_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($vw_corporate_business_demo_import_completed) {
        echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-corporate-business') . '</p>';
        echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-corporate-business') . '</a></span>';
        }

		//POST and update the customizer and other related data of POLITICAL CAMPAIGN
        if (isset($_POST['submit'])) {

        // Check if ibtana visual editor is installed and activated
        if (!is_plugin_active('ibtana-visual-editor/plugin.php')) {
          // Install the plugin if it doesn't exist
          $vw_corporate_business_plugin_slug = 'ibtana-visual-editor';
          $vw_corporate_business_plugin_file = 'ibtana-visual-editor/plugin.php';

          // Check if plugin is installed
          $vw_corporate_business_installed_plugins = get_plugins();
          if (!isset($vw_corporate_business_installed_plugins[$vw_corporate_business_plugin_file])) {
              include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
              include_once(ABSPATH . 'wp-admin/includes/file.php');
              include_once(ABSPATH . 'wp-admin/includes/misc.php');
              include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');

              // Install the plugin
              $vw_corporate_business_upgrader = new Plugin_Upgrader();
              $vw_corporate_business_upgrader->install('https://downloads.wordpress.org/plugin/ibtana-visual-editor.latest-stable.zip');
          }
          // Activate the plugin
          activate_plugin($vw_corporate_business_plugin_file);
        }

            // ------- Create Nav Menu --------
            $vw_corporate_business_menuname = 'Main Menus';
            $vw_corporate_business_bpmenulocation = 'primary';
            $vw_corporate_business_menu_exists = wp_get_nav_menu_object($vw_corporate_business_menuname);

            if (!$vw_corporate_business_menu_exists) {
                $vw_corporate_business_menu_id = wp_create_nav_menu($vw_corporate_business_menuname);

                // Create Home Page
                $vw_corporate_business_home_title = 'Home';
                $vw_corporate_business_home = array(
                    'post_type' => 'page',
                    'post_title' => $vw_corporate_business_home_title,
                    'post_content' => '',
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'home'
                );
                $vw_corporate_business_home_id = wp_insert_post($vw_corporate_business_home);
                // Assign Home Page Template
                add_post_meta($vw_corporate_business_home_id, '_wp_page_template', 'page-template/custom-home-page.php');
                // Update options to set Home Page as the front page
                update_option('page_on_front', $vw_corporate_business_home_id);
                update_option('show_on_front', 'page');
                // Add Home Page to Menu
                wp_update_nav_menu_item($vw_corporate_business_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'vw-corporate-business'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_corporate_business_home_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create Pages Page with Dummy Content
                $vw_corporate_business_pages_title = 'Pages';
                $vw_corporate_business_pages_content = '
                <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>

                 Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                  All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_corporate_business_pages = array(
                    'post_type' => 'page',
                    'post_title' => $vw_corporate_business_pages_title,
                    'post_content' => $vw_corporate_business_pages_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'pages'
                );
                $vw_corporate_business_pages_id = wp_insert_post($vw_corporate_business_pages);
                // Add Pages Page to Menu
                wp_update_nav_menu_item($vw_corporate_business_menu_id, 0, array(
                    'menu-item-title' => __('Pages', 'vw-corporate-business'),
                    'menu-item-classes' => 'pages',
                    'menu-item-url' => home_url('/pages/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_corporate_business_pages_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Create About Us Page with Dummy Content
                $vw_corporate_business_about_title = 'About Us';
                $vw_corporate_business_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

                         Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br>

                            There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br>

                            All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
                $vw_corporate_business_about = array(
                    'post_type' => 'page',
                    'post_title' => $vw_corporate_business_about_title,
                    'post_content' => $vw_corporate_business_about_content,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_slug' => 'about-us'
                );
                $vw_corporate_business_about_id = wp_insert_post($vw_corporate_business_about);
                // Add About Us Page to Menu
                wp_update_nav_menu_item($vw_corporate_business_menu_id, 0, array(
                    'menu-item-title' => __('About Us', 'vw-corporate-business'),
                    'menu-item-classes' => 'about-us',
                    'menu-item-url' => home_url('/about-us/'),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $vw_corporate_business_about_id,
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type'
                ));

                // Set the menu location if it's not already set
                if (!has_nav_menu($vw_corporate_business_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
                    if (empty($locations)) {
                        $locations = array();
                    }
                    $locations[$vw_corporate_business_bpmenulocation] = $vw_corporate_business_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }

        }


            // Set the demo import completion flag
    		update_option('vw_corporate_business_demo_import_completed', true);
    		// Display success message and "View Site" button
    		echo '<p class="notice-text">' . esc_html__('Your demo import has been completed successfully.', 'vw-corporate-business') . '</p>';
    		echo '<span><a href="' . esc_url(home_url()) . '" class="button button-primary site-btn" target="_blank">' . esc_html__('View Site', 'vw-corporate-business') . '</a></span>';
            //end


            // Top Bar //
            
            set_theme_mod( 'vw_corporate_business_location_icon', 'fas fa-map-marker-alt' );
            set_theme_mod( 'vw_corporate_business_location', '316, George, SD 57401' );
            set_theme_mod( 'vw_corporate_business_phone_icon', 'fas fa-phone' );
            set_theme_mod( 'vw_corporate_business_call', '1234567890' );
            set_theme_mod( 'vw_corporate_business_email_icon', 'fas fa-envelope' );
            set_theme_mod( 'vw_corporate_business_email', 'support@example.com' );
            set_theme_mod( 'vw_corporate_business_started_text', 'Get Started' );
            set_theme_mod( 'vw_corporate_business_started_link', '#' );

            // slider section start //
            set_theme_mod( 'vw_corporate_business_slider_button_text', 'Get Started' );
            set_theme_mod( 'vw_corporate_business_slider_btn_link', '#' );

            for($vw_corporate_business_i=1;$vw_corporate_business_i<=4;$vw_corporate_business_i++){
               $vw_corporate_business_slider_title = 'Lorem Ipsum Is Simply Dummy';
               $vw_corporate_business_slider_content = 'Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s when an unknown printer took a galley of type and scrambled it to make a type specimen book.';
                  // Create post object
               $my_post = array(
               'post_title'    => wp_strip_all_tags( $vw_corporate_business_slider_title ),
               'post_content'  => $vw_corporate_business_slider_content,
               'post_status'   => 'publish',
               'post_type'     => 'page',
               );

               // Insert the post into the database
               $vw_corporate_business_post_id = wp_insert_post( $my_post );

               if ($vw_corporate_business_post_id) {
                 // Set the theme mod for the slider page
                 set_theme_mod('vw_corporate_business_slider_page' . $vw_corporate_business_i, $vw_corporate_business_post_id);

                  $vw_corporate_business_image_url = get_template_directory_uri().'/images/slider'.$vw_corporate_business_i.'.png';

                $vw_corporate_business_image_id = media_sideload_image($vw_corporate_business_image_url, $vw_corporate_business_post_id, null, 'id');

                    if (!is_wp_error($vw_corporate_business_image_id)) {
                        // Set the downloaded image as the post's featured image
                        set_post_thumbnail($vw_corporate_business_post_id, $vw_corporate_business_image_id);
                    }
                }
            }


            // about page
            set_theme_mod( 'vw_corporate_business_about_button_text', 'READ MORE' );

                 // Define single post data

                 $vw_corporate_business_title = "About Us";
                 $vw_corporate_business_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum';
                 for($vw_corporate_business_i=1; $vw_corporate_business_i<=4; $vw_corporate_business_i++) {
                    set_theme_mod( 'vw_corporate_business_about_page_list'.$vw_corporate_business_i, 'Top Level Help' );
                }

                 // Create post
                 $vw_corporate_business_my_post = array(
                     'post_title'   => wp_strip_all_tags($vw_corporate_business_title),
                     'post_content' => $vw_corporate_business_content,
                     'post_status'  => 'publish',
                     'post_type'    => 'post',
                 );
                 $vw_corporate_business_postData1 = wp_insert_post($vw_corporate_business_my_post);

                 // Check if the post was created successfully



                     // Set theme mod for the post
                     set_theme_mod('vw_corporate_business_about_post', $vw_corporate_business_postData1);

                     // Get image URL
                     $vw_corporate_business_image_url = get_template_directory_uri() . '/images/about.png';
                     $vw_corporate_business_image_data = wp_remote_get($vw_corporate_business_image_url);
                     if (!is_wp_error($vw_corporate_business_image_data)) {
                         $vw_corporate_business_image_body = wp_remote_retrieve_body($vw_corporate_business_image_data);
                         $vw_corporate_business_upload_dir = wp_upload_dir();
                         $vw_corporate_business_image_name = 'service-image.png';
                         $uploaded_file = wp_upload_bits($vw_corporate_business_image_name, null, $vw_corporate_business_image_body);
                         if (!$uploaded_file['error']) {
                             // Set attachment data
                             $attachment = array(
                                 'post_mime_type' => $uploaded_file['type'],
                                 'post_title'     => sanitize_file_name($vw_corporate_business_image_name),
                                 'post_content'   => '',
                                 'post_status'    => 'inherit',
                             );
                             $vw_corporate_business_attach_id = wp_insert_attachment($attachment, $uploaded_file['file'], $vw_corporate_business_postData1);
                             require_once(ABSPATH . 'wp-admin/includes/image.php');
                             $vw_corporate_business_attach_data = wp_generate_attachment_metadata($vw_corporate_business_attach_id, $uploaded_file['file']);
                             wp_update_attachment_metadata($vw_corporate_business_attach_id, $vw_corporate_business_attach_data);
                             set_post_thumbnail($vw_corporate_business_postData1, $vw_corporate_business_attach_id);
                         }
                    }
            //Copyright Text
            set_theme_mod( 'vw_corporate_business_footer_text', 'By VWThemes' );

        }
    ?>

	<p><?php esc_html_e('Please back up your website if it’s already live with data. This importer will overwrite your existing settings with the new customizer values for VW Corporate Business', 'vw-corporate-business'); ?></p>
    <form action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php?page=vw_corporate_business_guide" method="POST" onsubmit="return validate(this);">
        <?php if (!get_option('vw_corporate_business_demo_import_completed')) : ?>
            <input class="run-import" type="submit" name="submit" value="<?php esc_attr_e('Run Importer', 'vw-corporate-business'); ?>" class="button button-primary button-large">
        <?php endif; ?>
        <div id="spinner" style="display:none;">         
            <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/spinner.png" alt="" />
        </div>
    </form>
    <script type="text/javascript">
        function validate(form) {
            if (confirm("Do you really want to import the theme demo content?")) {
                // Show the spinner
                document.getElementById('spinner').style.display = 'block';
                // Allow the form to be submitted
                return true;
            } 
            else {
                return false;
            }
        }
    </script>
</div>