<?php
/**
 * Custom Control, extend the WP customizer
 *
 * @package vt-patricia
 * @author  VolThemes
 */

if (class_exists('WP_Customize_Control')) {
    class WP_Customize_Category_Control extends WP_Customize_Control {
        /**
         * Render the control's content.
         *
         * @since 1.0.0
         */
        public function render_content() {
            $dropdown = wp_dropdown_categories(
                array(
                    'name'              => '_customize-dropdown-categories-' . $this->id,
                    'echo'              => 0,
                    'show_option_none'  => esc_html__( '&mdash; Select &mdash;', 'vt-patricia' ),
                    'option_none_value' => '0',
                    'selected'          => $this->value(),
                )
            );
 
            // Hackily add in the data link parameter.
            $dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );
 
            printf(
                '<label class="customize-control-select"><span class="customize-control-title">%s</span><span class="description customize-control-description">%s</span> %s </label>',
                $this->label,
				$this->description,
                $dropdown
            );
        }
    }
}

/* Toggle Control */
if ( class_exists( 'WP_Customize_Control' ) ) {
	get_template_part('core/customizer/customizer-library/custom-controls/toggle-control');
}