<?php
//about theme info
add_action( 'admin_menu', 'vortexnews_gettingstarted_page' );
function vortexnews_gettingstarted_page() {      
    add_theme_page( esc_html__('vortexnews', 'vortexnews'), esc_html__('All About VortexNews', 'vortexnews'), 'edit_theme_options', 'vortexnews_mainpage', 'vortexnews_mostrar_main_content');   
}


function vortexnews_discount_notice() {
    global $pagenow;
    if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) { ?>
        <div class="notice getting_started">
            <div class="notice-content">
                <p><?php esc_html_e( '🎉 Thank You For Choosing CA WP Themes!', 'vortexnews' ); ?></p>
                
                <h2><?php esc_html_e( '🚀 Get Started with Your Free Theme!', 'vortexnews' ); ?></h2>
                
                <p><?php esc_html_e( "Here are some useful links to help you set up your theme quickly:", 'vortexnews' ); ?></p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/vortexnews-free-wordpress-theme/' ); ?>" target="_blank">
                        <?php esc_html_e( '🎨 View Free Theme Details', 'vortexnews' ); ?>
                    </a>
                </div>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( 'https://cawpthemes.com/docs/vortexnews-free-theme-documentation/' ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Read Theme Documentation', 'vortexnews' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Upgrade to Pro for More Amazing Features!', 'vortexnews' ); ?></h2>
                
                <p><?php esc_html_e( "Unlock the full potential of your website with our premium version! 🚀", 'vortexnews' ); ?></p>
                
                <div class="info-link">
                   <a href="<?php echo esc_url( 'https://cawpthemes.com/docs/premium-theme-and-plugin-download/' ); ?>" target="_blank">
                        <?php esc_html_e( '📖 Pro Documentation', 'vortexnews' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( VORTEXNEWS_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🚀 Upgrade to Pro', 'vortexnews' ); ?>
                    </a>
                </div>

                <div class="info-link">
                    <a href="<?php echo esc_url( VORTEXNEWS_PRO_DEMO ); ?>" target="_blank">
                        <?php esc_html_e( '✨ Premium Demo', 'vortexnews' ); ?>
                    </a>
                </div>

                <h2><?php esc_html_e( '🔥 Limited Time Offer – Flat 15% OFF on Pro Themes!', 'vortexnews' ); ?></h2>
                
                <p><?php esc_html_e( "Upgrade today and get 15% off! Don't miss this exclusive deal! 💰", 'vortexnews' ); ?></p>
                
                <ul class="discount-benefits">
                    <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'vortexnews'); ?></li>
                    <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'vortexnews'); ?></li>
                    <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'vortexnews'); ?></li>
                    <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'vortexnews'); ?></li>
                </ul>
                
                <p class="discount-code">
                    <?php esc_html_e('👉 Use Code:', 'vortexnews'); ?> 
                    <span>SAVE15</span> 
                    <?php esc_html_e(' at Checkout', 'vortexnews'); ?>
                </p>
                
                <div class="info-link">
                    <a href="<?php echo esc_url( VORTEXNEWS_PRO_URL ); ?>" target="_blank">
                        <?php esc_html_e( '🛒 Shop Now', 'vortexnews' ); ?>
                    </a>
                </div>

                <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'vortexnews' ); ?></p>
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'vortexnews_discount_notice' );

// Add a Custom CSS file to WP Admin Area
function vortexnews_admin_page_theme_style() {
   wp_enqueue_style('vortexnews-custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getstarted/getstarted.css');
}
add_action('admin_enqueue_scripts', 'vortexnews_admin_page_theme_style');

//About Theme Info
function vortexnews_mostrar_main_content() { 

    //custom function about theme customizer

    $return = add_query_arg( array()) ;
    $theme = wp_get_theme( 'vortexnews' );
?>

<div class="theme-discount-banner">
    <h2><?php esc_html_e('🚀 Limited Time Offer – Flat 15% OFF on All Premium WordPress Themes! 🎉', 'vortexnews'); ?></h2>
    <p><?php esc_html_e('Upgrade your website with our stunning, high-performance WordPress themes at an exclusive 15% discount! 💰✨', 'vortexnews'); ?></p>
    
    <ul class="discount-benefits">
        <li>✅ <?php esc_html_e('SEO Optimized & Speed Fast 🚀', 'vortexnews'); ?></li>
        <li>✅ <?php esc_html_e('Fully Responsive & Mobile-Friendly 📱', 'vortexnews'); ?></li>
        <li>✅ <?php esc_html_e('Customizer Support for Easy Customization 🎨', 'vortexnews'); ?></li>
        <li>✅ <?php esc_html_e('Premium Features & Regular Updates 🔥', 'vortexnews'); ?></li>
    </ul>
    
    <p class="discount-code"><?php esc_html_e('👉 Use Code: ', 'vortexnews'); ?> <span>SAVE15</span> <?php esc_html_e(' at Checkout', 'vortexnews'); ?></p>
    
    <a href="https://cawpthemes.com/vortexnews-premium-wordpress-theme/" class="cta-button"><?php esc_html_e('Shop Now 🚀', 'vortexnews'); ?></a>
    
    <p class="offer-expiry"><?php esc_html_e('📅 Hurry! Offer ends soon.', 'vortexnews'); ?></p>
</div>

<div class="admin-main-box">
    <div class="admin-left-box">
        <h2><?php esc_html_e( 'Welcome to VortexNews Theme', 'vortexnews' ); ?><span class="version"><?php $theme_info = wp_get_theme();
echo $theme_info->get( 'Version' );?></span></h2>
        <p><?php esc_html_e('CA WP Themes is a premium WordPress theme development company that provides high-quality themes for various types of websites. They specialize in creating themes for businesses, eCommerce, portfolios, blogs, and many more. Their themes are easy to use and customize, making them perfect for those who want to create a professional-looking website without any coding skills.','vortexnews'); ?></p>
        <p><?php esc_html_e('CA WP Themes offers a wide range of themes that are designed to be responsive and compatible with the latest versions of WordPress. Our themes are also SEO optimized, ensuring that your website will rank well on search engines. They come with a variety of features such as customizable widgets, social media integration, and custom page templates.','vortexnews'); ?></p>
        <p><?php esc_html_e('One of the unique things about CA WP Themes is their focus on providing excellent customer support. They have a dedicated team of support staff who are available 24/7 to help customers with any issues they may encounter. Their support team is knowledgeable and friendly, ensuring that customers receive the best possible experience.','vortexnews'); ?></p>
    </div>
    <div class="admin-right-box">
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Buy Vortexnews Premium Theme','vortexnews'); ?></h4>
            <p><?php esc_html_e('Now the Premium Version is only at $39.99 with Lifetime Access!Grab the deal now!', 'vortexnews'); ?></p>
            <div class="info-link">
                <a href="<?php echo esc_url( VORTEXNEWS_PRO_URL ); ?>" target="_blank"> <?php esc_html_e( 'Upgrade to Pro', 'vortexnews' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Premium Theme Demo','vortexnews'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( VORTEXNEWS_PRO_DEMO ); ?>" target="_blank"> <?php esc_html_e( 'Demo', 'vortexnews' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Need Support? / Contact Us','vortexnews'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( VORTEXNEWS_PRO_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Contact Us', 'vortexnews' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Documentation','vortexnews'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( VORTEXNEWS_PRO_DOCUMENTATION ); ?>" target="_blank"> <?php esc_html_e( 'Docs', 'vortexnews' ); ?></a>
            </div>
        </div>
        <hr>
        <div class="admin_text-btn">
            <h4><?php esc_html_e('Free Theme','vortexnews'); ?></h4>
            <div class="info-link">
                <a href="<?php echo esc_url( VORTEXNEWS_FREE_URL ); ?>" target="_blank"> <?php esc_html_e( 'Demo', 'vortexnews' ); ?></a>
            </div>
        </div>

    </div>
</div>

<?php } ?>