<?php
/**
 * Add custom settings and controls to the WordPress Customizer
 */


//---------------------Code to add the Upgrade to Pro button in the Customizer----------

function vortexnews_customize_register_btn( $wp_customize ) {
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    get_template_part('inc/customizer-button/upsell-section');


    if ( isset( $wp_customize->selective_refresh ) ) {
        $wp_customize->selective_refresh->add_partial( 'blogname', array(
            'selector'        => '.site-title a',
            'render_callback' => 'vortexnews_customize_partial_blogname',
        ) );
        $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
            'selector'        => '.site-description',
            'render_callback' => 'vortexnews_customize_partial_blogdescription',
        ) );
    }

    $wp_customize->register_section_type( 'vortexnews_Customize_Upsell_Section' );

    // Register section.
    $wp_customize->add_section(
        new vortexnews_Customize_Upsell_Section(
            $wp_customize,
            'theme_upsell',
            array(
                'title'    => esc_html__( 'VortexNews Pro', 'vortexnews' ),
                'pro_text' => esc_html__( 'Upgrade To Pro', 'vortexnews' ),
                'pro_url'  => 'https://cawpthemes.com/vortexnews-premium-wordpress-theme/',
                'priority' => 1,
            )
        )
    );
}
add_action( 'customize_register', 'vortexnews_customize_register_btn' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function vortexnews_customize_partial_blogname() {
    bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function vortexnews_customize_partial_blogdescription() {
    bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function vortexnews_customize_preview_js() {
    wp_enqueue_script( 'vortexnews-customizer', get_template_directory_uri() . '/inc/customizer-button/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'vortexnews_customize_preview_js' );

/**
 * Customizer control scripts and styles.
 *
 * @since 1.0.0
 */
function vortexnews_customizer_control_scripts() {

    wp_enqueue_style( 'vortexnews-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.css', '', '1.0.0' );

    wp_enqueue_script( 'vortexnews-customize-controls', get_template_directory_uri() . '/inc/customizer-button/customize-controls.js', array( 'customize-controls' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'vortexnews_customizer_control_scripts', 0 );


//---------------------Code to add the Upgrade to Pro button in the Customizer End----------


//------------------Theme Information--------------------




function vortexnews_customize_register( $wp_customize ) {

  
      // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'vortexnews_site_identity_color', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vortexnews_site_identity_color', array(
    'label' => __( 'Site Identity Color', 'vortexnews' ),
    'section' => 'title_tagline',
    'settings' => 'vortexnews_site_identity_color',
  ) ) );


  // Add a custom setting for the Site Identity color
  $wp_customize->add_setting( 'vortexnews_site_identity_tagline_color', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vortexnews_site_identity_tagline_color', array(
    'label' => __( 'Tagline Color', 'vortexnews' ),
    'section' => 'title_tagline',
    'settings' => 'vortexnews_site_identity_tagline_color',
  ) ) );

//------------------Site Identity Ends---------------------

  
  // Add a custom setting for the primary color
  $wp_customize->add_setting( 'vortexnews_primary_color', array(
    'default' => '#fc5e18',
    'sanitize_callback' => 'sanitize_hex_color',
  ) );

  // Add a custom control for the primary color
  $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'vortexnews_primary_color', array(
    'label' => __( 'Primary Color', 'vortexnews' ),
    'section' => 'colors',
    'settings' => 'vortexnews_primary_color',
  ) ) );

  //-----------------------------------Home Front Page-------------------------------

  $wp_customize->add_panel( 'vortexnews_panel', array(
    'title'    => __( 'Front Page Settings', 'vortexnews' ),
    'priority' => 6,
  ) );


  //-------------------------------------Banner Image Section--------------

      $wp_customize->add_section( 'vortexnews_section_banner', array(
        'title'    => __( 'Advertisement Banner', 'vortexnews' ),
        'priority' => 8,
        'panel'    => 'vortexnews_panel',
    ) );


  $wp_customize->add_setting('vortexnews_section_bannerimage_section',array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
  ));
  $wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'vortexnews_section_bannerimage_section',array(
    'label' => __('Section Background Image','vortexnews'),
    'description' => __('Dimention 700 * 140','vortexnews'),
    'section' => 'vortexnews_section_banner',
    'settings' => 'vortexnews_section_bannerimage_section'
  )));



  //-------------------------Section One (Featured Post)------------------------------------------

  $wp_customize->add_section( 'vortexnews_section1', array(
        'title'    => __( 'Latest Post', 'vortexnews' ),
        'priority' => 10,
        'panel'    => 'vortexnews_panel',
    ) );


  //-----------------Enable Option Section One-------------

  $wp_customize->add_setting('vortexnews_section1_enable',array(
      'default' => 'Enable',
      'sanitize_callback' => 'vortexnews_sanitize_choices'
  ));
  $wp_customize->add_control('vortexnews_section1_enable',array(
        'type' => 'radio',
        'label' => __('Do you want this section', 'vortexnews'),
        'section' => 'vortexnews_section1',
        'choices' => array(
            'Enable' => __('Enable', 'vortexnews'),
            'Disable' => __('Disable', 'vortexnews')
  )));

  //-----------Category------------

  $categories = get_categories();
  $cats = array();
  $i = 0;
  foreach($categories as $category){
    if($i==0){
      $default = $category->name;
      $i++;
    }
    $cats[$category->name] = $category->name;
  }

  $wp_customize->add_setting('vortexnews_section1_category',array(
  'sanitize_callback' => 'sanitize_text_field',
  ));
  $wp_customize->add_control('vortexnews_section1_category',array(
    'type'    => 'select',
    'choices' => $cats,
    'label' => __('Select Category to Display Post','vortexnews'),
    'section' => 'vortexnews_section1',
    'sanitize_callback' => 'sanitize_text_field',
  ));



    $wp_customize->add_setting('vortexnews_section1_category_number_of_posts_setting',array(
    'default' => '3',
    'sanitize_callback' => 'sanitize_text_field'
  ));
  $wp_customize->add_control('vortexnews_section1_category_number_of_posts_setting',array(
    'label' => __('Number of Posts','vortexnews'),
    'section' => 'vortexnews_section1',
    'setting' => 'vortexnews_section1_category_number_of_posts_setting',
    'type'    => 'number'
  )); 



  //-------------------------Footer Settings------------------------------


    $wp_customize->add_section( 'vortexnews_footer', array(
        'title'    => __( 'Footer Settings', 'vortexnews' ),
        'priority' => 10,
        'panel'    => 'vortexnews_panel',
    ) );


  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'vortexnews_footer_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'vortexnews_footer_text', array(
    'label' => __( 'Footer Text', 'vortexnews' ),
    'section' => 'vortexnews_footer',
    'type' => 'text',
  ) );


 //-------------------404 Page-----------

  $wp_customize->add_section( 'vortexnews_404page', array(
    'title'    => __( '404 Page Settings', 'vortexnews' ),
    'priority' => 12,
    'panel'    => 'vortexnews_panel',
    ) );


  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'vortexnews_404page_title', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'vortexnews_404page_title', array(
    'label' => __( 'Page Not Found Title', 'vortexnews' ),
    'section' => 'vortexnews_404page',
    'type' => 'text',
  ) );

  // Add a custom setting for the footer text
  $wp_customize->add_setting( 'vortexnews_404page_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
  ) );

  // Add a custom control for the footer text
  $wp_customize->add_control( 'vortexnews_404page_text', array(
    'label' => __( 'Page Not Found Text', 'vortexnews' ),
    'section' => 'vortexnews_404page',
    'type' => 'text',
  ) );

//--------------------------------------General Settings------------------------------------------

  $wp_customize->add_section( 'vortexnews_general', array(
        'title'    => __( 'General Settings', 'vortexnews' ),
        'panel'    => 'vortexnews_panel',
    ) );

    $wp_customize->add_setting( 'vortexnews_post_meta_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'vortexnews_post_meta_toggle_switch_control', array(
        'label'    => __( 'Display Time/Author', 'vortexnews' ),
        'section'  => 'vortexnews_general',
        'settings' => 'vortexnews_post_meta_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );


    $wp_customize->add_setting( 'vortexnews_post_readmore_toggle_switch_control', array(
        'default'   => true,
        'sanitize_callback' => 'sanitize_text_field', // Use a suitable sanitization function based on your needs
        'transport' => 'refresh', // or 'postMessage' for instant preview without page refresh
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'vortexnews_post_readmore_toggle_switch_control', array(
        'label'    => __( 'Display Readmore Link', 'vortexnews' ),
        'section'  => 'vortexnews_general',
        'settings' => 'vortexnews_post_readmore_toggle_switch_control',
        'type'     => 'checkbox',
    ) ) );

}
add_action( 'customize_register', 'vortexnews_customize_register' );





