<?php
/**
 * The Header for our theme.
 *
 * @package vortexnews
 */
?>

<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width">
  <link rel="profile" href="https://gmpg.org/xfn/11">
  <?php if (is_singular() && pings_open(get_queried_object())) : ?>
    <link rel="pingback" href="<?php echo esc_url(get_bloginfo('pingback_url')); ?>">
  <?php endif; ?>
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

  <?php do_action('wp_body_open'); ?>
  <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'vortexnews'); ?></a>

<div class="container">
  <div class="date-time-file">
    <span class="topbar-date-head"><?php echo esc_html( date_i18n( 'F j, Y' ) ); ?><p id="clock"></p></span>  
  </div>
  <div class="head-banner-img">
    <?php if (get_header_image()) : ?>
      <div class="site-img-header">
        <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
          <img src='<?php echo esc_url(get_header_image()); ?>' alt='Banner Image'>
        </a>
      </div>
      <div class="site-branding">
        <?php if (has_custom_logo()) : ?>
          <div class="site-logo"><?php the_custom_logo(); ?></div>
        <?php else : ?>
          <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
          <p class="site-description"><?php bloginfo('description'); ?></p>
        <?php endif; ?>
      </div>
    <?php else : ?>
      <div class="row">
        <div class="col-lg-4">
          <div class="display_only">
            <?php if (has_custom_logo()) : ?>
              <div class="site-logo"><?php the_custom_logo(); ?></div>
            <?php else : ?>
              <h1><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
              <p><?php bloginfo('description'); ?></p>
            <?php endif; ?>
          </div>
        </div>
        <div class="col-lg-8">
            <div class="add-banner">
              <?php if(get_theme_mod('vortexnews_section_bannerimage_section')!=''){ ?>
                <img src="<?php echo esc_url(get_theme_mod('vortexnews_section_bannerimage_section')); ?>" alt="Image">
              <?php } ?>
            </div>
        </div>
      </div>
    <?php endif; ?>
  </div>
</div>

<header id="Main-head-class" class="site-header">
  <div class="container">
    <!-- before header hook -->
    <?php do_action('vortexnews-_before_header'); ?>
    <?php get_template_part('template-parts/header/header-file'); ?>
  </div>
</header>






