<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'volleyball-coach' ); ?></a>

<?php if(get_theme_mod('volleyball_coach_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'volleyball_coach_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'volleyball-coach' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'volleyball_coach_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<div class="top-bar text-center wow fadeInDown">
	<div class="container">
		<?php if ( get_theme_mod('volleyball_coach_topbar_text') ) : ?>
    		<p class="mb-0"><i class="fas fa-truck me-2"></i><?php echo esc_html(get_theme_mod('volleyball_coach_topbar_text'));?></p>
    	<?php endif; ?>
	</div>
</div>

<header id="site-navigation">
	<div class="header-center-box wow fadeInLeft">
		<div class="container">
			<div class="row">
				<div class="col-lg-1 col-md-1 col-12 align-self-center text-lg-start search-cart">
					<div class="offcanvas-div d-flex">
						<button type="button" data-bs-toggle="offcanvas" data-bs-target="#demo">
							<i class="fas fa-bars"></i>
						</button>
						<div class="offcanvas offcanvas-end" id="demo">
							<div class="offcanvas-header"> 
								<button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
							</div>
							<div class="offcanvas-body">
								<?php dynamic_sidebar('volleyball-coach-menu-sidebar'); ?>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-4 col-md-4 align-self-center">
					<div class="logo text-center text-md-start">
			    		<div class="logo-image">
			    			<?php the_custom_logo(); ?>
				    	</div>
				    	<div class="logo-content">
					    	<?php
					    		if ( get_theme_mod('volleyball_coach_display_header_title', true) == true ) :
						      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
						      			echo esc_html(get_bloginfo('name'));
						      		echo '</a>';
						      	endif;

						      	if ( get_theme_mod('volleyball_coach_display_header_text', false) == true ) :
					      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
					      		endif;
				    		?>
						</div>
					</div>
				</div>
				<div class="col-lg-5 col-md-5 align-self-center text-center text-md-end">
					<?php if(class_exists('woocommerce')){ ?>
						<div class="woo-search-info">
			          		<form method="get" class="woocommerce-product-search" action="<?php echo esc_url(home_url('/')); ?>">
				            	<label class="screen-reader-text" for="woocommerce-product-search-field"><?php esc_html_e('Search for:', 'volleyball-coach'); ?></label>
					            <input type="search" id="woocommerce-product-search-field" class="search-field " placeholder="<?php echo esc_attr('Search Here','volleyball-coach'); ?>" value="<?php echo get_search_query(); ?>" name="s"/>
					            <button type="submit" class="search-button"><i class="fas fa-search"></i></button>
					            <input type="hidden" name="post_type" value="product"/>
				          	</form>
				        </div>
			        <?php }?>
				</div>
				<div class="col-lg-2 col-md-2 text-center text-md-end align-self-center">
					<div class="woo-other-info my-3 my-md-0">
						<?php if ( get_theme_mod('volleyball_coach_header_wishlist_link') ) : ?>
							<a href="<?php echo esc_url(get_theme_mod('volleyball_coach_header_wishlist_link'));?>"><i class="fas fa-heart me-4"></i></a>
						<?php endif; ?>
						<?php if ( class_exists( 'woocommerce' ) ) {?>
							<a class="cart-customlocation" href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>" title="<?php esc_attr_e( 'View Shopping Cart','volleyball-coach' ); ?>"><i class="fas fa-shopping-bag"></i><span class="cart-item-box"><?php echo esc_html(wp_kses_data( WC()->cart->get_cart_contents_count() ));?></span></a>
						<?php }?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="header-menu-box wow fadeInRight">
		<div class="container">
			<div class="row">
				<div class="col-lg-4 col-md-10 col-10 align-self-center text-center text-md-start position-relative">
					<?php if(class_exists('woocommerce')){ ?>
				      	<button class="product-btn"><?php esc_html_e('Volleyball Categories','volleyball-coach'); ?><i class="fas fa-chevron-down"></i></button>
				      	<div class="product-cat" style="display: none;">
				        	<?php
				          		$volleyball_coach_args = array(
				                'orderby'    => 'title',
				                'order'      => 'ASC',
				                'hide_empty' => 0,
				                'parent'  => 0
				          	);
				          	$volleyball_coach_product_categories = get_terms( 'product_cat', $volleyball_coach_args );
				          	$count = count($volleyball_coach_product_categories);
				          	if ( $count > 0 ){
				      			foreach ( $volleyball_coach_product_categories as $volleyball_coach_product_category ) {
				                    $product_cat_id = $volleyball_coach_product_category->term_id;
				                    $cat_link = get_category_link( $product_cat_id );
				                	if ($volleyball_coach_product_category->category_parent == 0) { ?>
				              		<li class="drp_dwn_menu"><a href="<?php echo esc_url(get_term_link( $volleyball_coach_product_category ) ); ?>">
				              	<?php
				            }
				            echo esc_html( $volleyball_coach_product_category->name ); ?></a></li>
				        	<?php } } ?>
				      	</div>
				    <?php }?>
				</div>
				<div class="col-lg-8 col-md-2 col-2 align-self-center text-center text-md-end">
					<div class="top-menu-wrapper">
					    <div class="navigation_header">
					        <div class="toggle-nav mobile-menu">
					            <button onclick="volleyball_coach_openNav()">
					                <span class="dashicons dashicons-menu"></span>
					            </button>
					        </div>
					        <div id="mySidenav" class="nav sidenav">
					            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'volleyball-coach' ); ?>">
					                <?php {
					                    wp_nav_menu(
					                        array(
					                            'theme_location' => 'main-menu',
					                            'container_class' => 'navi clearfix navbar-nav',
					                            'menu_class'     => 'menu clearfix',
					                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					                            'fallback_cb'    => 'wp_page_menu',
					                        )
					                    );
					                } ?>
					            </nav>
					            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="volleyball_coach_closeNav()">
					                <span class="dashicons dashicons-no"></span>
					            </a>
					        </div>
					    </div>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>