<?php if ( get_theme_mod('volleyball_coach_blog_box_enable',false) ) : ?>

<?php $volleyball_coach_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('volleyball_coach_blog_slide_category'),
  'posts_per_page' => get_theme_mod('volleyball_coach_blog_slide_number'),
); ?>

<div class="slider">
  <div class="owl-carousel">
    <?php $volleyball_coach_arr_posts = new WP_Query( $volleyball_coach_args );
    if ( $volleyball_coach_arr_posts->have_posts() ) :
      while ( $volleyball_coach_arr_posts->have_posts() ) :
        $volleyball_coach_arr_posts->the_post();
        ?>
        <div class="blog_inner_box">
         <?php
            if ( has_post_thumbnail() ) :
              the_post_thumbnail();
            else:
              ?>
              <div class="slider-alternate">
                <img src="<?php echo esc_url( get_stylesheet_directory_uri() ). '/assets/images/banner.png'; ?>">
              </div>
              <?php
            endif;
          ?>
          <div class="blog_box">
            <div class="blog_box_inner">
              <h3><a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php the_title(); ?></a></h3>
              <p><?php echo wp_trim_words( get_the_content(), 35); ?></p>
              <p class="slider-button mt-4">
                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Shop Collection','volleyball-coach'); ?></a>
              </p>
            </div>
          </div>
        </div>
      <?php
    endwhile;
    wp_reset_postdata();
    endif; ?>
  </div>
</div>

<?php endif; ?>