<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_volleyball_coach_dismissed_notice_handler', 'volleyball_coach_ajax_notice_handler' );

function volleyball_coach_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function volleyball_coach_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_volleyball-coach-guide-page' &&
            $current_screen->id !== 'appearance_page_volleyballcoach-wizard'
        ) {
            $volleyball_coach_comments_theme = wp_get_theme();
            ?>
            <div class="volleyball-coach-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="volleyball-coach-notice">
                    <div class="volleyball-coach-notice-content">
                        <div class="volleyball-coach-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'volleyball-coach'); ?>
                                <?php echo esc_html( $volleyball_coach_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'volleyball-coach'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'volleyball-coach'),
                                    $volleyball_coach_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=volleyball-coach-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'volleyball-coach'); ?>
                            </a>
                            <a class="button button-primary" href="<?php echo esc_url( VOLLEYBALL_COACH_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'volleyball-coach'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=volleyballcoach-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'volleyball-coach'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="volleyball-coach-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'volleyball-coach'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'volleyball_coach_deprecated_hook_admin_notice' );
add_action( 'admin_menu', 'volleyball_coach_getting_started' );
function volleyball_coach_getting_started() {
	add_theme_page( esc_html__('Get Started', 'volleyball-coach'), esc_html__('Get Started', 'volleyball-coach'), 'edit_theme_options', 'volleyball-coach-guide-page', 'volleyball_coach_test_guide');
}

function volleyball_coach_admin_enqueue_scripts() {
	wp_enqueue_style( 'volleyball-coach-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'volleyball-coach-admin-script', get_template_directory_uri() . '/js/volleyball-coach-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'volleyball-coach-admin-script', 'volleyball_coach_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'volleyball_coach_admin_enqueue_scripts' );


if ( ! defined( 'VOLLEYBALL_COACH_DOCS_FREE' ) ) {
define('VOLLEYBALL_COACH_DOCS_FREE',__('https://demo.misbahwp.com/docs/volleyball-coach-free-docs/','volleyball-coach'));
}
 if ( ! defined( 'VOLLEYBALL_COACH_DOCS_PRO' ) ) {
define('VOLLEYBALL_COACH_DOCS_PRO',__('https://demo.misbahwp.com/docs/volleyball-coach-pro-docs','volleyball-coach'));
}
if ( ! defined( 'VOLLEYBALL_COACH_BUY_NOW' ) ) {
define('VOLLEYBALL_COACH_BUY_NOW',__('https://www.misbahwp.com/products/volleyball-coach-wordpress-theme','volleyball-coach'));
}
if ( ! defined( 'VOLLEYBALL_COACH_SUPPORT_FREE' ) ) {
define('VOLLEYBALL_COACH_SUPPORT_FREE',__('https://wordpress.org/support/theme/volleyball-coach','volleyball-coach'));
}
if ( ! defined( 'VOLLEYBALL_COACH_REVIEW_FREE' ) ) {
define('VOLLEYBALL_COACH_REVIEW_FREE',__('https://wordpress.org/support/theme/volleyball-coach/reviews/#new-post','volleyball-coach'));
}
if ( ! defined( 'VOLLEYBALL_COACH_DEMO_PRO' ) ) {
define('VOLLEYBALL_COACH_DEMO_PRO',__('https://demo.misbahwp.com/volleyball-coach/','volleyball-coach'));
}
if( ! defined( 'VOLLEYBALL_COACH_THEME_BUNDLE' ) ) {
define('VOLLEYBALL_COACH_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','volleyball-coach'));
}

function volleyball_coach_test_guide() { ?>
	<?php $volleyball_coach_theme = wp_get_theme(); ?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( VOLLEYBALL_COACH_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'volleyball-coach' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'volleyball-coach' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( VOLLEYBALL_COACH_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'volleyball-coach' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( VOLLEYBALL_COACH_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'volleyball-coach' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','volleyball-coach'); ?><?php echo esc_html( $volleyball_coach_theme ); ?>  <span><?php esc_html_e('Version: ', 'volleyball-coach'); ?><?php echo esc_html($volleyball_coach_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','volleyball-coach'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','volleyball-coach'); ?></p>
					<a class="button button-primary import" href="themes.php?page=volleyballcoach-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','volleyball-coach'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $volleyball_coach_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$volleyball_coach_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $volleyball_coach_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="volleyball-postboxx">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'volleyball-coach' ); ?></h3>
				<div class="volleyball-insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','volleyball-coach'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( VOLLEYBALL_COACH_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'volleyball-coach' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( VOLLEYBALL_COACH_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'volleyball-coach' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( VOLLEYBALL_COACH_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'volleyball-coach' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'volleyball-coach' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'volleyball-coach'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','volleyball-coach'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','volleyball-coach'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','volleyball-coach'); ?></span></p>
					<div id="admin_pro_linkss">
						<a class="blue-button-1" href="<?php echo esc_url( VOLLEYBALL_COACH_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Theme Bundle', 'volleyball-coach' ) ?></a>
					</div>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','volleyball-coach'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','volleyball-coach'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','volleyball-coach'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','volleyball-coach'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>
