<?php

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'volleyball_coach_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'volleyball-coach' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'volleyball-coach' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'volleyball-coach' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'volleyball_coach_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'volleyball-coach' ),
	) );

	Kirki::add_section( 'volleyball_coach_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'volleyball-coach' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_all_headings_typography',
		'section'     => 'volleyball_coach_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'volleyball_coach_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'volleyball-coach' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'volleyball-coach' ),
		'section'     => 'volleyball_coach_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_body_content_typography',
		'section'     => 'volleyball_coach_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'volleyball_coach_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'volleyball-coach' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'volleyball-coach' ),
		'section'     => 'volleyball_coach_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'volleyball_coach_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'volleyball-coach' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'volleyball_coach_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'volleyball-coach' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'volleyball_coach_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'volleyball-coach' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'volleyball_coach_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'volleyball-coach' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'volleyball_coach_dark_colors',
	    'section'     => 'volleyball_coach_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'volleyball-coach' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'volleyball_coach_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'volleyball-coach' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'volleyball_coach_section_404', array(
		'panel'          => 'volleyball_coach_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'volleyball-coach' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'volleyball_coach_404_heading',
	    'section'     => 'volleyball_coach_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'volleyball-coach' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_404_page_title',
		'section'  => 'volleyball_coach_section_404',
		'default'  => esc_html__('404 Not Found', 'volleyball-coach'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'volleyball_coach_404_text',
	    'section'     => 'volleyball_coach_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'volleyball-coach' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_404_page_content',
		'section'  => 'volleyball_coach_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'volleyball-coach'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'volleyball_coach_no_result', array(
		'panel'          => 'volleyball_coach_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'volleyball-coach' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'volleyball_coach_not_found_heading',
	    'section'     => 'volleyball_coach_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'volleyball-coach' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_no_results_page_title',
		'section'  => 'volleyball_coach_no_result',
		'default'  => esc_html__('404 Not Found', 'volleyball-coach'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'volleyball_coach_not_found_text',
	    'section'     => 'volleyball_coach_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'volleyball-coach' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_no_results_page_content',
		'section'  => 'volleyball_coach_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'volleyball-coach'),
		'priority' => 10,
	] );

	// PANEL

	Kirki::add_panel( 'volleyball_coach_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'volleyball-coach' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'volleyball_coach_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'volleyball-coach' ),
	    'panel'          => 'volleyball_coach_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_global_colors',
		'section'     => 'volleyball_coach_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'volleyball_coach_first_color',
		'label'       => __( 'Choose Your First Color', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_color',
		'default'     => '#CE1B1F',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'volleyball_coach_second_color',
		'label'       => __( 'Choose Your Second Color', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_color',
		'default'     => '#CFCC30',
	] );

	// Additional Settings

	Kirki::add_section( 'volleyball_coach_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'volleyball-coach' ),
	    'panel'          => 'volleyball_coach_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'volleyball_coach_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'volleyball_coach_scroll_top_position',
			'label'       => esc_html__( 'Alignment for Scroll To Top', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_additional_settings',
			'default'     => 'Right',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'volleyball-coach' ),
				'Center' => esc_html__( 'Center', 'volleyball-coach' ),
				'Right'  => esc_html__( 'Right', 'volleyball-coach' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'volleyball_coach_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'volleyball-coach' ),
		'section'  => 'volleyball_coach_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
		[
			'settings'    => 'menu_text_transform_volleyball_coach',
			'label'       => esc_html__( 'Menus Text Transform', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_additional_settings',
			'default'     => 'CAPITALISE',
			'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
			'choices'     => [
				'CAPITALISE' => esc_html__( 'CAPITALISE', 'volleyball-coach' ),
				'UPPERCASE' => esc_html__( 'UPPERCASE', 'volleyball-coach' ),
				'LOWERCASE' => esc_html__( 'LOWERCASE', 'volleyball-coach' ),

			],
		]
	);

		new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default' => 'Zoom Out',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'Zoomout' => __('Zoom Out','volleyball-coach'),
            'Zoominn' => __('Zoom Inn','volleyball-coach'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'volleyball_coach_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'volleyball_coach_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','volleyball-coach'),
            'cube-loader' => __('Type 2','volleyball-coach'),
		],
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
            'Right Sidebar' => __('Right Sidebar','volleyball-coach'),
            'One Column' => __('One Column','volleyball-coach')
		],
	] );

	if ( class_exists("woocommerce")){

		// Woocommerce Settings

		Kirki::add_section( 'volleyball_coach_woocommerce_settings', array(
			'title'          => esc_html__( 'Woocommerce Settings', 'volleyball-coach' ),
			'panel'          => 'volleyball_coach_panel_id',
			'priority'       => 160,
		) );

		Kirki::add_field( 'theme_config_id', [
		    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
		    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
		    'type'        => 'custom',
		    'section'     => 'volleyball_coach_woocommerce_settings',
		    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'volleyball_coach_shop_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'volleyball_coach_product_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'volleyball_coach_related_product_setting',
			'label'       => esc_html__( 'Here you can enable or disable your related products.', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default'     => true,
			'priority'    => 10,
		] );

		new \Kirki\Field\Number(
			[
				'settings' => 'volleyball_coach_per_columns',
				'label'    => esc_html__( 'Product Per Row', 'volleyball-coach' ),
				'section'  => 'volleyball_coach_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'volleyball_coach_product_per_page',
				'label'    => esc_html__( 'Product Per Page', 'volleyball-coach' ),
				'section'  => 'volleyball_coach_woocommerce_settings',
				'default'  => 9,
				'choices'  => [
					'min'  => 1,
					'max'  => 15,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number_per_row',
				'label'    => esc_html__( 'Related Product Per Column', 'volleyball-coach' ),
				'section'  => 'volleyball_coach_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

	new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number',
				'label'    => esc_html__( 'Related Product Per Page', 'volleyball-coach' ),
				'section'  => 'volleyball_coach_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 10,
					'step' => 1,
				],
			]
		);


		new \Kirki\Field\Select(
		[
			'settings'    => 'volleyball_coach_shop_page_layout',
			'label'       => esc_html__( 'Shop Page Layout Setting', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
	            'Right Sidebar' => __('Right Sidebar','volleyball-coach')
			],
		] );

		new \Kirki\Field\Select(
		[
			'settings'    => 'volleyball_coach_product_page_layout',
			'label'       => esc_html__( 'Product Page Layout Setting', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
	            'Right Sidebar' => __('Right Sidebar','volleyball-coach')
			],
		] );

		new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'volleyball_coach_woocommerce_pagination_position',
			'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_woocommerce_settings',
			'default'     => 'Center',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'volleyball-coach' ),
				'Center' => esc_html__( 'Center', 'volleyball-coach' ),
				'Right'  => esc_html__( 'Right', 'volleyball-coach' ),
			],
		]
		);
	}

	// POST SECTION

	Kirki::add_section( 'volleyball_coach_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'volleyball-coach' ),
	    'panel'          => 'volleyball_coach_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'volleyball_coach_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'volleyball-coach' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'volleyball-coach' ),
		'section'  => 'volleyball_coach_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'volleyball-coach' ),
			'option2' => esc_html__( 'Post Meta', 'volleyball-coach' ),
			'option3' => esc_html__( 'Post Title', 'volleyball-coach' ),
			'option4' => esc_html__( 'Post Content', 'volleyball-coach' ),
			'option5' => esc_html__( 'Post Button', 'volleyball-coach' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'volleyball_coach_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'volleyball_coach_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
            'Right Sidebar' => __('Right Sidebar','volleyball-coach'),
            'Three Column' => __('Three Column','volleyball-coach'),
            'Four Column' => __('Four Column','volleyball-coach'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','volleyball-coach'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','volleyball-coach'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','volleyball-coach')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
            'Right Sidebar' => __('Right Sidebar','volleyball-coach'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','volleyball-coach'),
            'Right Sidebar' => __('Right Sidebar','volleyball-coach'),
            'Three Column' => __('Three Column','volleyball-coach'),
            'Four Column' => __('Four Column','volleyball-coach'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','volleyball-coach'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','volleyball-coach'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','volleyball-coach')
		],
	] );

		// Breadcrumb
		Kirki::add_section( 'volleyball_coach_bradcrumb', array(
		    'title'          => esc_html__( 'Breadcrumb Settings', 'volleyball-coach' ),
		    'panel'          => 'volleyball_coach_panel_id',
		    'priority'       => 160,
		) );

		Kirki::add_field( 'theme_config_id', [
		    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
		    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
		    'type'        => 'custom',
		    'section'     => 'volleyball_coach_bradcrumb',
		    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
		] );

		 Kirki::add_field( 'theme_config_id', [
			'type'        => 'custom',
			'settings'    => 'volleyball_coach_enable_breadcrumb_heading',
			'section'     => 'volleyball_coach_bradcrumb',
				'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'volleyball-coach' ) . '</h3>',
			'priority'    => 10,
		] );

	    Kirki::add_field( 'theme_config_id', [
			'type'        => 'switch',
			'settings'    => 'volleyball_coach_breadcrumb_enable',
			'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'volleyball-coach' ),
			'section'     => 'volleyball_coach_bradcrumb',
			'default'     => true,
			'priority'    => 10,
			'choices'     => [
				'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
				'off' => esc_html__( 'Disable', 'volleyball-coach' ),
			],
		] );

		Kirki::add_field( 'theme_config_id', [
	        'type'     => 'text',
	        'default'     => '/',
	        'settings' => 'volleyball_coach_breadcrumb_separator' ,
	        'label'    => esc_html__( 'Breadcrumb Separator',  'volleyball-coach' ),
	        'section'  => 'volleyball_coach_bradcrumb',
	    ] );

	// HEADER SECTION

	Kirki::add_section( 'volleyball_coach_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'volleyball-coach' ),
	    'panel'          => 'volleyball_coach_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_topbar_heading',
		'section'     => 'volleyball_coach_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Topbar Text', 'volleyball-coach' ) . '</h3>',
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'volleyball_coach_topbar_text' ,
        'section'  => 'volleyball_coach_section_header',
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_wishlist_heading',
		'section'     => 'volleyball_coach_section_header',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Wishlist', 'volleyball-coach' ) . '</h3>',
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'label'    =>  esc_html__( 'Wishlist Link', 'volleyball-coach' ),
        'settings' => 'volleyball_coach_header_wishlist_link' ,
        'section'  => 'volleyball_coach_section_header',
    ] );    
    
	// SLIDER SECTION

	Kirki::add_section( 'volleyball_coach_blog_slide_section', array(
        'title'          => esc_html__( ' Slider Settings', 'volleyball-coach' ),
        'panel'          => 'volleyball_coach_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_heading',
		'section'     => 'volleyball_coach_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_blog_slide_section',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_slider_heading',
		'section'     => 'volleyball_coach_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Main Slider', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'volleyball_coach_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_blog_slide_section',
		'default'     => 3,
		'choices'     => [
			'min'  => 0,
			'max'  => 80,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'volleyball_coach_blog_slide_category',
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 750 x 450 )', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'volleyball-coach' ),
		'priority'    => 10,
		'choices'     => volleyball_coach_get_categories_select(),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_second_slider_heading',
		'section'     => 'volleyball_coach_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Second Slider', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_blog_slide_section',
		'default'     => 'CENTER-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'volleyball-coach' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'volleyball-coach' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'volleyball-coach' ),

		],
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_slider_opacity_color',
		'label'       => esc_html__( 'Slider Opacity Option', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_blog_slide_section',
		'default'     => '0.5',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'0' => esc_html__( '0', 'volleyball-coach' ),
			'0.1' => esc_html__( '0.1', 'volleyball-coach' ),
			'0.2' => esc_html__( '0.2', 'volleyball-coach' ),
			'0.3' => esc_html__( '0.3', 'volleyball-coach' ),
			'0.4' => esc_html__( '0.4', 'volleyball-coach' ),
			'0.5' => esc_html__( '0.5', 'volleyball-coach' ),
			'0.6' => esc_html__( '0.6', 'volleyball-coach' ),
			'0.7' => esc_html__( '0.7', 'volleyball-coach' ),
			'0.8' => esc_html__( '0.8', 'volleyball-coach' ),
			'0.9' => esc_html__( '0.9', 'volleyball-coach' ),
			'unset' => esc_html__( 'Unset', 'volleyball-coach' ),
			

		],
	] );

	// SALES SECTION

	Kirki::add_section( 'volleyball_coach_sales_section', array(
        'title'          => esc_html__( 'Sales Text Settings', 'volleyball-coach' ),
        'panel'          => 'volleyball_coach_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_sales_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	    'priority'       => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_sale_enable_heading',
		'section'     => 'volleyball_coach_sales_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Sale Section',  'volleyball-coach' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_sales_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'volleyball-coach' ),
		'section'     => 'volleyball_coach_sales_section',
		'default'     => false,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'volleyball-coach' ),
			'off' => esc_html__( 'Disable',  'volleyball-coach' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_sale_text_heading',
		'section'     => 'volleyball_coach_sales_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sale Text', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_sales_text_heading',
		'section'  => 'volleyball_coach_sales_section',
		'default'  => '',
		'priority' => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_sale_btn_enable_heading',
		'section'     => 'volleyball_coach_sales_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Sales Button', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'    => __( 'Button Text', 'volleyball-coach' ),
		'settings' => 'volleyball_coach_sales_button_text',
		'section'  => 'volleyball_coach_sales_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'url',
		'label'    => __( 'Button Link', 'volleyball-coach' ),
		'settings' => 'volleyball_coach_sales_button_link',
		'section'  => 'volleyball_coach_sales_section',
		'default'  => '',
		'priority' => 10,
	] );

	// FEATURED PRODUCT SECTION

	Kirki::add_section( 'volleyball_coach_featured_product_section', array(
	    'title'          => esc_html__( 'Featured Product Settings', 'volleyball-coach' ),
	    'panel'          => 'volleyball_coach_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_featured_product_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	    'priority'       => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_heading',
		'section'     => 'volleyball_coach_featured_product_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Featured Product',  'volleyball-coach' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_featured_product_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'volleyball-coach' ),
		'section'     => 'volleyball_coach_featured_product_section',
		'default'     => false,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'volleyball-coach' ),
			'off' => esc_html__( 'Disable',  'volleyball-coach' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'volleyball_coach_featured_product_heading' ,
        'label'    => esc_html__( 'Heading',  'volleyball-coach' ),
        'section'  => 'volleyball_coach_featured_product_section',
    ] );

	// FOOTER SECTION

	Kirki::add_section( 'volleyball_coach_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'volleyball-coach' ),
        'panel'          => 'volleyball_coach_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'volleyball-coach' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( VOLLEYBALL_COACH_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'volleyball-coach' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'volleyball_coach_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'volleyball-coach' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_footer_enable_heading',
		'section'     => 'volleyball_coach_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'volleyball_coach_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'volleyball-coach' ),
			'off' => esc_html__( 'Disable', 'volleyball-coach' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_footer_text_heading',
		'section'     => 'volleyball_coach_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'volleyball-coach' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'volleyball_coach_footer_text',
		'section'  => 'volleyball_coach_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'volleyball_coach_footer_text_heading_2',
	'section'     => 'volleyball_coach_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'volleyball-coach' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'volleyball_coach_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'volleyball-coach' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'volleyball-coach' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'volleyball-coach' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'volleyball-coach' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'volleyball_coach_footer_text_heading_1',
	'section'     => 'volleyball_coach_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'volleyball-coach' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'volleyball_coach_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'volleyball-coach' ),
		'section'     => 'volleyball_coach_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'volleyball_coach_enable_footer_socail_link',
		'section'     => 'volleyball_coach_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'volleyball-coach' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'volleyball_coach_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'volleyball-coach' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'volleyball-coach' ),
		'settings'     => 'volleyball_coach_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'volleyball-coach' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'volleyball-coach' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'volleyball-coach' ),
				'description' => esc_html__( 'Add the social icon url here.', 'volleyball-coach' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}


add_action( 'customize_register', 'volleyball_coach_customizer_settings' );
function volleyball_coach_customizer_settings( $wp_customize ) {
	$volleyball_coach_args = array(
       'type'                     => 'product',
        'child_of'                 => 0,
        'parent'                   => '',
        'orderby'                  => 'term_group',
        'order'                    => 'ASC',
        'hide_empty'               => false,
        'hierarchical'             => 1,
        'number'                   => '',
        'taxonomy'                 => 'product_cat',
        'pad_counts'               => false
    );
	$categories = get_categories($volleyball_coach_args);
	$cat_posts = array();
	$m = 0;
	$cat_posts[]='Select';
	foreach($categories as $category){
		if($m==0){
			$default = $category->slug;
			$m++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('volleyball_coach_featured_product_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'volleyball_coach_sanitize_select',
	));
	$wp_customize->add_control('volleyball_coach_featured_product_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select category to display products ','volleyball-coach'),
		'section' => 'volleyball_coach_featured_product_section',
	));
}

/*
 *  Customizer Notifications
 */

$volleyball_coach_config_customizer = array(
    'recommended_plugins' => array( 
        'kirki' => array(
            'recommended' => true,
            'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the sections of the FrontPage, please install and activate %s plugin', 'volleyball-coach' ), 
                '<strong>' . esc_html__( 'Kirki Customizer', 'volleyball-coach' ) . '</strong>'
            ),
        ),
    ),
    'volleyball_coach_recommended_actions'       => array(),
    'volleyball_coach_recommended_actions_title' => esc_html__( 'Recommended Actions', 'volleyball-coach' ),
    'volleyball_coach_recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'volleyball-coach' ),
    'volleyball_coach_install_button_label'      => esc_html__( 'Install and Activate', 'volleyball-coach' ),
    'volleyball_coach_activate_button_label'     => esc_html__( 'Activate', 'volleyball-coach' ),
    'volleyball_coach_deactivate_button_label'   => esc_html__( 'Deactivate', 'volleyball-coach' ),
);

Volleyball_Coach_Customizer_Notify::init( apply_filters( 'volleyball_coach_customizer_notify_array', $volleyball_coach_config_customizer ) );