<?php

class Volleyball_Coach_Customizer_Notify {

	private $config = array(); // Declare $config property
	
	private $volleyball_coach_recommended_actions;
	
	private $recommended_plugins;
	
	private static $instance;
	
	private $volleyball_coach_recommended_actions_title;
	
	private $volleyball_coach_recommended_plugins_title;
	
	private $dismiss_button;
	
	private $volleyball_coach_install_button_label;
	
	private $volleyball_coach_activate_button_label;
	
	private $volleyball_coach_deactivate_button_label;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Volleyball_Coach_Customizer_Notify ) ) {
			self::$instance = new Volleyball_Coach_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $volleyball_coach_customizer_notify_recommended_plugins;
		global $volleyball_coach_customizer_notify_volleyball_coach_recommended_actions;

		global $volleyball_coach_install_button_label;
		global $volleyball_coach_activate_button_label;
		global $volleyball_coach_deactivate_button_label;

		$this->volleyball_coach_recommended_actions = isset( $this->config['volleyball_coach_recommended_actions'] ) ? $this->config['volleyball_coach_recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->volleyball_coach_recommended_actions_title = isset( $this->config['volleyball_coach_recommended_actions_title'] ) ? $this->config['volleyball_coach_recommended_actions_title'] : '';
		$this->volleyball_coach_recommended_plugins_title = isset( $this->config['volleyball_coach_recommended_plugins_title'] ) ? $this->config['volleyball_coach_recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$volleyball_coach_customizer_notify_recommended_plugins = array();
		$volleyball_coach_customizer_notify_volleyball_coach_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$volleyball_coach_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->volleyball_coach_recommended_actions ) ) {
			$volleyball_coach_customizer_notify_volleyball_coach_recommended_actions = $this->volleyball_coach_recommended_actions;
		}

		$volleyball_coach_install_button_label    = isset( $this->config['volleyball_coach_install_button_label'] ) ? $this->config['volleyball_coach_install_button_label'] : '';
		$volleyball_coach_activate_button_label   = isset( $this->config['volleyball_coach_activate_button_label'] ) ? $this->config['volleyball_coach_activate_button_label'] : '';
		$volleyball_coach_deactivate_button_label = isset( $this->config['volleyball_coach_deactivate_button_label'] ) ? $this->config['volleyball_coach_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'volleyball_coach_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'volleyball_coach_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'volleyball_coach_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'volleyball_coach_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function volleyball_coach_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'volleyball-coach-customizer-notify-css', get_template_directory_uri() . '/core/includes/customizer-notice/css/volleyball-coach-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'volleyball-coach-customizer-notify-js', get_template_directory_uri() . '/core/includes/customizer-notice/js/volleyball-coach-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'volleyball-coach-customizer-notify-js', 'volleyballcoachCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'volleyball-coach' ),
			)
		);

	}

	
	public function volleyball_coach_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/core/includes/customizer-notice/volleyball-coach-customizer-notify-section.php';

		$wp_customize->register_section_type( 'Volleyball_Coach_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new Volleyball_Coach_Customizer_Notify_Section(
				$wp_customize,
				'volleyball-coach-customizer-notify-section',
				array(
					'title'          => $this->volleyball_coach_recommended_actions_title,
					'plugin_text'    => $this->volleyball_coach_recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function volleyball_coach_customizer_notify_dismiss_recommended_action_callback() {

		global $volleyball_coach_customizer_notify_volleyball_coach_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'volleyball_coach_customizer_notify_show' ) ) {

				$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions = get_option( 'volleyball_coach_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'volleyball_coach_customizer_notify_show', $volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions );

				
			} else {
				$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions = array();
				if ( ! empty( $volleyball_coach_customizer_notify_volleyball_coach_recommended_actions ) ) {
					foreach ( $volleyball_coach_customizer_notify_volleyball_coach_recommended_actions as $volleyball_coach_lite_customizer_notify_recommended_action ) {
						if ( $volleyball_coach_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions[ $volleyball_coach_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions[ $volleyball_coach_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'volleyball_coach_customizer_notify_show', $volleyball_coach_customizer_notify_show_volleyball_coach_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function volleyball_coach_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$volleyball_coach_lite_customizer_notify_show_recommended_plugins = get_option( 'volleyball_coach_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$volleyball_coach_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$volleyball_coach_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'volleyball_coach_customizer_notify_show_recommended_plugins', $volleyball_coach_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
