<?php
/**
 * Template Name: blog
 * The template file for blog pages .

*/
get_header(); 
$vivacity_lite_mods = esc_attr(get_theme_mod('radio_blog'));

?>
<div id="main-content">

<div class="blog_second">
<div class="entry-content">

  <div class="entry-content-inner">   
    <section class="home-latest-posts">
      <h2 class="entry-headline"><span class="entry-headline-text"> <?php _e('BLOGS','vivacity-lite'); ?></span></h2>
<?php $vivacity_lite_args = array('post_type' => 'post');
 
//Define the loop based on arguments
 
$vivacity_lite_loop = new WP_Query( $vivacity_lite_args );
 
//Display the contents

//start content loop
 while ( $vivacity_lite_loop->have_posts() ) : $vivacity_lite_loop->the_post();
?>


<div>

<?php
if($vivacity_lite_mods=='one')
{?>
	
<?php
if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
  the_post_thumbnail("large");
}?>
<div style="clear:both"></div>

<h2 class="post-entry-headline"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
<div class="post-entry-content">

<?php echo substr(get_the_excerpt(), 0,200); ?>
</div><br>
<p class="post-meta">
<span class="post-info-author">
<i class="fa fa-user-plus"></i>&nbsp;&nbsp;<?php _e('Author:','vivacity-lite');?><?php the_author(); ?> 

</span>
<span class="post-info-date">
<i class="fa fa-calendar-o"></i>&nbsp;&nbsp;<?php _e('Date:','vivacity-lite');?><?php the_time('F jS, Y') ?>
</span>
<span class="post-info-comments">
<?php if ( comments_open() ) : ?>
      <i class="fa fa-file-o"></i>&nbsp;&nbsp;<a href="<?php comments_link(); ?>"><?php printf( _n( '1 Comment', '%1$s Comments', get_comments_number(), 'vivacity-lite' ), number_format_i18n( get_comments_number() ), get_the_title() ); ?></a>
<?php endif; ?>
</span>
</p>
<a class="read-more-button" href="<?php the_permalink();?>"><?php _e('Read more','vivacity-lite'); ?></a>

<?php 	}




	else{?>
	
<div class="blog_two_layout">
<?php
if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
  the_post_thumbnail("medium");
}?>
</div>
<div class="blog_two">
<h2 class="post-entry-headline"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
<div class="post-entry-content">

<?php echo substr(get_the_excerpt(), 0,200); ?>
</div><br>

</div>
<p class="post-meta">
<span class="post-info-author">
<i class="fa fa-user-plus"></i>&nbsp;&nbsp;<?php _e('Author:','vivacity-lite');?><?php the_author(); ?> 

</span>
<span class="post-info-date">
<i class="fa fa-calendar-o"></i>&nbsp;&nbsp;<?php _e('Date:','vivacity-lite');?><?php the_time('F jS, Y') ?>
</span>
<span class="post-info-comments">
<?php if ( comments_open() ) : ?>
      <i class="fa fa-file-o"></i>&nbsp;&nbsp;<a href="<?php comments_link(); ?>"><?php printf( _n( '1 Comment', '%1$s Comments', get_comments_number(), 'vivacity-lite' ), number_format_i18n( get_comments_number() ), get_the_title() ); ?></a>
<?php endif; ?>
</span>
</p>
<a class="read-more-button" href="<?php the_permalink();?>"><?php _e('Read more','vivacity-lite'); ?></a>

		<?php }
?>

</div>
<div style="clear:both;"></div><br><br>
<?php endwhile; wp_reset_postdata(); ?>

<?php vivacity_lite_nav( 'nav-below' ); ?>
   </section> 
  </div>
</div>
</div>
<div class="blog_fst">
<?php if ( dynamic_sidebar( 'sidebar-6' ) ) : else : ?>
<?php endif; ?> 
<?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>
</div>
