<?php
/**
 * The post template file.

*/
get_header(); ?>
<div id="main-content">
<div id="content">


<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
<div class="entry-content">
  <div class="entry-content-inner">
    <div class="content-headline">
      <h1 class="entry-headline"><span class="entry-headline-text"><?php the_title(); ?></span></h1>
    </div>


   <p class="post-meta">
<span class="post-info-author">
<i class="fa fa-user-plus"></i>&nbsp;&nbsp;<?php _e('Author:','vivacity-lite');?><?php the_author(); ?> 

</span>
<span class="post-info-date">
<i class="fa fa-calendar-o"></i>&nbsp;&nbsp;<?php _e('Date:','vivacity-lite');?><?php the_time('F jS, Y') ?>
</span>
<span class="post-info-comments">
<?php if ( comments_open() ) : ?>
      <i class="fa fa-file-o"></i>&nbsp;&nbsp;<a href="<?php comments_link(); ?>"><?php printf( _n( '1 Comment', '%1$s Comments', get_comments_number(), 'vivacity-lite' ), number_format_i18n( get_comments_number() ), get_the_title() ); ?></a>
<?php endif; ?>
</span>
</p>
    <div class="post-info">
      <p class="post-category"><span class="post-info-category"><?php the_category(', '); ?></span></p>
      <p class="post-tags"><?php the_tags( '<span class="post-info-tags">', ', ', '</span>' ); ?></p>
    </div>
<div class="post-entry-content">
<?php the_content(); ?>
</div>
<?php wp_link_pages( array( 'before' => '<p class="page-link"><span>' . __( 'Pages:', 'vivacity-lite' ) . '</span>', 'after' => '</p>' ) ); ?>
<?php edit_post_link( __( 'Edit', 'vivacity-lite' ), '<p>', '</p>' ); ?>
<?php endwhile; endif; ?>

<?php vivacity_lite_navigation('vivacity-post-nav'); ?>

  </div>
</div>
<?php comments_template( '', true ); ?>   
</div> <!-- end of content -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>