<?php
/**
 * The search results template file.

*/
get_header(); ?>
<?php if ( have_posts() ) : ?>
<div class="entry-content">
  <div class="entry-content-inner">   
    <div class="content-headline">
      <h1 class="entry-headline"><span class="entry-headline-text"><?php printf( __( 'Search Results for:', 'vivacity-lite' ).' %s', '<span>' . get_search_query() . '</span>' ); ?></span></h1>
    </div>
    <div class="archive-meta"><p class="number-of-results"><?php _e( 'Number of Results: ', 'vivacity-lite' ); ?><?php echo $wp_query->found_posts; ?></p></div>
<?php while (have_posts()) : the_post(); ?>
<?php get_template_part( 'content', 'archives' ); ?>
<?php endwhile; ?> 

<?php if ( $wp_query->max_num_pages > 1 ) : ?>
		<div class="navigation" role="navigation">
			<h2 class="navigation-headline section-heading"><?php _e( 'Search results navigation', 'vivacity-lite' ); ?></h2>
      <div class="nav-wrapper">
			 <p class="navigation-links">
<?php $vivacity_lite_big = 999999999;
echo paginate_links( array(
	'base' => str_replace( $vivacity_lite_big, '%#%', esc_url( get_pagenum_link( $vivacity_lite_big ) ) ),
	'format' => '?paged=%#%',
	'current' => max( 1, get_query_var('paged') ),
  'prev_text' => __( ' Previous', 'vivacity-lite' ),
	'next_text' => __( 'Next ', 'vivacity-lite' ),
	'total' => $wp_query->max_num_pages,
	'add_args' => false
) );
?>
        </p>
      </div>
    </div>
<?php endif; ?>

<?php else : ?>
<div class="entry-content">
  <div class="entry-content-inner">
    <div class="content-headline">
      <h1 class="entry-headline"><span class="entry-headline-text"><?php _e( 'Nothing Found', 'vivacity-lite' ); ?></span></h1>
    </div>
    <p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'vivacity-lite' ); ?></p>
<?php get_search_form(); ?>
<?php endif; ?> 
  </div>
</div> 
</div> <!-- end of content -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>