<?php
/**
 * Vivacity functions and definitions.

*/
$vivacity_lite_name = "Vivacity Lite";			
$vivacity_lite_version = "1.11";									
$vivacity_lite_title = "vivacity";							
/**
 * Vivacity theme basic setup.
 *  
*/
if ( ! isset( $content_width ) ) $content_width = 900;
function vivacity_lite_setting() {
	load_theme_textdomain( 'vivacity-lite', get_template_directory() . '/languages' );
   add_theme_support( 'automatic-feed-links' );
	$vivacity_lite_values = array(
'wp-head-callback' => '_custom_background_cb',
	'default-color' => '#000' );  
  add_theme_support( 'custom-background', $vivacity_lite_values );
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 972, 9999 );
	$vivacity_lite_fonts = add_query_arg( 'family', 'arial', "//fonts.googleapis.com/css" );
  add_editor_style( array( 'editor-style.css', $vivacity_lite_fonts ) );
  
  $vivacity_lite_var = array(
'random-default' => true,
	'width' => 1012,
 'flex-height' => true,
  'header-text' => false,
'flex-width' => true,
  );
  add_theme_support( 'custom-header', $vivacity_lite_var );
  add_theme_support( 'title-tag' );
  
 
}
add_action( 'after_setup_theme', 'vivacity_lite_setting' );

/**
 * Enqueues scripts and styles for front-end.
 *
*/
function vivacity_lite_scripts_styles() {
	global $vivacity_lite_styles, $vivacity_lite_scripts;
	// Adds JavaScript
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
    wp_enqueue_script( 'vivacity-lite-placeholders', get_template_directory_uri() . '/js/placeholders.js', array(), '3.0.2', true );
    wp_enqueue_script( 'vivacity-lite-scroll-to-top', get_template_directory_uri() . '/js/scroll-to-top.js', array( 'jquery' ), '1.0', true );
    if ( !is_page_template('template-landing-page.php') ) {
    wp_enqueue_script( 'vivacity-lite-menubox', get_template_directory_uri() . '/js/menubox.js', array( 'jquery' ), '1.0', true ); }
    wp_enqueue_script( 'vivacity-lite-selectnav', get_template_directory_uri() . '/js/selectnav.js', array(), '0.1', true );
    wp_enqueue_script( 'vivacity-lite-responsive', get_template_directory_uri() . '/js/responsive.js', array(), '1.0', true );
    wp_enqueue_script( 'vivacity-lite-bootstrap', get_template_directory_uri() . '/bootstrap-3.3.5-dist/js/bootstrap.min.js', array(), '1.0', true );
    wp_enqueue_script( 'vivacity-lite-html5-ie', get_template_directory_uri() . '/js/html5.js', array(), '3.6', false );
   wp_enqueue_style( 'vivacity-lite-google-font-awesome', get_template_directory_uri() . '/css/font-awesome-4.3.0/css/font-awesome.min.css' );
wp_enqueue_style( 'vivacity-lite-bootstraps', get_template_directory_uri() . '/bootstrap-3.3.5-dist/css/bootstrap.min.css' );	
	// Loads the main stylesheet.
	  wp_enqueue_style( 'vivacity-lite-style', get_stylesheet_uri() );
    
   
}
add_action( 'wp_enqueue_scripts', 'vivacity_lite_scripts_styles' );
/**
 * Register our sidebars and widgetized areas.
 *
*/
function vivacity_lite_sidebars() {
  register_sidebar( array(
		'name' => __( 'Main Sidebar', 'vivacity-lite' ),
		'id' => 'sidebar-1',
		'description' => __( 'Right sidebar which appears on all posts and pages.', 'vivacity-lite' ),
		'before_widget' => '<div id="%1$s" class="sidebar-widget %2$s"><div class="sidebar-widget-inner">',
		'after_widget' => '</div></div>',
		'before_title' => ' <p class="sidebar-headline"><span class="sidebar-headline-text">',
		'after_title' => '</span></p>',
	) );
  register_sidebar( array(
		'name' => __( 'Footer Left Area', 'vivacity-lite' ),
		'id' => 'sidebar-2',
		'description' => __( 'Left column with widgets in footer.', 'vivacity-lite' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<p class="footer-headline"><span class="footer-headline-text">',
		'after_title' => '</span></p>',
	) );
  register_sidebar( array(
		'name' => __( 'Footer Middle Area', 'vivacity-lite' ),
		'id' => 'sidebar-3',
		'description' => __( 'Middle column with widgets in footer.', 'vivacity-lite' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<p class="footer-headline"><span class="footer-headline-text">',
		'after_title' => '</span></p>',
	) );
  register_sidebar( array(
		'name' => __( 'Footer Right Area', 'vivacity-lite' ),
		'id' => 'sidebar-4',
		'description' => __( 'Right column with widgets in footer.', 'vivacity-lite' ),
		'before_widget' => '<div id="%1$s" class="footer-widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<p class="footer-headline"><span class="footer-headline-text">',
		'after_title' => '</span></p>',
	) );
  register_sidebar( array(
		'name' => __( 'Footer Notices', 'vivacity-lite' ),
		'id' => 'sidebar-5',
		'description' => __( 'The line for copyright and other notices below the footer widget areas. Insert here one Text widget. The Title field at this widget should stay empty.', 'vivacity-lite' ),
		'before_widget' => '<div class="footer-signature"><div class="footer-signature-content">',
		'after_widget' => '</div></div>',
		'before_title' => '',
		'after_title' => '',
	) );
  register_sidebar( array(
		'name' => __( 'Latest Homepage Area', 'vivacity-lite' ),
		'id' => 'sidebar-6',
		'description' => __( 'The area for any Vivacity Posts Widgets, which displays latest posts from a specific category below the default Latest Posts area.', 'vivacity-lite' ),
		'before_widget' => '<div class="entry-content"><div class="entry-content-inner">',
		'after_widget' => '</div></div>',
		'before_title' => '',
		'after_title' => '',
	) );
}
add_action( 'widgets_init', 'vivacity_lite_sidebars' );

/**
 * Post excerpt settings.
 *
*/
function vivacity_lite_length_excerpt( $vivacity_lite_length ) {
return 50;
}
add_filter( 'excerpt_length', 'vivacity_lite_length_excerpt', 20 );

function vivacity_lite_register_menu() {
  register_nav_menus(
    array(
'first-menu' => __( 'First Menu', 'vivacity-lite' ),
      'second-menu' => __( 'Second Menu', 'vivacity-lite' )
      
    )
  );
}
add_action( 'after_setup_theme', 'vivacity_lite_register_menu' );

require get_template_directory() . '/extras.php';


if ( ! function_exists( 'vivacity_lite_nav' ) ) :
/**
 * Displays navigation to next/previous pages when applicable.
 *
*/
function vivacity_lite_nav( $vivacity_lite_value ) {
	global $wp_query;
	$vivacity_lite_value = esc_attr( $vivacity_lite_value );
	if ( $wp_query->max_num_pages > 1 ) : ?>
		<div id="<?php echo $html_id; ?>" class="navigation" role="navigation">
    <div class="navigation-inner">
			<h2 class="navigation-headline section-heading"><?php _e( 'Post navigation', 'vivacity-lite' ); ?></h2>
      <div class="nav-wrapper">
			 <p class="navigation-links">
<?php $vivacity_lite_full = 999999999;
echo paginate_links( array(
	'base' => str_replace( $vivacity_lite_full, '%#%', esc_url( get_pagenum_link( $vivacity_lite_full ) ) ),
	'format' => '?paged=%#%',
	'current' => max( 1, get_query_var('paged') ),
  'prev_text' => __( 'Previous', 'vivacity-lite' ),
	'next_text' => __( 'Next', 'vivacity-lite' ),
	'total' => $wp_query->max_num_pages,
	'add_args' => false
) );
?>
        </p>
      </div>
		</div>
    </div>
	<?php endif;
}
endif;

if ( ! function_exists( 'vivacity_lite_comment' ) ) :
/**
 * Template for comments and pingbacks.
 *
*/
function vivacity_lite_comment( $vivacity_lite_comment, $vivacity_lite_args, $vivacity_lite_depth ) {
	$GLOBALS['comment'] = $vivacity_lite_comment;
	switch ( $vivacity_lite_comment->comment_type ) :
		case 'pingback' :
		case 'trackback' :
	?>
	<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<p><?php _e( 'Pingback:', 'vivacity-lite' ); ?> <?php comment_author_link(); ?> <?php echo "(";edit_comment_link( __( 'Edit', 'vivacity-lite' ), '<span class="edit-link">', '</span>' );echo ")"; ?></p>
	<?php
			break;
		default :
		global $vivacity_lite_post;
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>" class="comment">
			<div class="comment-meta comment-author vcard">
				<?php
					echo get_avatar( $vivacity_lite_comment, 44 );
					
					printf( '<time datetime="%2$s">%3$s</time>',
						esc_url( get_comment_link( $vivacity_lite_comment->comment_ID ) ),
						get_comment_time( 'c' ),
						// translators: 1: date, 2: time
						sprintf('%1$s '. __( 'at', 'vivacity-lite' ).' %2$s', get_comment_date(''), get_comment_time() )
						//sprintf( '%1$s '. __( 'at', 'vivacity-lite' ).' %2$s', get_comment_date(''), get_comment_time() )
					);
				?>
			</div><!-- .comment-meta -->

			<?php if ( '0' == $vivacity_lite_comment->comment_approved ) : ?>
				<p class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'vivacity-lite' ); ?></p>
			<?php endif; ?>

			<div class="comment-content comment">
				<?php comment_text(); ?>
			 <div class="reply">
			   <?php comment_reply_link( array_merge( $vivacity_lite_args, array( 'reply_text' => __( 'Reply', 'vivacity-lite' ), 'after' => ' <span>&darr;</span>', 'depth' => $vivacity_lite_depth, 'max_depth' => $vivacity_lite_args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
			   <?php edit_comment_link( __( 'Edit', 'vivacity-lite' ), '<p class="edit-link">', '</p>' ); ?>
			</div><!-- .comment-content -->
		</div><!-- #comment-## -->
	<?php
		break;
	endswitch;
}
endif;


function vivacity_lite_navigation($vivacity_lite_nav) { ?>
<?php $vivacity_lite_prepost = get_adjacent_post( false, "", true );
$vivacity_lite_nextpost = get_adjacent_post( false, "", false ); ?>
<div id="<?php echo $vivacity_lite_nav; ?>" class="navigation" role="navigation">
	<div class="nav-wrapper">
<?php if ( !empty($vivacity_lite_prepost) ) { ?>
  <p class="nav-previous"><a href="<?php echo esc_url(get_permalink($vivacity_lite_prepost->ID)); ?>" title="<?php echo esc_attr($vivacity_lite_prepost->post_title); ?>"><?php echo '&larr; '; _e( ' Previous', 'vivacity-lite' ); ?></a></p>
<?php } if ( !empty($vivacity_lite_nextpost) ) { ?>
	<p class="nav-next"><a href="<?php echo esc_url(get_permalink($vivacity_lite_nextpost->ID)); ?>" title="<?php echo esc_attr($vivacity_lite_nextpost->post_title); ?>"><?php _e( 'Next ', 'vivacity-lite' );echo '&rarr; ';  ?></a></p>
<?php } ?>
   </div> 
</div>
<?php } 



function vivacity_lite_customize_register( $wp_customize ) {
   //All our sections, settings, and controls will be added here
   //Theme Options
  $wp_customize->add_panel( 'vivacitylite_theme_options', array(
	    'description'    => __( 'Basic theme Options', 'vivacity-lite' ),
	    'capability'     => 'edit_theme_options',
	    'priority'       => 200,
	    'title'    		 => __( 'Theme Options', 'vivacity-lite' ),
	) );
		// Header Option
		$wp_customize->add_section( 'vivacitylite_slider', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Slider', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'slider1', array(
	
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'slider1', array(
'description'	=> __( 'Add the image for slide 1', 'vivacity-lite'),
        'label'   => __( 'Slider 1', 'vivacity-lite' ),
        'priority'	=> 1,
        'section' => 'vivacitylite_slider',
        'settings'   => 'slider1',
    ) ) );  
	
	$wp_customize->add_setting( 'slider2', array(
	
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'slider2', array(
'description'	=> __( 'Add the image for slide 2', 'vivacity-lite'),
        'label'   => __( 'Slider 2', 'vivacity-lite' ),
        'priority'	=> 1,
        'section' => 'vivacitylite_slider',
        'settings'   => 'slider2',
    ) ) );  
$wp_customize->add_setting( 'slider3', array(
	
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'slider3', array(
'description'	=> __( 'Add the image for slide 3', 'vivacity-lite'),
        'label'   => __( 'Slider 3', 'vivacity-lite' ),
        'priority'	=> 1,
        'section' => 'vivacitylite_slider',
        'settings'   => 'slider3',
    ) ) );  
		$wp_customize->add_section( 'vivacitylite_header', array(
	
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Header', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'checkbox_social_header', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Header Options', array(
	'description'	=> __( 'check the checkbox to display the social icons bar.', 'vivacity-lite'),
			'label'		=> __( 'Social Icons bar', 'vivacity-lite' ),
			'default'     => '1',
	        'priority'	=> 1,
			'section'   => 'vivacitylite_header',
	        'settings'  => 'checkbox_social_header',
			'type'		=> 'checkbox',
	) ) ;
	$wp_customize->add_setting( 'image_logo', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'image_logo', array(
'description'	=> __( 'Please choose an image file for your logo.', 'vivacity-lite'),
        'label'   => __( 'Image Logo', 'vivacity-lite' ),
        'priority'	=> 1,
        'section' => 'vivacitylite_header',
        'settings'   => 'image_logo',
    ) ) ); 
	
	$wp_customize->add_setting( 'alt_logo', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Logo Alt Text', array(
	'description'	=> __( 'Please write alternate text for your logo.', 'vivacity-lite'),
			'label'		=> __( 'Logo Alt Text', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_header',
	        'settings'  => 'alt_logo',
			'type'		=> 'text',
	) ) ;
	$wp_customize->add_setting( 'text_logo', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Text Logo', array(
	'description'	=> __( 'Please write text for your logo.', 'vivacity-lite'),
			'label'		=> __( 'Text Logo', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => 'Vivacity Lite',
			'section'   => 'vivacitylite_header',
	        'settings'  => 'text_logo',
			'type'		=> 'text',
	) ) ;
$wp_customize->add_section( 'vivacitylite_blog', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Blog Page Layout', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'radio_blog', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Blog Page Layout', array(
	'description'	=> __( 'please select layout of blog page', 'vivacity-lite'),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_blog',
	        'settings'  => 'radio_blog',
			'type'		=> 'radio',
			'default'     => 'one',
			 'choices'     => array(
        'one' => __( 'One Column', 'vivacity-lite' ),
        'two' => __( 'Two Column', 'vivacity-lite' ),
        
    ),
	) ) ;
	$wp_customize->add_section( 'vivacitylite_footer', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Footer', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'checkbox_copyright', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Copyright Bar', array(
	'description'	=> __( 'check the checkbox to display the Copyright bar.', 'vivacity-lite'),
			'label'		=> __( 'Copyright Bar ', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => '1',
			'section'   => 'vivacitylite_footer',
	        'settings'  => 'checkbox_copyright',
			'type'		=> 'checkbox',
			 
	) ) ;
	$wp_customize->add_setting( 'textarea_copyright', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_textarea'
	) );

	$wp_customize->add_control( 'Copyright Text', array(
	'description'	=> __( 'Please enter text for your copyright section.', 'vivacity-lite'),
			'label'		=> __( 'Copyright Text', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => __( 'Powered by wordpress.org. Develop by team vivacity infotech pvt. ltd.', 'vivacity-lite' ),
			'section'   => 'vivacitylite_footer',
	        'settings'  => 'textarea_copyright',
			'type'		=> 'textarea',
			 
	) ) ;
	$wp_customize->add_setting( 'checkbox_social', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Social Icons Bar', array(
	'description'	=> __( 'check the checkbox to display the Social Icons bar.', 'vivacity-lite'),
			'label'		=> __( 'Social Icons Bar', 'vivacity-lite' ),
	        'priority'	=> 1,
'default'     => '1',
			'section'   => 'vivacitylite_footer',
	        'settings'  => 'checkbox_social',
			'type'		=> 'checkbox',
			 
	) ) ;
	$wp_customize->add_section( 'vivacitylite_home', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Home Page Layout', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'select_home', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Home page Layout', array(
	'description'	=> __( 'Select any one option for home page layout', 'vivacity-lite'),
			
	        'priority'	=> 1,
			'section'   => 'vivacitylite_home',
	        'settings'  => 'select_home',
            'default'     => 'option-1',
			'type'		=> 'select',
			 'choices'     => array(
        'option-1' => __( 'Left Sidebar', 'vivacity-lite' ),
        'option-2' => __( 'Right Sidebar', 'vivacity-lite' ),
        'option-3' => __( 'Full Width Layout', 'vivacity-lite' ),
        'option-4' => __( 'Two Column Layout', 'vivacity-lite' ),
'option-5' => __( 'Three Column Layout', 'vivacity-lite' ),
    ),
			 
	) ) ;
	$wp_customize->add_section( 'vivacitylite_background', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Background Options', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'color_site', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Color of site', array(
	
			'label'		=> __( 'Color Pattern Of Site ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_background',
			'default'     => '#1e73be',
	        'settings'  => 'color_site',
			'type'		=> 'color',
			 
	) ) ;
	$wp_customize->add_setting( 'text_posts', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Heading Of Posts', array(
	'description'	=> __( 'Add Title For All Posts.', 'vivacity-lite'),
			'label'		=> __( 'Heading Of Posts ', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => __( 'Latest Posts', 'vivacity-lite' ),
			'section'   => 'vivacitylite_background',
	        'settings'  => 'text_posts',
			'type'		=> 'text',
			 
	) ) ;
	$wp_customize->add_setting( 'select_size', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Font Size Of Posts Text', array(
	'description'	=> __( 'Select any one size for posts content', 'vivacity-lite'),
			'label'		=> __( ' Font Size Of Posts Text ', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => '13px',
			'section'   => 'vivacitylite_background',
	        'settings'  => 'select_size',
			'type'		=> 'select',
			'choices'     => array(
        '10px' => '10px',
        '11px' => '11px',
        '12px' => '12px',
        '13px' => '13px',
        '14px' => '14px',
        '15px' => '15px',
        '16px' => '16px',
        '17px' => '17px',
        '18px' => '18px',
        '19px' => '19px',
        '20px' => '20px',
    ),
			 
	) ) ;
	$wp_customize->add_section( 'vivacitylite_social', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Social Icons', 'vivacity-lite' ),
	) );

	$wp_customize->add_setting( 'select_social_size', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'vivacity_lite_sanitize_content'
	) );

	$wp_customize->add_control( 'Social Icons', array(
	
			'label'		=> __( 'Social Icons ', 'vivacity-lite' ),
	        'priority'	=> 1,
	        'default'     => '2em',
			'section'   => 'vivacitylite_social',
	        'settings'  => 'select_social_size',
			'type'		=> 'select',
			'choices'     => array(
        '1em' => '1em',
        '2em' => '2em',
        '3em' => '3em',
        
    ),
			 
	) ) ;
	$wp_customize->add_setting( 'text_facebook', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Facebook', array(
	
			'label'		=> __( 'Facebook ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			'default'     => __( 'http://facebook.com', 'vivacity-lite' ),
	        'settings'  => 'text_facebook',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_twitter', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Twitter', array(
	
			'label'		=> __( 'Twitter ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
'default'     => __( 'https://twitter.com/login?lang=en', 'vivacity-lite' ),
	        'settings'  => 'text_twitter',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_linkedin', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Linkedin', array(
	
			'label'		=> __( 'Linkedin ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			'default'     => __( 'https://www.linkedin.com/uas/login', 'vivacity-lite' ),
	        'settings'  => 'text_linkedin',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_youtube', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Youtube', array(
	
			'label'		=> __( 'Youtube ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			'default'     => __( 'https://www.youtube.com/playlist?list=PLE134D877783367C7', 'vivacity-lite' ),
	        'settings'  => 'text_youtube',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_pinterest', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Pinterest', array(

			'label'		=> __( 'Pinterest ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			'default'     => __( 'https://www.pinterest.com/login/', 'vivacity-lite' ),
	        'settings'  => 'text_pinterest',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_skype', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Skype', array(
	
			'label'		=> __( 'Skype ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			'default'     => __( 'https://login.skype.com/login', 'vivacity-lite' ),
	        'settings'  => 'text_skype',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_tumblr', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Tumblr', array(
	
			'label'		=> __( 'Tumblr ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			 'default'     => __( 'https://www.tumblr.com/login', 'vivacity-lite' ),
	        'settings'  => 'text_tumblr',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_flickr', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Flickr', array(
	
			'label'		=> __( 'Flickr ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
 'default'     => __( 'https://www.flickr.com/', 'vivacity-lite' ),
	        'settings'  => 'text_flickr',
			'type'		=> 'text',
			
			 
	) ) ;
	$wp_customize->add_setting( 'text_instagram', array(
		'capability'		=> 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw'
	) );

	$wp_customize->add_control( 'Instagram', array(
	
			'label'		=> __( 'Instagram ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_social',
			 'default'     => __( 'https://instagram.com/accounts/login/', 'vivacity-lite' ),
	        'settings'  => 'text_instagram',
			'type'		=> 'text',
			
			 
	) ) ;

	$wp_customize->add_section( 'vivacitylite_css', array(
		
		'panel'  		=> 'vivacitylite_theme_options',
		'priority' 		=> 1,
		'title'    		=> __( 'Custom Css', 'vivacity-lite' ),

	) );

	$wp_customize->add_setting( 'textarea_css', array(
		'capability'		=> 'edit_theme_options',
	'sanitize_callback' => 'wp_filter_nohtml_kses'
	) );

	$wp_customize->add_control( 'Custom Css', array(
	'description'	=> __( 'Please enter custom classes.', 'vivacity-lite'),
			'label'		=> __( 'Custom Css ', 'vivacity-lite' ),
	        'priority'	=> 1,
			'section'   => 'vivacitylite_css',
	        'settings'  => 'textarea_css',
			'type'		=> 'textarea',
			
			 
	) ) ;

}
add_action( 'customize_register', 'vivacity_lite_customize_register' );


	function vivacity_lite_sanitize_content( $input ) {
    return strip_tags( stripslashes( $input ) );
}
 




?>
