<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * 
 */
if ( ! function_exists( 'vivacity_lite_logo_color' ) ) :
	

	function vivacity_lite_logo_color() {
		
		if( $vivacity_lite_logo = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .site-title a { color:' . $vivacity_lite_logo;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_logo_color', 101 );
if ( ! function_exists( 'vivacity_lite_fa_size' ) ) :
	
function vivacity_lite_fa_size() {
		if( $vivacity_lite_fa_size = esc_attr(get_theme_mod( 'select_social_size' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .fa-2x  { font-size:' . $vivacity_lite_fa_size;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_fa_size', 101 );




 

if ( ! function_exists( 'vivacity_lite_sidebar_widget' ) ) :
	
function vivacity_lite_sidebar_widget() {
		if( $vivacity_lite_sidebar_widget = esc_attr(get_theme_mod( 'color_site' ))) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .sidebar-widget a  { color:' . $vivacity_lite_sidebar_widget;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_sidebar_widget', 101 );
if ( ! function_exists( 'vivacity_lite_footer' ) ) :
	
function vivacity_lite_footer() {
		if( $vivacity_lite_footer = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> #footer a  { color:' . $vivacity_lite_footer;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_footer', 101 );
if ( ! function_exists( 'vivacity_lite_entry' ) ) :
	
function vivacity_lite_entry() {
		if( $vivacity_lite_entry = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .entry-headline-text  { color:' . $vivacity_lite_entry;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_entry', 101 );
if ( ! function_exists( 'vivacity_lite_menu' ) ) :
	
function vivacity_lite_menu() {
		if( $vivacity_lite_menu = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .menu-box  { border-bottom: 2px solid' . $vivacity_lite_menu;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_menu', 101 );
if ( ! function_exists( 'vivacity_lite_menul' ) ) :
	
function vivacity_lite_menul() {
		if( $vivacity_lite_menul = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .menu-box ul ul  { border-top: 2px solid' . $vivacity_lite_menul;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_menul', 101 );
if ( ! function_exists( 'vivacity_lite_home' ) ) :
	
function vivacity_lite_home() {
		if( $vivacity_lite_home = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .home #header .menu-box .link-home { background-color:' . $vivacity_lite_home;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_home', 101 );
if ( ! function_exists( 'vivacity_lite_navigation' ) ) :
	
function vivacity_lite_navigation() {
		if( $vivacity_lite_navigation = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .top-navigation ul ul  { border-top: 1px solid' . $vivacity_lite_navigation;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_navigation', 101 );
if ( ! function_exists( 'vivacity_lite_post_entry' ) ) :
	
function vivacity_lite_post_entry() {
		if( $vivacity_lite_post_entry = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-entry .post-entry-headline a  { color:' . $vivacity_lite_post_entry;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_entry', 101 );
if ( ! function_exists( 'vivacity_lite_post_entry_hover' ) ) :
	
function vivacity_lite_post_entry_hover() {
		if( $vivacity_lite_post_entry_hover = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-entry .read-more-button:hover  { background-color:' . $vivacity_lite_post_entry_hover;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_entry_hover', 101 );

if ( ! function_exists( 'vivacity_lite_submit' ) ) :
	
function vivacity_lite_submit() {
		if( $vivacity_lite_submit = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> input[type="submit"], input[type="reset"]  { background:' . $vivacity_lite_submit;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_submit', 101 );
if ( ! function_exists( 'vivacity_lite_submit_hover' ) ) :
	
function vivacity_lite_submit_hover() {
		if( $vivacity_lite_submit_hover = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> input[type="submit"]:hover, input[type="reset"]:hover  { background-color:' . $vivacity_lite_submit_hover;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_submit_hover', 101 );
if ( ! function_exists( 'vivacity_lite_search' ) ) :
	
function vivacity_lite_search() {
		if( $vivacity_lite_search = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> #searchform .searchform-wrapper .send  { background-color:' . $vivacity_lite_search;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_search', 101 );
if ( ! function_exists( 'vivacity_lite_search_hover' ) ) :
	
function vivacity_lite_search_hover() {
		if( $vivacity_lite_search_hover = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> #searchform .send:hover  { background-color:' . $vivacity_lite_search_hover;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_search_hover', 101 );
if ( ! function_exists( 'vivacity_lite_read' ) ) :
	
function vivacity_lite_read() {
		if( $vivacity_lite_read = esc_attr(get_theme_mod( 'color_site' )) ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .read-more-button  { background-color:' . $vivacity_lite_read;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_read', 101 );
if ( ! function_exists( 'vivacity_lite_post_heading' ) ) :
	
function vivacity_lite_post_heading() {
		if( $vivacity_lite_post_heading = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-entry-headline a  { color:' . $vivacity_lite_post_heading;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_heading', 101 );
if ( ! function_exists( 'vivacity_lite_post_content' ) ) :
	
function vivacity_lite_post_content() {
		if( $vivacity_lite_post_content = esc_attr(get_theme_mod( 'select_size' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-entry-content  { font-size:' . $vivacity_lite_post_content;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_content', 101 );
if ( ! function_exists( 'vivacity_lite_post_p' ) ) :
	
function vivacity_lite_post_p() {
		if( $vivacity_lite_post_p = esc_attr(get_theme_mod( 'select_size' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-entry-content p  { font-size:' . $vivacity_lite_post_p;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_p', 101 );
if ( ! function_exists( 'vivacity_lite_header' ) ) :
	
function vivacity_lite_header() {
		if( $vivacity_lite_header = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> #header .menu-box .current-menu-item > a,#header .menu-box .current-menu-ancestor > a,#header .menu-box .current_page_item > a,#header .menu-box .current-page-ancestor > a,.home #header .menu-box .link-home  { background-color:' . $vivacity_lite_header;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_header', 101 );

if ( ! function_exists( 'vivacity_lite_post_edit' ) ) :
	
function vivacity_lite_post_edit() {
		if( $vivacity_lite_post_edit = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .post-edit-link  { color:' . $vivacity_lite_post_edit;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_post_edit', 101 );
if ( ! function_exists( 'vivacity_lite_logged' ) ) :
	
function vivacity_lite_logged() {
		if( $vivacity_lite_logged = esc_attr(get_theme_mod( 'color_site' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<style type="text/css" media="screen"> .logged-in-as a  { color:' . $vivacity_lite_logged;
			
				echo '}</style>';			
			}
			
	}
endif;
add_action( 'wp_head', 'vivacity_lite_logged', 101 );
if ( ! function_exists( 'vivacity_lite_custom_css' ) ) :
	
	function vivacity_lite_custom_css() {
		if( $vivacity_lite_custom_css = esc_attr(get_theme_mod( 'textarea_css' ))  ) {
				echo '<!-- refreshing cache -->' . "\n";
				
				echo '<!-- '.get_bloginfo('name').' inline CSS Styles -->' . "\n" . '<style type="text/css" media="screen">' . "\n" . $vivacity_lite_custom_css;
			
				echo '</style>' . "\n";			
			}
			
	}
endif; 
add_action( 'wp_head', 'vivacity_lite_custom_css', 101 );