<?php
/**
 * team section
 *
 */
if ( ! function_exists( 'vital_corporate_add_team_section' ) ) :

    function vital_corporate_add_team_section() {
        $team_enable = get_theme_mod('vital_corporate_team_section_enable', false );
        if ( true !== $team_enable ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'vital_corporate_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        vital_corporate_render_team_section( $section_details );
    }
endif;

if ( ! function_exists( 'vital_corporate_get_team_section_details' ) ) :

    function vital_corporate_get_team_section_details( $input ) {

        $team_count = 3;
        
        $content = array();
     
        $page_ids = array();

        for ( $i = 1; $i <= $team_count; $i++ ) {
            if ( ! empty( get_theme_mod( 'vital_corporate_team_content_page_' . $i ) ) )
                $page_ids[] = get_theme_mod( 'vital_corporate_team_content_page_' . $i );
        }
    
        $args = array(
            'post_type'         => 'page',
            'post__in'          => ( array ) $page_ids,
            'posts_per_page'    => absint( $team_count ),
            'orderby'           => 'post__in',
            );                    
   

        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = dark_music_trim_content( 50 );
                $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';


                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        return $content;

    }
endif;

add_filter( 'vital_corporate_filter_team_section_details', 'vital_corporate_get_team_section_details' );


if ( ! function_exists( 'vital_corporate_render_team_section' ) ) :

   function vital_corporate_render_team_section( $content_details = array() ) {
        $i = 1;        

        $team_title = get_theme_mod( 'vital_corporate_team_title', __( 'Our teams', 'vital-corporate' ) );
        $team_subtitle = get_theme_mod( 'vital_corporate_team_subtitle', __( 'teams', 'vital-corporate' ) );
        $team_btn_title = get_theme_mod( 'vital_corporate_team_btn_title', __( 'Read More', 'vital-corporate' ) );

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="vital_corporate_team_section">
            <div id="team-section" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                    dark_music_section_tooltip( 'team-section' );
                    endif; ?>
                    <div class="section-header">
                        <?php if ( ! empty( $team_subtitle ) ) : ?>
                            <p class="section-subtitle"><?php echo esc_html( $team_subtitle ); ?></p>
                        <?php endif; ?>
                        <?php if ( ! empty( $team_title ) ) : ?>
                            <h2 class="section-title"><?php echo esc_html( $team_title ); ?></h2>
                        <?php endif; ?>  
                    </div>

                    <div class="section-content col-3 clear">
                        <?php  $i = 1;  foreach ( $content_details as $content ) : ?>
                            <article>
                                <div class="team-item-wrapper">
                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                            <img src="<?php echo esc_url( $content['image'] ) ; ?>" alt="team">
                                        </a>
                                    </div>

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <?php if ( !empty( get_theme_mod( 'vital_corporate_team_position_'.$i ) ) ): ?>
                                                <span class="team-position"><?php echo esc_html( get_theme_mod( 'vital_corporate_team_position_'.$i ) ) ; ?></span>
                                            <?php endif ?>
                                           
                                            <h2 class="entry-title">
                                                <a href="<?php echo esc_url( $content['url'] ) ; ?>"><?php echo esc_html( $content['title'] ) ; ?>
                                                </a>
                                            </h2>
                                        </header>

                                        <div class="social-icons">
                                            <ul>
                                                <?php 
                                                $team_socials = ! empty( get_theme_mod( 'vital_corporate_team_social_'.$i ) ) ? explode( '|', get_theme_mod( 'vital_corporate_team_social_'.$i ) ) : array(); 

                                                foreach ( $team_socials as $team_social ) : ?>
                                                    <li>
                                                        <a href="<?php echo esc_url( $team_social ); ?>"><?php echo dark_music_return_social_icon( $team_social ); ?></a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </article>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
       
    <?php }
endif;
