<?php
/**
 * Service section
 *
 */
if ( ! function_exists( 'vital_corporate_add_service_section' ) ) :

    function vital_corporate_add_service_section() {
        $service_enable = get_theme_mod('vital_corporate_service_section_enable', false );
        if ( true !== $service_enable ) {
            return false;
        }

        $section_details = array();
        $section_details = apply_filters( 'vital_corporate_filter_service_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        vital_corporate_render_service_section( $section_details );
    }
endif;

if ( ! function_exists( 'vital_corporate_get_service_section_details' ) ) :

    function vital_corporate_get_service_section_details( $input ) {

        $service_count = 3;
        
        $content = array();
     
        $page_ids = array();

        for ( $i = 1; $i <= $service_count; $i++ ) {
            if ( ! empty( get_theme_mod( 'vital_corporate_service_content_page_' . $i ) ) )
                $page_ids[] = get_theme_mod( 'vital_corporate_service_content_page_' . $i );
        }
    
        $args = array(
            'post_type'         => 'page',
            'post__in'          => ( array ) $page_ids,
            'posts_per_page'    => absint( $service_count ),
            'orderby'           => 'post__in',
            );                    

        $query = new WP_Query( $args );
        if ( $query->have_posts() ) : 
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = dark_music_trim_content( 20 );

                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        return $content;

    }
endif;

add_filter( 'vital_corporate_filter_service_section_details', 'vital_corporate_get_service_section_details' );


if ( ! function_exists( 'vital_corporate_render_service_section' ) ) :

   function vital_corporate_render_service_section( $content_details = array() ) {
              

        $service_title = get_theme_mod( 'vital_corporate_service_title', __( 'Our Services', 'vital-corporate' ) );
        $service_subtitle = get_theme_mod( 'vital_corporate_service_subtitle', __( 'Services', 'vital-corporate' ) );
        $service_btn_title = get_theme_mod( 'vital_corporate_service_btn_title', __( 'Read More', 'vital-corporate' ) );

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="vital_corporate_service_section">
            <div id="service-section" class="relative page-section same-background">
                <div class="wrapper">
                    <?php if ( is_customize_preview()):
                    dark_music_section_tooltip( 'service-section' );
                    endif; ?>
                    <div class="section-header">
                        <?php if ( ! empty( $service_subtitle ) ) : ?>
                            <p class="section-subtitle"><?php echo esc_html( $service_subtitle ); ?></p>
                        <?php endif; ?>
                        <?php if ( ! empty( $service_title ) ) : ?>
                            <h2 class="section-title"><?php echo esc_html( $service_title ); ?></h2>
                        <?php endif; ?>  
                    </div>

                    <div class="section-content col-3 clear">
                        <?php $i = 1; foreach ( $content_details as $content ) : ?>
                            <article>
                                <div class="service-item">
                                    <div class="entry-container">
                                        <div class="icon-container">
                                            <a href="<?php echo esc_url( $content['url'] ); ?>">
                                                <i class="fa <?php echo ! empty( get_theme_mod( 'vital_corporate_service_content_icon_'.$i ) ) ? esc_attr( get_theme_mod( 'vital_corporate_service_content_icon_'.$i ) ) : 'fa-cogs'; ?>"></i>
                                            </a>
                                        </div>

                                        <header class="entry-header">
                                            <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                        </header>

                                        <div class="entry-content">
                                            <p><?php echo esc_html( $content['excerpt'] ); ?></p>
                                        </div>
                                        <?php if ( !empty( $service_btn_title ) ): ?>
                                            <div class="read-more">
                                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn"><?php echo esc_html( $service_btn_title ); ?></a>
                                            </div>
                                        <?php endif ?>                                    
                                    </div>
                                </div>
                            </article>
                        <?php $i++; endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
       
    <?php }
endif;
