<?php

function vital_corporate_customize_register( $wp_customize ) {

	class Vital_Corporate_Icon_Picker extends WP_Customize_Control{
		
		public $type = 'icon-picker';

		public function render_content(){
			$id = uniqid();
			?>
	            <label>
	                <span class="customize-control-title">
	                	<?php echo esc_html( $this->label ); ?>
	                </span>

	                <?php if($this->description){ ?>
		            <span class="description customize-control-description">
		            	<?php echo wp_kses_post($this->description); ?>
		            </span>
		            <?php } ?>

	                <input id="vital-corporate-<?php echo esc_attr( $id ); ?>" placeholder="<?php esc_attr_e( 'Click here to select icon', 'vital-corporate' ); ?>" class="vital-corporate-icon-picker input" <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>" />
	            </label>
			<?php
		}
	}

	class Vital_Corporate_Switch_Control extends WP_Customize_Control{

		public $type = 'switch';

		public $on_off_label = array();

		public function __construct( $manager, $id, $args = array() ){
	        $this->on_off_label = $args['on_off_label'];
	        parent::__construct( $manager, $id, $args );
	    }

		public function render_content(){
	    ?>
		    <span class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</span>

			<?php if( $this->description ){ ?>
				<span class="description customize-control-description">
				<?php echo wp_kses_post( $this->description ); ?>
				</span>
			<?php } ?>

			<?php
				$switch_class = ( $this->value() == 'true' ) ? 'switch-on' : '';
				$on_off_label = $this->on_off_label;
			?>
			<div class="onoffswitch <?php echo esc_attr( $switch_class ); ?>">
				<div class="onoffswitch-inner">
					<div class="onoffswitch-active">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['on'] ) ?></div>
					</div>

					<div class="onoffswitch-inactive">
						<div class="onoffswitch-switch"><?php echo esc_html( $on_off_label['off'] ) ?></div>
					</div>
				</div>	
			</div>
			<input <?php $this->link(); ?> type="hidden" value="<?php echo esc_attr( $this->value() ); ?>"/>
			<?php
	    }
	}

	class Vital_Corporate_Dropdown_Chooser extends WP_Customize_Control{

		public $type = 'dropdown_chooser';

		public function render_content(){
			if ( empty( $this->choices ) )
	                return;
			?>
	            <label>
	                <span class="customize-control-title">
	                	<?php echo esc_html( $this->label ); ?>
	                </span>

	                <?php if($this->description){ ?>
		            <span class="description customize-control-description">
		            	<?php echo wp_kses_post($this->description); ?>
		            </span>
		            <?php } ?>

	                <select class="vital-corporate-chosen-select" <?php $this->link(); ?>>
	                    <?php
	                    foreach ( $this->choices as $value => $label )
	                        echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . esc_html( $label ) . '</option>';
	                    ?>
	                </select>
	            </label>
			<?php
		}
	}

	class Vital_Corporate_Customize_Horizontal_Line extends WP_Customize_Control {
		public $type = 'hr';

		public function render_content() {
			?>
			<div>
				<hr style="border: 1px dotted #72777c;" />
			</div>
			<?php
		}
	}

	class Vital_Corporate_Multi_Input_Custom_Control extends WP_Customize_Control {
	
		public $type = 'multi-input';

	
		public $button_text;

	
		public function render_content() {
			?>
			<label class="customize_multi_input">
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<p><?php echo esc_html( $this->description ); ?></p>
				<input type="hidden" id="<?php echo esc_attr( $this->id ); ?>" name="<?php echo esc_attr( $this->id ); ?>" value="<?php echo esc_attr( $this->value() ); ?>" class="customize_multi_value_field" <?php $this->link(); ?> />
				<div class="customize_multi_fields">
					<div class="set">
						<input type="text" value="" class="customize_multi_single_field"/>
						<span class="customize_multi_remove_field"><span class="dashicons dashicons-no-alt"></span></span>
					</div>
				</div>
				<a href="#" class="button button-primary customize_multi_add_field"><?php echo esc_html( $this->button_text ); ?></a>
			</label>
			<?php
		}
	}


	// Service Section

	$wp_customize->add_section( 'vital_corporate_service_section', array(
		'title'             => esc_html__( 'Services','vital-corporate' ),
		'description'       => esc_html__( 'Services Section options.', 'vital-corporate' ),
		'panel'             => 'dark_music_front_page_panel',
	) );

	$wp_customize->add_setting( 'vital_corporate_service_section_enable', array(
		'default'			=> 	false,
		'sanitize_callback' => 'dark_music_sanitize_switch_control',
	) );

	$wp_customize->add_control( new Vital_Corporate_Switch_Control( $wp_customize, 'vital_corporate_service_section_enable', array(
		'label'             => esc_html__( 'Service Section Enable', 'vital-corporate' ),
		'section'           => 'vital_corporate_service_section',
		'on_off_label' 		=> dark_music_switch_options(),
	) ) );				

	if ( isset( $wp_customize->selective_refresh ) ) {
	    $wp_customize->selective_refresh->add_partial( 'vital_corporate_service_section_enable', array(
			'selector'            => '#service-section .tooltiptext',
			'settings'            => 'vital_corporate_service_section_enable',
	    ) );
	}


	$wp_customize->add_setting( 'vital_corporate_service_title', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> '',
	) );

	$wp_customize->add_control( 'vital_corporate_service_title', array(
		'label'           	=> esc_html__( 'Title', 'vital-corporate' ),
		'section'        	=> 'vital_corporate_service_section',
		'active_callback' 	=> 'vital_corporate_is_service_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'vital_corporate_service_subtitle', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> '',
	) );

	$wp_customize->add_control( 'vital_corporate_service_subtitle', array(
		'label'           	=> esc_html__( 'Sub Title', 'vital-corporate' ),
		'section'        	=> 'vital_corporate_service_section',
		'active_callback' 	=> 'vital_corporate_is_service_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'vital_corporate_service_btn_title', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> '',
	) );

	$wp_customize->add_control( 'vital_corporate_service_btn_title', array(
		'label'           	=> esc_html__( 'Btn Title', 'vital-corporate' ),
		'section'        	=> 'vital_corporate_service_section',
		'active_callback' 	=> 'vital_corporate_is_service_section_enable',
		'type'				=> 'text',
	) );


	for ( $i = 1; $i <= 3; $i++ ) :

		$wp_customize->add_setting( 'vital_corporate_service_content_icon_' . $i, array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( new Vital_Corporate_Icon_Picker( $wp_customize, 'vital_corporate_service_content_icon_' . $i, array(
			'label'             => sprintf( esc_html__( 'Select Icon %d', 'vital-corporate' ), $i ),
			'section'           => 'vital_corporate_service_section',
			'active_callback'	=> 'vital_corporate_is_service_section_enable',
		) ) );

		$wp_customize->add_setting( 'vital_corporate_service_content_page_' . $i, array(
			'sanitize_callback' => 'dark_music_sanitize_page',
		) );

		$wp_customize->add_control( new Vital_Corporate_Dropdown_Chooser( $wp_customize, 'vital_corporate_service_content_page_' . $i, array(
			'label'             => sprintf( esc_html__( 'Select Page %d', 'vital-corporate' ), $i ),
			'section'           => 'vital_corporate_service_section',
			'choices'			=> dark_music_page_choices(),
			'active_callback'	=> 'vital_corporate_is_service_section_enable',
		) ) );

	endfor;


	// Team Section 


	$wp_customize->add_section( 'vital_corporate_team_section', array(
		'title'             =>	esc_html__( 'Team', 'vital-corporate' ),
		'description'       => esc_html__( 'Team Section options.', 'vital-corporate' ),
		'panel'             => 'dark_music_front_page_panel',
	) );

	$wp_customize->add_setting( 'vital_corporate_team_section_enable', array(
		'default'			=> 	false,
		'sanitize_callback' => 'dark_music_sanitize_switch_control',
	) );

	$wp_customize->add_control( new Vital_Corporate_Switch_Control( $wp_customize, 'vital_corporate_team_section_enable', array(
		'label'             => esc_html__( 'Team Section Enable', 'vital-corporate' ),
		'section'           => 'vital_corporate_team_section',
		'on_off_label' 		=> dark_music_switch_options(),
	) ) );

	if ( isset( $wp_customize->selective_refresh ) ) {
	    $wp_customize->selective_refresh->add_partial( 'vital_corporate_team_section_enable', array(
			'selector'            => '#team-section .tooltiptext',
			'settings'            => 'vital_corporate_team_section_enable',
	    ) );
	}


	$wp_customize->add_setting( 'vital_corporate_team_title', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> '',
	) );

	$wp_customize->add_control( 'vital_corporate_team_title', array(
		'label'           	=> esc_html__( 'Title', 'vital-corporate' ),
		'section'        	=> 'vital_corporate_team_section',
		'active_callback' 	=> 'vital_corporate_is_team_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'vital_corporate_team_sub_title', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'			=> '',
	) );

	$wp_customize->add_control( 'vital_corporate_team_sub_title', array(
		'label'           	=> esc_html__( 'Sub Title', 'vital-corporate' ),
		'section'        	=> 'vital_corporate_team_section',
		'active_callback' 	=> 'vital_corporate_is_team_section_enable',
		'type'				=> 'text',
	) );

	

	for ( $i = 1; $i <= 3; $i++ ) :

		$wp_customize->add_setting( 'vital_corporate_team_content_page_' . $i, array(
			'sanitize_callback' => 'dark_music_sanitize_page',
		) );

		$wp_customize->add_control( new Vital_Corporate_Dropdown_Chooser( $wp_customize, 'vital_corporate_team_content_page_' . $i, array(
			'label'             => sprintf( esc_html__( 'Select Page %d', 'vital-corporate' ), $i ),
			'section'           => 'vital_corporate_team_section',
			'choices'			=> dark_music_page_choices(),
			'active_callback'	=> 'vital_corporate_is_team_section_enable',
		) ) );

		$wp_customize->add_setting( 'vital_corporate_team_position_' . $i, array(
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'vital_corporate_team_position_' . $i, array(
			'label'           	=> sprintf( esc_html__( 'Post Text %d', 'vital-corporate' ), $i ),
			'section'        	=> 'vital_corporate_team_section',
			'active_callback' 	=> 'vital_corporate_is_team_section_enable',
			'type'				=> 'text',
		) );


			
		$wp_customize->add_setting( 'vital_corporate_team_social_' . $i, array(
			'sanitize_callback' => 'esc_url_raw',
		) );

		$wp_customize->add_control( new Vital_Corporate_Multi_Input_Custom_Control( $wp_customize, 'vital_corporate_team_social_' . $i, array(
			'label'             => esc_html__( 'Social Link', 'vital-corporate' ),
			'button_text'       => esc_html__( 'Add social', 'vital-corporate' ),
			'section'           => 'vital_corporate_team_section',
			'active_callback' 	=> 'vital_corporate_is_team_section_enable',
		) ) );



	    $wp_customize->add_setting( 'vital_corporate_team_hr_'. $i, array(
	        'sanitize_callback' => 'sanitize_text_field'
	    ) );

	    $wp_customize->add_control( new Vital_Corporate_Customize_Horizontal_Line( $wp_customize, 'vital_corporate_team_hr_'. $i,
	        array(
	            'section'           => 'vital_corporate_team_section',
	            'active_callback'   => 'vital_corporate_is_team_section_enable',
	            'type'            => 'hr'
	    ) ) );
	endfor;

}
add_action( 'customize_register', 'vital_corporate_customize_register' );


function vital_corporate_is_service_section_enable( $control ) {
	return ( $control->manager->get_setting( 'vital_corporate_service_section_enable' )->value() );
}


function vital_corporate_is_team_section_enable( $control ) {
	return ( $control->manager->get_setting( 'vital_corporate_team_section_enable' )->value() );
}

function vital_corporate_customize_preview_js() {
	wp_enqueue_script( 'vital-corporate-customizer', get_theme_file_uri() . '/assets/js/child-customize.min.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'vital_corporate_customize_preview_js' );


function vital_corporate_customize_control_js() {
	
	wp_enqueue_style( 'simple-iconpicker-css', get_theme_file_uri() . '/assets/css/simple-iconpicker.min.css' );

	wp_enqueue_style( 'font-awesome-css', get_template_directory_uri() . '/assets/css/font-awesome.min.css' );

	wp_enqueue_script( 'jquery-simple-iconpicker', get_theme_file_uri() . '/assets/js/simple-iconpicker.min.js', array( 'jquery' ), '', true );

	wp_enqueue_script( 'onjob-pro-customize-controls', get_theme_file_uri() . '/assets/js/child-customizer-control.min.js', array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'vital_corporate_customize_control_js' );