<?php

if ( ! function_exists( 'vital_corporate_enqueue_styles' ) ) :

	function vital_corporate_enqueue_styles() {
		wp_enqueue_style( 'vital-corporate-style-parent', get_template_directory_uri() . '/style.css' );

		wp_enqueue_style( 'vital-corporate-style', get_stylesheet_directory_uri() . '/style.css', array( 'vital-corporate-style-parent' ), '1.0.0' );

		wp_enqueue_style( 'vital-corporate-fonts', vital_corporate_fonts_url(), array(), null );
	}
endif;
add_action( 'wp_enqueue_scripts', 'vital_corporate_enqueue_styles', 99 );


function vital_corporate_block_editor_styles() {

	wp_enqueue_style( 'vital-corporate-fonts', vital_corporate_fonts_url(), array(), null );

}

add_action( 'enqueue_block_editor_assets', 'vital_corporate_block_editor_styles' );

if ( ! function_exists( 'vital_corporate_fonts_url' ) ) :

function vital_corporate_fonts_url() {
	
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';


	if ( 'off' !== _x( 'on', 'Raleway font: on or off', 'vital-corporate' ) ) {
		$fonts[] = 'Raleway:400,500,600,700';
	}

	$query_args = array(
		'family' => urlencode( implode( '|', $fonts ) ),
		'subset' => urlencode( $subsets ),
	);

	if ( $fonts ) {
		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}
endif;

require get_theme_file_path() . '/inc/customizer.php';

require get_theme_file_path() . '/inc/service-template.php';

require get_theme_file_path() . '/inc/team-template.php';
