/**
 * Scripts within the customizer controls window.
 *
 */

jQuery( document ).ready(function($) {

    // icon picker
    $('.vital-corporate-icon-picker').each( function() {
        $(this).iconpicker( '#' + this.id );
    } );

});

/**
 * Add a listener to update other controls to new values/defaults.
 */

( function( api ) {
  
     // Detect when the front page sections section is expanded (or closed) so we can adjust the preview accordingly.
    wp.customize.section( 'vital_corporate_service_section', function( section ) {
        section.expanded.bind( function( isExpanding ) {
            // Value of isExpanding will = true if you're entering the section, false if you're leaving it.
            wp.customize.previewer.send( 'service_section', { expanded: isExpanding });
        } );
    } );

    wp.customize.section( 'vital_corporate_team_section', function( section ) {
        section.expanded.bind( function( isExpanding ) {
            // Value of isExpanding will = true if you're entering the section, false if you're leaving it.
            wp.customize.previewer.send( 'team_section', { expanded: isExpanding });
        } );
    } );

} )( wp.customize );