<?php
 /**
  * Title: Homepage
  * Slug: visualsite/homepage
  * Categories: visualsite
  */
?>

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0px"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull" style="margin-top:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-featured-content.jpeg","id":996,"dimRatio":50,"focalPoint":{"x":0.5,"y":0.4},"minHeight":500,"isDark":false} -->
<div class="wp-block-cover is-light" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-996" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-featured-content.jpeg" style="object-position:50% 40%" data-object-fit="cover" data-object-position="50% 40%"/><div class="wp-block-cover__inner-container"><!-- wp:group {"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading -->
<h2><?php esc_html_e('Start Building A Great Company', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"constrained","justifyContent":"left","contentSize":"750px"}} -->
<div class="wp-block-group"><!-- wp:paragraph -->
<p><?php esc_html_e('VisualSite is a WordPress theme built with the WordPress Site Editor, which allows you to create beautiful websites with drag and drop, no coding skills required.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:buttons {"style":{"spacing":{"blockGap":"20px"}}} -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"vivid-cyan-blue","textColor":"base","className":"is-style-fill","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-fill has-small-font-size"><a class="wp-block-button__link has-base-color has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button" href="#"><strong><?php esc_html_e('Get Started', 'visualsite'); ?></strong></a></div>
<!-- /wp:button -->

<!-- wp:button {"backgroundColor":"vivid-green-cyan","textColor":"base","className":"is-style-fill","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-fill has-small-font-size"><a class="wp-block-button__link has-base-color has-vivid-green-cyan-background-color has-text-color has-background wp-element-button" href="#"><strong><?php esc_html_e('Our Services', 'visualsite'); ?></strong></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"2rem"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:2rem"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"backgroundColor":"vivid-cyan-blue","textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-vivid-cyan-blue-background-color has-text-color has-background"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"3.5rem"}},"textColor":"background"} -->
<h2 class="has-text-align-center has-background-color has-text-color" style="font-size:3.5rem"><?php esc_html_e('99%', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"background"} -->
<h3 class="has-text-align-center has-background-color has-text-color"><?php esc_html_e('Client retention', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('100% satisfy clients in our work', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"backgroundColor":"vivid-purple","textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-vivid-purple-background-color has-text-color has-background"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"3.5rem"}},"textColor":"background"} -->
<h2 class="has-text-align-center has-background-color has-text-color" style="font-size:3.5rem"><?php esc_html_e('15+', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"background"} -->
<h3 class="has-text-align-center has-background-color has-text-color"><?php esc_html_e('Years of experience', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('Fully focused on what we are doing', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"backgroundColor":"luminous-vivid-orange","textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-luminous-vivid-orange-background-color has-text-color has-background"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"3.5rem"}},"textColor":"background"} -->
<h2 class="has-text-align-center has-background-color has-text-color" style="font-size:3.5rem"><?php esc_html_e('80+', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"background"} -->
<h3 class="has-text-align-center has-background-color has-text-color"><?php esc_html_e('Professionals', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('Solid and responsible technical team', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"backgroundColor":"luminous-vivid-amber","textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-luminous-vivid-amber-background-color has-text-color has-background"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"3.5rem"}},"textColor":"background"} -->
<h2 class="has-text-align-center has-background-color has-text-color" style="font-size:3.5rem"><?php esc_html_e('50M', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"background"} -->
<h3 class="has-text-align-center has-background-color has-text-color"><?php esc_html_e('Project value', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('99% successfully all project done', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"2rem","bottom":"2rem"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:2rem;padding-bottom:2rem"><!-- wp:group {"style":{"spacing":{"blockGap":"0px","margin":{"top":"2rem","bottom":"2rem"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:2rem;margin-bottom:2rem"><!-- wp:group {"style":{"spacing":{"blockGap":"5px","padding":{"bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-bottom:30px"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('Our Products', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"textTransform":"uppercase","fontSize":"0.8rem","letterSpacing":"1px"},"color":{"text":"#666666"}}} -->
<p class="has-text-align-center has-text-color" style="color:#666666;font-size:0.8rem;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e('This is your awesome sub title', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group full-width-image"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":940,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-1.jpeg" alt="" class="wp-image-940"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 1', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":947,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-5.jpeg" alt="" class="wp-image-947"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 5', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":949,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-2.jpeg" alt="" class="wp-image-949"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 2', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":945,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-6.jpeg" alt="" class="wp-image-945"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 6', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":948,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-3.jpeg" alt="" class="wp-image-948"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 3', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":941,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-7.jpeg" alt="" class="wp-image-941"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 7', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":946,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-4.jpeg" alt="" class="wp-image-946"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 4', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"id":943,"sizeSlug":"full","linkDestination":"custom"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/product-8.jpeg" alt="" class="wp-image-943"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Product Title 8', 'visualsite'); ?></a></h3>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"2rem","right":"0","bottom":"2rem","left":"0"},"blockGap":"0"},"color":{"background":"#f0f0f0"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull has-background full-width-image" style="background-color:#f0f0f0;padding-top:2rem;padding-right:0;padding-bottom:2rem;padding-left:0"><!-- wp:group {"style":{"spacing":{"blockGap":"0px","padding":{"top":"10px","bottom":"20px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:10px;padding-bottom:20px"><!-- wp:group {"style":{"spacing":{"blockGap":"5px","padding":{"bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-bottom:30px"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('Our Services', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('This is your awesome sub title', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":969,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-1.jpeg" alt="" class="wp-image-969"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 1', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":958,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-4.jpeg" alt="" class="wp-image-958"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 4', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":967,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-2.jpeg" alt="" class="wp-image-967"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 2', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":970,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-5.jpeg" alt="" class="wp-image-970"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 5', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":966,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-3.jpeg" alt="" class="wp-image-966"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 3', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"15px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":960,"sizeSlug":"full","linkDestination":"custom","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-6.jpeg" alt="" class="wp-image-960"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"20px","left":"20px","bottom":"20px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:heading {"level":3} -->
<h3><a href="#"><?php esc_html_e('My Service Title 6', 'visualsite'); ?></a></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0px","bottom":"0px"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull" style="margin-top:0px;margin-bottom:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-features.jpeg","id":1264,"dimRatio":50,"isDark":false,"style":{"spacing":{"padding":{"top":"40px","bottom":"60px"}}}} -->
<div class="wp-block-cover is-light" style="padding-top:40px;padding-bottom:60px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-1264" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-features.jpeg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('Product Features', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","fontSize":"medium"} -->
<p class="has-text-align-center has-medium-font-size"><?php esc_html_e('This is your awesome sub title', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:30px"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1051,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-chart-pie.png" alt="" class="wp-image-1051" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 1', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px"><?php esc_html_e('Learn more', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"},"border":{"radius":{"topRight":"0px","bottomLeft":"0px"}}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="border-top-right-radius:0px;border-bottom-left-radius:0px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1058,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-address-card.png" alt="" class="wp-image-1058" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 4', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1055,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-chart-line.png" alt="" class="wp-image-1055" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 2', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"},"border":{"radius":{"topRight":"0px","bottomLeft":"0px"}}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="border-top-right-radius:0px;border-bottom-left-radius:0px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1059,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-bullhorn.png" alt="" class="wp-image-1059" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 5', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1057,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-calendar-alt.png" alt="" class="wp-image-1057" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 3', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","right":"20px","bottom":"20px","left":"20px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:image {"align":"center","id":1060,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-pen-square.png" alt="" class="wp-image-1060" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center","level":3,"textColor":"black"} -->
<h3 class="has-text-align-center has-black-color has-text-color"><?php esc_html_e('My Feature Title 6', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris enim velit, laoreet.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"15px","bottom":"5px"}}}} -->
<div class="wp-block-buttons" style="margin-top:15px;margin-bottom:5px"><!-- wp:button {"textColor":"base","style":{"spacing":{"padding":{"top":"5px","bottom":"5px"}}},"fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#" style="padding-top:5px;padding-bottom:5px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"3rem","right":"0px","bottom":"3rem","left":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:3rem;padding-right:0px;padding-bottom:3rem;padding-left:0px"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":962,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/image-1.jpeg" alt="" class="wp-image-962"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"15px","padding":{"left":"20px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-left:20px"><!-- wp:heading {"level":3,"textColor":"vivid-green-cyan"} -->
<h3 class="has-vivid-green-cyan-color has-text-color"><?php esc_html_e('Who We Are', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:heading -->
<h2><?php esc_html_e('We\'re passionate in helping your project grow.', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('Etiam eleifend velit mollis venenatis ultricies. Sed pretium in turpis sed fringilla. Etiam rutrum arcu, quis ullamcorper sem sodales ac.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:list -->
<ul><!-- wp:list-item -->
<li><?php esc_html_e('Unlimited websites usage', 'visualsite'); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e('Amazing photo &amp; video galleries', 'visualsite'); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e('Huge color scheme selection', 'visualsite'); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"vivid-cyan-blue","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-vivid-cyan-blue-background-color has-background wp-element-button" href="#"><?php esc_html_e('Explore More', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"3rem","right":"0px","bottom":"3rem","left":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:3rem;padding-right:0px;padding-bottom:3rem;padding-left:0px"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"15px","padding":{"right":"20px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:20px"><!-- wp:heading {"level":3,"textColor":"vivid-green-cyan"} -->
<h3 class="has-vivid-green-cyan-color has-text-color"><?php esc_html_e('What We Do', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:heading -->
<h2><?php esc_html_e('We will get your project online in a timely manner.', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e('Quisque blandit dolor risus, sed dapibus dui facilisis sed. Donec eu porta elit aliquam. Aliquam porta sollicitudin ante, ac fermentum orci.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:list -->
<ul><!-- wp:list-item -->
<li><?php esc_html_e('Unlimited websites usage', 'visualsite'); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e('Amazing photo &amp; video galleries', 'visualsite'); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php esc_html_e('Huge color scheme selection', 'visualsite'); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"vivid-cyan-blue","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-vivid-cyan-blue-background-color has-background wp-element-button" href="#"><?php esc_html_e('Explore More', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":961,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/image-2.jpeg" alt="" class="wp-image-961"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","layout":{"type":"default"}} -->
<div class="wp-block-group alignfull"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-4.jpeg","id":958,"dimRatio":50,"focalPoint":{"x":0.2,"y":0.2},"isDark":false} -->
<div class="wp-block-cover is-light"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-958" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/service-4.jpeg" style="object-position:20% 20%" data-object-fit="cover" data-object-position="20% 20%"/><div class="wp-block-cover__inner-container"><!-- wp:group {"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading {"textAlign":"left"} -->
<h2 class="has-text-align-left"><?php esc_html_e('Your Title Here', 'visualsite'); ?><br><?php esc_html_e('Just Another Line of Section Title', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","fontSize":"medium"} -->
<p class="has-text-align-left has-medium-font-size"><?php esc_html_e('A simple description here, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-outline has-small-font-size"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('View Pricing', 'visualsite'); ?></a></div>
<!-- /wp:button -->

<!-- wp:button {"className":"is-style-outline","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-outline has-small-font-size"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Learn More', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"2rem","right":"0","bottom":"3rem","left":"0"},"blockGap":"0","margin":{"top":"0px","bottom":"0px"}},"color":{"background":"#f0f0f0"}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull has-background full-width-image" style="background-color:#f0f0f0;margin-top:0px;margin-bottom:0px;padding-top:2rem;padding-right:0;padding-bottom:3rem;padding-left:0"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"5px","padding":{"bottom":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-bottom:30px"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('Meet Our Team', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('This is your awesome sub title', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":985,"sizeSlug":"full","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/team-8.png" alt="" class="wp-image-985"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"15px","left":"15px","bottom":"20px","top":"10px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:10px;padding-right:15px;padding-bottom:20px;padding-left:15px"><!-- wp:heading {"textAlign":"center","level":5} -->
<h5 class="has-text-align-center"><?php esc_html_e('John Doe', 'visualsite'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#999999"},"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"0.8rem"}}} -->
<p class="has-text-align-center has-text-color" style="color:#999999;font-size:0.8rem;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e('Team Leader', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"size":"has-small-icon-size","style":{"spacing":{"margin":{"top":"10px"},"blockGap":{"top":"8px","left":"8px"}}},"className":"is-style-default","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-small-icon-size is-style-default" style="margin-top:10px"><!-- wp:social-link {"url":"#","service":"twitter"} /-->

<!-- wp:social-link {"url":"#","service":"facebook"} /-->

<!-- wp:social-link {"url":"#","service":"instagram"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":990,"sizeSlug":"full","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/team-6.png" alt="" class="wp-image-990"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"15px","left":"15px","bottom":"20px","top":"10px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:10px;padding-right:15px;padding-bottom:20px;padding-left:15px"><!-- wp:heading {"textAlign":"center","level":5} -->
<h5 class="has-text-align-center"><?php esc_html_e('John Doe', 'visualsite'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#999999"},"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"0.8rem"}}} -->
<p class="has-text-align-center has-text-color" style="color:#999999;font-size:0.8rem;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e('Support Manager', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"size":"has-small-icon-size","style":{"spacing":{"blockGap":{"top":"8px","left":"8px"},"margin":{"top":"10px"}}},"className":"is-style-default","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-small-icon-size is-style-default" style="margin-top:10px"><!-- wp:social-link {"url":"#","service":"twitter"} /-->

<!-- wp:social-link {"url":"#","service":"facebook"} /-->

<!-- wp:social-link {"url":"#","service":"instagram"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":987,"sizeSlug":"full","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/team-1.png" alt="" class="wp-image-987"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"15px","left":"15px","bottom":"20px","top":"10px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:10px;padding-right:15px;padding-bottom:20px;padding-left:15px"><!-- wp:heading {"textAlign":"center","level":5} -->
<h5 class="has-text-align-center"><?php esc_html_e('John Doe', 'visualsite'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#999999"},"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"0.8rem"}}} -->
<p class="has-text-align-center has-text-color" style="color:#999999;font-size:0.8rem;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e('PHP Developer', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"size":"has-small-icon-size","style":{"spacing":{"blockGap":{"top":"8px","left":"8px"},"margin":{"top":"10px"}}},"className":"is-style-default","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-small-icon-size is-style-default" style="margin-top:10px"><!-- wp:social-link {"url":"#","service":"twitter"} /-->

<!-- wp:social-link {"url":"#","service":"facebook"} /-->

<!-- wp:social-link {"url":"#","service":"instagram"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"5px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:image {"id":988,"sizeSlug":"full","linkDestination":"none","className":"is-style-default"} -->
<figure class="wp-block-image size-full is-style-default"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/team-4.png" alt="" class="wp-image-988"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"15px","left":"15px","bottom":"20px","top":"10px"},"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:10px;padding-right:15px;padding-bottom:20px;padding-left:15px"><!-- wp:heading {"textAlign":"center","level":5} -->
<h5 class="has-text-align-center"><?php esc_html_e('John Doe', 'visualsite'); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#999999"},"typography":{"textTransform":"uppercase","letterSpacing":"1px","fontSize":"0.8rem"}}} -->
<p class="has-text-align-center has-text-color" style="color:#999999;font-size:0.8rem;letter-spacing:1px;text-transform:uppercase"><?php esc_html_e('Graphic Designer', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:social-links {"size":"has-small-icon-size","style":{"spacing":{"blockGap":{"top":"8px","left":"8px"},"margin":{"top":"10px"}}},"className":"is-style-default","layout":{"type":"flex","justifyContent":"center"}} -->
<ul class="wp-block-social-links has-small-icon-size is-style-default" style="margin-top:10px"><!-- wp:social-link {"url":"#","service":"twitter"} /-->

<!-- wp:social-link {"url":"#","service":"facebook"} /-->

<!-- wp:social-link {"url":"#","service":"instagram"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"30px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:30px"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"vivid-green-cyan","textColor":"base","className":"is-style-fill","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-fill has-small-font-size"><a class="wp-block-button__link has-base-color has-vivid-green-cyan-background-color has-text-color has-background wp-element-button" href="#"><?php esc_html_e('View Our Team', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:query {"queryId":0,"query":{"perPage":"3","pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false,"taxQuery":{"category":[]},"parents":[]},"displayLayout":{"type":"flex","columns":3},"layout":{"type":"constrained"}} -->
<div class="wp-block-query"><!-- wp:group {"style":{"spacing":{"blockGap":"5px","padding":{"bottom":"10px","top":"20px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:20px;padding-bottom:10px"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('From Our Blog Posts', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#666666"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#666666"><?php esc_html_e('This is your awesome sub title', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:post-template {"fontSize":"small"} -->
<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}}} -->
<div class="wp-block-group"><!-- wp:post-featured-image {"isLink":true} /-->

<!-- wp:group {"style":{"typography":{"letterSpacing":"2px","textTransform":"uppercase","fontSize":"12rem"}},"layout":{"type":"flex"}} -->
<div class="wp-block-group" style="font-size:12rem;letter-spacing:2px;text-transform:uppercase"><!-- wp:post-date {"isLink":true,"style":{"elements":{"link":{"color":{"text":"#666666"}}},"typography":{"fontSize":"12px","letterSpacing":"1px"}}} /--></div>
<!-- /wp:group -->

<!-- wp:post-title {"isLink":true,"style":{"typography":{"fontStyle":"normal","fontWeight":"700","fontSize":"1.4rem"}}} /-->

<!-- wp:post-excerpt /--></div>
<!-- /wp:group -->
<!-- /wp:post-template -->

<!-- wp:group {"layout":{"inherit":true,"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"bottom":"40px"}}}} -->
<div class="wp-block-buttons" style="margin-bottom:40px"><!-- wp:button {"textColor":"base","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link has-base-color has-text-color wp-element-button" href="#"><?php esc_html_e('View All Blog Posts', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:query -->

<!-- wp:group {"align":"full","layout":{"type":"default"}} -->
<div class="wp-block-group alignfull"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-landscape.jpeg","id":1035,"dimRatio":0,"minHeight":360} -->
<div class="wp-block-cover" style="min-height:360px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-1035" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-landscape.jpeg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"5px"},"color":{"background":"#00000059"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color has-background" style="background-color:#00000059"><!-- wp:image {"align":"center","id":1029,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-user.png" alt="" class="wp-image-1029" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('69', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php esc_html_e('Company Employees', 'visualsite'); ?></strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"5px"},"color":{"background":"#00000059"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color has-background" style="background-color:#00000059"><!-- wp:image {"align":"center","id":1030,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-desktop.png" alt="" class="wp-image-1030" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('100+', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php esc_html_e('Awesome Products', 'visualsite'); ?></strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"5px"},"color":{"background":"#00000059"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color has-background" style="background-color:#00000059"><!-- wp:image {"align":"center","id":1031,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-users.png" alt="" class="wp-image-1031" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('38,000+', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php esc_html_e('Global Customers', 'visualsite'); ?></strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"5px"},"color":{"background":"#00000059"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color has-background" style="background-color:#00000059"><!-- wp:image {"align":"center","id":1032,"width":50,"height":50,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-life-ring.png" alt="" class="wp-image-1032" width="50" height="50"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('2,900+', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><strong><?php esc_html_e('Tickets Resolved', 'visualsite'); ?></strong></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"2rem","bottom":"2rem"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:2rem;padding-bottom:2rem"><!-- wp:group {"style":{"spacing":{"blockGap":"5px","padding":{"bottom":"10px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-bottom:10px"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="has-text-align-center"><?php esc_html_e('Explore More Features', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"color":{"text":"#999999"}},"fontSize":"medium"} -->
<p class="has-text-align-center has-text-color has-medium-font-size" style="color:#999999"><?php esc_html_e('This is your awesome description', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1062,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-coffee.png" alt="" class="wp-image-1062"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 1', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1068,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-edit.png" alt="" class="wp-image-1068"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 4', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1073,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-download.png" alt="" class="wp-image-1073"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 7', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1064,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-book.png" alt="" class="wp-image-1064"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 2', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1069,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-phone-square-alt.png" alt="" class="wp-image-1069"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 5', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1076,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-database.png" alt="" class="wp-image-1076"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 8', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1066,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-globe.png" alt="" class="wp-image-1066"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 3', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1071,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-file-alt.png" alt="" class="wp-image-1071"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 6', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"1.5rem"}},"layout":{"type":"flex","flexWrap":"nowrap","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:image {"id":1078,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/icon-shopping-cart.png" alt="" class="wp-image-1078"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"5px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3><?php esc_html_e('My Feature Title 9', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php esc_html_e('This is a simple description of this feature, just replace with your own content.', 'visualsite'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"bottom":"10px"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignfull" style="padding-bottom:10px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cta-1.png","id":227,"dimRatio":0,"minHeight":280,"isDark":false} -->
<div class="wp-block-cover is-light" style="min-height:280px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-227" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cta-1.png" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"textColor":"base","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-base-color has-text-color"><!-- wp:heading {"textAlign":"center","textColor":"background"} -->
<h2 class="has-text-align-center has-background-color has-text-color"><?php esc_html_e('Take Your Business To The Next Level', 'visualsite'); ?></h2>
<!-- /wp:heading -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"background","className":"is-style-outline","fontSize":"small"} -->
<div class="wp-block-button has-custom-font-size is-style-outline has-small-font-size"><a class="wp-block-button__link has-background-color has-text-color wp-element-button" href="#"><?php esc_html_e('Get Started Today', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"margin":{"top":"2rem","bottom":"3rem"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:2rem;margin-bottom:3rem"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-1.jpeg","id":974,"dimRatio":50,"minHeight":360,"isDark":false} -->
<div class="wp-block-cover is-light" style="min-height:360px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-974" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-1.jpeg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center"><?php esc_html_e('My Custom Title 1', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('Etiam eleifend velit mollis venenatis', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"20px"}}}} -->
<div class="wp-block-buttons" style="margin-top:20px"><!-- wp:button {"className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Get Started', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-2.jpeg","id":403,"dimRatio":50,"minHeight":360} -->
<div class="wp-block-cover" style="min-height:360px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-403" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-2.jpeg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center"><?php esc_html_e('My Custom Title 2', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('Sed pretium in turpis sed fringilla', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"20px"}}}} -->
<div class="wp-block-buttons" style="margin-top:20px"><!-- wp:button {"className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Learn More', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-3.jpeg","id":973,"dimRatio":50,"minHeight":360,"isDark":false} -->
<div class="wp-block-cover is-light" style="min-height:360px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background wp-image-973" alt="" src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/bg-cover-3.jpeg" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"textColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-color has-text-color"><!-- wp:heading {"textAlign":"center","level":3} -->
<h3 class="has-text-align-center"><?php esc_html_e('My Custom Title 3', 'visualsite'); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e('Quisque blandit dolor risus dapibus', 'visualsite'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"20px"}}}} -->
<div class="wp-block-buttons" style="margin-top:20px"><!-- wp:button {"className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e('Explore Now', 'visualsite'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"3rem","bottom":"4rem"}}},"gradient":"luminous-dusk","className":"pricing-table","layout":{"type":"default"}} -->
<div class="wp-block-group alignfull pricing-table has-luminous-dusk-gradient-background has-background" style="padding-top:3rem;padding-bottom:4rem"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"constrained","justifyContent":"center"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","textColor":"background"} -->
<h2 class="wp-block-heading has-text-align-center has-background-color has-text-color">Pricing Table</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","textColor":"background"} -->
<p class="has-text-align-center has-background-color has-text-color">Take your website online in minutes</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"2rem","bottom":"2.5rem"}}},"backgroundColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-background-color has-background" style="padding-top:2rem;padding-bottom:2.5rem"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"fontSize":"large"} -->
<h2 class="wp-block-heading has-large-font-size">Personal</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size">Great for beginners</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px"}}},"textColor":"vivid-green-cyan","fontSize":"large"} -->
<h4 class="wp-block-heading has-vivid-green-cyan-color has-text-color has-large-font-size" style="margin-top:10px;margin-right:0px;margin-bottom:0px;margin-left:0px">$9.95/mo*</h4>
<!-- /wp:heading -->

<!-- wp:list {"style":{"spacing":{"margin":{"top":"10px"},"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}}} -->
<ul style="margin-top:10px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:list-item -->
<li>3 Sites License</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to All Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to Future Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Support</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Theme Updates</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Automatic Updates</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"vivid-green-cyan","width":100} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-vivid-green-cyan-background-color has-background wp-element-button" href="#">Buy Now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"2rem","bottom":"2.5rem"}}},"backgroundColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-background-color has-background" style="padding-top:2rem;padding-bottom:2.5rem"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"fontSize":"large"} -->
<h2 class="wp-block-heading has-large-font-size">Business</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size">Ideal for developers</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px"}}},"textColor":"luminous-vivid-orange","fontSize":"large"} -->
<h4 class="wp-block-heading has-luminous-vivid-orange-color has-text-color has-large-font-size" style="margin-top:10px;margin-right:0px;margin-bottom:0px;margin-left:0px">$19.95/mo*</h4>
<!-- /wp:heading -->

<!-- wp:list {"style":{"spacing":{"margin":{"top":"10px"},"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}}} -->
<ul style="margin-top:10px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:list-item -->
<li>10 Sites License</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to All Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to Future Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Support</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Theme Updates</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Automatic Updates</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"luminous-vivid-orange","width":100} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-luminous-vivid-orange-background-color has-background wp-element-button" href="#">Buy Now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"2rem","bottom":"2.5rem"}}},"backgroundColor":"background","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-background-background-color has-background" style="padding-top:2rem;padding-bottom:2.5rem"><!-- wp:group {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:heading {"fontSize":"large"} -->
<h2 class="wp-block-heading has-large-font-size">Agency</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"fontSize":"tiny"} -->
<p class="has-tiny-font-size">For big companies</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"10px","right":"0px","bottom":"0px","left":"0px"}}},"textColor":"vivid-cyan-blue","fontSize":"large"} -->
<h4 class="wp-block-heading has-vivid-cyan-blue-color has-text-color has-large-font-size" style="margin-top:10px;margin-right:0px;margin-bottom:0px;margin-left:0px">$29.95/mo*</h4>
<!-- /wp:heading -->

<!-- wp:list {"style":{"spacing":{"margin":{"top":"10px"},"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}}} -->
<ul style="margin-top:10px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:list-item -->
<li>25 Sites License</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to All Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Access to Future Themes</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Support</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>1 Year of Theme Updates</li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li>Automatic Updates</li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"width":100} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button" href="#">Buy Now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->