<?php
/**
 * Singular Themes Setup Page
 */
if (!defined('ABSPATH')) {
    exit;
}

function singularthemes_add_setup_menu() {
    add_theme_page(
        __('Singular Themes', 'vistaro'),
        __('Singular Themes', 'vistaro'),
        'edit_theme_options',
        'singularthemes-setup',
        'singularthemes_render_setup_page'
    );
}
add_action('admin_menu', 'singularthemes_add_setup_menu');

function singularthemes_render_setup_page() {
    $theme = wp_get_theme();
    $theme_name = $theme->get('Name');
    ?>

    <style>
        .singularthemes-setup-container {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            max-width: 1000px;
            margin: 40px auto;
            padding: 40px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.06);
            display:flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 25px;
        }

        .singularthemes-setup-container h1 {
            font-size: 4rem;
            margin-bottom: 30px;
            color: #000;
            text-align: center;
            text-shadow: 1px 1px 5px black;
            text-transform: uppercase;
            font-weight: 800;
        }
        .singularthemes-setup-container  img{
            max-width: 50%;
        }
        .singularthemes-setup-columns {
            display: flex;
            flex-wrap: wrap;
            gap: 40px;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
        }

        .singularthemes-setup-text {
            flex: 1 1 45%;
            color: #000;
            line-height: 1.6;
            letter-spacing: 1px;
        }
        .singularthemes-setup-text p{
            font-size: 16px!important;
            text-align: justify!important;

        }

        .singularthemes-setup-theme {
            flex: 1 1 45%;
            text-align: center;
        }
        .singularthemes-setup-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-store, .btn-demo {
            font-weight: bold;
            padding: 14px 26px;
            border: none;
            border-radius: 6px;
            text-decoration: none;
            transition: background-color 0.3s ease;
            text-transform: uppercase;
        }
        .btn-store:hover, .btn-demo:hover{
            color: #FFF;
            opacity: 80%;
        }
        .btn-store {
            background-color: #ff0096;
            color: #fff;
            box-shadow: 0 6px 20px rgba(255, 0, 150, 0.3);
        }
        .btn-demo {
            background-color:rgb(0, 0, 0);
            color: #fff;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
        }

    </style>

    <div class="singularthemes-setup-container">
        <img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/theme/singular-themes.webp" alt="Singular Themes">

        <div class="singularthemes-setup-columns">
            <div class="singularthemes-setup-text">
                <p>
                    <?php esc_html_e('Thank you for activating a theme by Singular Themes. This is the FREE version of the theme. To unlock all full templates, advanced blocks, and premium support, we recommend upgrading to the PRO version.', 'vistaro'); ?>
                </p>
                <p>
                    <?php esc_html_e('Check out the complete PRO demo below, or explore our full collection of premium themes in the store.', 'vistaro'); ?>
                </p>
            </div>
            <div class="singularthemes-setup-theme">
                 <h1><?php esc_html_e('Vistaro', 'vistaro'); ?></h1>
            </div>
        </div>

        <div class="singularthemes-setup-buttons">
            <a class="btn-demo" href="https://singularthemes.com/demo/?url=https://singularthemes.com/preview/vistaro/" target="_blank" class="singularthemes-button">
                <?php esc_html_e('DEMO', 'vistaro'); ?>
            </a>
            <a class="btn-store" href="https://singularthemes.com/" target="_blank" class="singularthemes-button">
                <?php esc_html_e('Singular Themes', 'vistaro'); ?>
            </a>
        </div>
    </div>

    <?php
}
