<?php
/**
 * Singular Themes
 * 
 * Theme Name: Vistaro
 * Author: Singular Themes
 * Version: 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

require get_template_directory() . '/theme/setup.php';

function vistaro_admin_notice_setup_page() {
    $screen = get_current_screen();

    if (get_option('vistaro_notice_dismissed')) {
        return;
    }

    if (!in_array($screen->base, ['themes', 'dashboard'])) {
        return;
    }

    $theme = wp_get_theme();
    $setup_url = esc_url(admin_url('themes.php?page=singularthemes-setup'));

    ?>
    <style>
        .vistaro-notice {
            background-color: #ffa807ff;
            color: #fff;
            padding: 20px;
            border:none;
            border-radius: 8px;
            box-shadow: 0 6px 20px rgba(255, 123, 0, 0.4);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 20px;
            flex-wrap: wrap;
        }

        .vistaro-notice p {
            font-size: 16px;
            margin: 0;
        }

        .vistaro-notice a.button-pro {
            background-color: #fff;
            color: #ffa807ff;
            font-weight: bold;
            padding: 10px 20px;
            border-radius: 4px;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .vistaro-notice a.button-pro:hover {
            background-color: #fff1e3ff;
            color: #ffa807ff;
        }
    </style>

    <div class="notice is-dismissible vistaro-notice">
        <p>
            <?php
                printf(
                    esc_html__('You\'ve just activated %1$s FREE. For a complete experience, consider purchasing the PRO version.', 'vistaro'),
                    '<strong>' . esc_html($theme->get('Name')) . '</strong>'
                );
            ?>
        </p>
        <a href="<?php echo $setup_url; ?>" class="button-pro">
            <?php esc_html_e('CHECK OUT PRO DEMO', 'vistaro'); ?>
        </a>
    </div>
    <?php
}
add_action('admin_notices', 'vistaro_admin_notice_setup_page');



add_action( 'init', 'vistaro_register_pattern_categories' );

function vistaro_register_pattern_categories() {
	register_block_pattern_category(
		'vistaro-theme',
		array(
			'label'       => __( 'Vistaro Patterns', 'vistaro' ),
			'description' => __( 'Singular Themes patterns.', 'vistaro' ),
		)
	);
}
function vistaro_theme_enqueue_styles()
{
    wp_enqueue_style(
        'vistaro-core-css',
        get_template_directory_uri() . '/theme/css/core.css',
        array(),
        wp_get_theme()->get('Version'),
        'all'
    );
}
add_action('wp_enqueue_scripts', 'vistaro_theme_enqueue_styles');

 function vistaro_theme_js_script()
{
    wp_enqueue_script(
        'vistaro-core-js',
        get_template_directory_uri() . '/theme/js/core.js',
        array(),
        wp_get_theme()->get('Version'),
        true 
    );
}
add_action('wp_enqueue_scripts', 'vistaro_theme_js_script');

// === Script save "dismiss" ===
function vistaro_admin_notice_dismiss_script() {
    ?>
    <script>
    (function($){
        $(document).on('click', '.vistaro-notice .notice-dismiss', function(){
            $.post(ajaxurl, {
                action: 'vistaro_dismiss_notice'
            });
        });
    })(jQuery);
    </script>
    <?php
}
add_action('admin_footer', 'vistaro_admin_notice_dismiss_script');


// === AJAX callback ===
function vistaro_dismiss_notice_callback() {
    update_option('vistaro_notice_dismissed', true);
    wp_die();
}
add_action('wp_ajax_vistaro_dismiss_notice', 'vistaro_dismiss_notice_callback');

function singular_editor_notice() {
    wp_enqueue_script(
        'singular-editor-notice',
        get_template_directory_uri() . '/theme/js/editor-notice.js',
        array('wp-plugins', 'wp-edit-post', 'wp-components', 'wp-element', 'wp-data'),
        false,
        true
    );
}
add_action( 'enqueue_block_editor_assets', 'singular_editor_notice' );

