<?php
/**
 * Builds our admin page.
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'vishnu_create_menu' ) ) {
	add_action( 'admin_menu', 'vishnu_create_menu' );
	/**
	 * Adds our "Vishnu" dashboard menu item
	 *
	 */
	function vishnu_create_menu() {
		$vishnu_page = add_theme_page( 'Vishnu', 'Vishnu', apply_filters( 'vishnu_dashboard_page_capability', 'edit_theme_options' ), 'vishnu-options', 'vishnu_settings_page' );
		add_action( "admin_print_styles-$vishnu_page", 'vishnu_options_styles' );
	}
}

if ( ! function_exists( 'vishnu_options_styles' ) ) {
	/**
	 * Adds any necessary scripts to the Vishnu dashboard page
	 *
	 */
	function vishnu_options_styles() {
		wp_enqueue_style( 'vishnu-options', get_template_directory_uri() . '/css/admin/admin-style.css', array(), VISHNU_VERSION );
	}
}

if ( ! function_exists( 'vishnu_settings_page' ) ) {
	/**
	 * Builds the content of our Vishnu dashboard page
	 *
	 */
	function vishnu_settings_page() {
		?>
		<div class="wrap">
			<div class="metabox-holder">
				<div class="vishnu-masthead clearfix">
					<div class="vishnu-container">
						<div class="vishnu-title">
							<a href="<?php echo esc_url(VISHNU_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Vishnu', 'vishnu' ); ?></a> <span class="vishnu-version"><?php echo VISHNU_VERSION; ?></span>
						</div>
						<div class="vishnu-masthead-links">
							<?php if ( ! defined( 'VISHNU_PREMIUM_VERSION' ) ) : ?>
								<a class="vishnu-masthead-links-bold" href="<?php echo esc_url(VISHNU_THEME_URL); ?>" target="_blank"><?php esc_html_e( 'Premium', 'vishnu' );?></a>
							<?php endif; ?>
							<a href="<?php echo esc_url(VISHNU_WPKOI_AUTHOR_URL); ?>" target="_blank"><?php esc_html_e( 'WPKoi', 'vishnu' ); ?></a>
                            <a href="<?php echo esc_url(VISHNU_DOCUMENTATION); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'vishnu' ); ?></a>
						</div>
					</div>
				</div>

				<?php
				/**
				 * vishnu_dashboard_after_header hook.
				 *
				 */
				 do_action( 'vishnu_dashboard_after_header' );
				 ?>

				<div class="vishnu-container">
					<div class="postbox-container clearfix" style="float: none;">
						<div class="grid-container grid-parent">

							<?php
							/**
							 * vishnu_dashboard_inside_container hook.
							 *
							 */
							 do_action( 'vishnu_dashboard_inside_container' );
							 ?>

							<div class="form-metabox grid-70" style="padding-left: 0;">
								<h2 style="height:0;margin:0;"><!-- admin notices below this element --></h2>
								<form method="post" action="options.php">
									<?php settings_fields( 'vishnu-settings-group' ); ?>
									<?php do_settings_sections( 'vishnu-settings-group' ); ?>
									<div class="customize-button hide-on-desktop">
										<?php
										printf( '<a id="vishnu_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
											esc_url( admin_url( 'customize.php' ) ),
											esc_html__( 'Customize', 'vishnu' )
										);
										?>
									</div>

									<?php
									/**
									 * vishnu_inside_options_form hook.
									 *
									 */
									 do_action( 'vishnu_inside_options_form' );
									 ?>
								</form>

								<?php
								$modules = array(
									'Backgrounds' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Blog' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Colors' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Copyright' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Disable Elements' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Demo Import' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Hooks' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Import / Export' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Menu Plus' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Page Header' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Secondary Nav' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Spacing' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Typography' => array(
											'url' => VISHNU_THEME_URL,
									),
									'Elementor Addon' => array(
											'url' => VISHNU_THEME_URL,
									)
								);

								if ( ! defined( 'VISHNU_PREMIUM_VERSION' ) ) : ?>
									<div class="postbox vishnu-metabox">
										<h3 class="hndle"><?php esc_html_e( 'Premium Modules', 'vishnu' ); ?></h3>
										<div class="inside" style="margin:0;padding:0;">
											<div class="premium-addons">
												<?php foreach( $modules as $module => $info ) { ?>
												<div class="add-on activated vishnu-clear addon-container grid-parent">
													<div class="addon-name column-addon-name" style="">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php echo esc_html( $module ); ?></a>
													</div>
													<div class="addon-action addon-addon-action" style="text-align:right;">
														<a href="<?php echo esc_url( $info[ 'url' ] ); ?>" target="_blank"><?php esc_html_e( 'More info', 'vishnu' ); ?></a>
													</div>
												</div>
												<div class="vishnu-clear"></div>
												<?php } ?>
											</div>
										</div>
									</div>
								<?php
								endif;

								/**
								 * vishnu_options_items hook.
								 *
								 */
								do_action( 'vishnu_options_items' );
								?>
							</div>

							<div class="vishnu-right-sidebar grid-30" style="padding-right: 0;">
								<div class="customize-button hide-on-mobile">
									<?php
									printf( '<a id="vishnu_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
										esc_url( admin_url( 'customize.php' ) ),
										esc_html__( 'Customize', 'vishnu' )
									);
									?>
								</div>

								<?php
								/**
								 * vishnu_admin_right_panel hook.
								 *
								 */
								 do_action( 'vishnu_admin_right_panel' );

								  ?>
                                
                                <div class="wpkoi-doc">
                                	<h3><?php esc_html_e( 'Vishnu documentation', 'vishnu' ); ?></h3>
                                	<p><?php esc_html_e( 'If You`ve stuck, the documentation may help on WPKoi.com', 'vishnu' ); ?></p>
                                    <a href="<?php echo esc_url(VISHNU_DOCUMENTATION); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Vishnu documentation', 'vishnu' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-social">
                                	<h3><?php esc_html_e( 'WPKoi on Facebook', 'vishnu' ); ?></h3>
                                	<p><?php esc_html_e( 'If You want to get useful info about WordPress and the theme, follow WPKoi on Facebook.', 'vishnu' ); ?></p>
                                    <a href="<?php echo esc_url(VISHNU_WPKOI_SOCIAL_URL); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Go to Facebook', 'vishnu' ); ?></a>
                                </div>
                                
                                <div class="wpkoi-review">
                                	<h3><?php esc_html_e( 'Help with You review', 'vishnu' ); ?></h3>
                                	<p><?php esc_html_e( 'If You like Vishnu theme, show it to the world with Your review. Your feedback helps a lot.', 'vishnu' ); ?></p>
                                    <a href="<?php echo esc_url(VISHNU_WORDPRESS_REVIEW); ?>" class="wpkoi-admin-button" target="_blank"><?php esc_html_e( 'Add my review', 'vishnu' ); ?></a>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'vishnu_admin_errors' ) ) {
	add_action( 'admin_notices', 'vishnu_admin_errors' );
	/**
	 * Add our admin notices
	 *
	 */
	function vishnu_admin_errors() {
		$screen = get_current_screen();

		if ( 'appearance_page_vishnu-options' !== $screen->base ) {
			return;
		}

		if ( isset( $_GET['settings-updated'] ) && 'true' == $_GET['settings-updated'] ) {
			 add_settings_error( 'vishnu-notices', 'true', esc_html__( 'Settings saved.', 'vishnu' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'imported' == $_GET['status'] ) {
			 add_settings_error( 'vishnu-notices', 'imported', esc_html__( 'Import successful.', 'vishnu' ), 'updated' );
		}

		if ( isset( $_GET['status'] ) && 'reset' == $_GET['status'] ) {
			 add_settings_error( 'vishnu-notices', 'reset', esc_html__( 'Settings removed.', 'vishnu' ), 'updated' );
		}

		settings_errors( 'vishnu-notices' );
	}
}
