<?php
/**
 * The template used for displaying page content in page.php
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php vishnu_article_schema( 'CreativeWork' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * vishnu_before_content hook.
		 *
		 *
		 * @hooked vishnu_featured_page_header_inside_single - 10
		 */
		do_action( 'vishnu_before_content' );

		if ( vishnu_show_title() ) : ?>

			<header class="entry-header">
				<?php the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' ); ?>
			</header><!-- .entry-header -->

		<?php endif;

		/**
		 * vishnu_after_entry_header hook.
		 *
		 *
		 * @hooked vishnu_post_image - 10
		 */
		do_action( 'vishnu_after_entry_header' );
		?>

		<div class="entry-content" itemprop="text">
			<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'vishnu' ),
				'after'  => '</div>',
			) );
			?>
		</div><!-- .entry-content -->

		<?php
		/**
		 * vishnu_after_content hook.
		 *
		 */
		do_action( 'vishnu_after_content' );
		?>
	</div><!-- .inside-article -->
</article><!-- #post-## -->
