<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

	<div id="primary" <?php vishnu_content_class(); ?>>
		<main id="main" <?php vishnu_main_class(); ?>>
			<?php
			/**
			 * vishnu_before_main_content hook.
			 *
			 */
			do_action( 'vishnu_before_main_content' );
			?>

			<div class="inside-article">

				<?php
				/**
				 * vishnu_before_content hook.
				 *
				 *
				 * @hooked vishnu_featured_page_header_inside_single - 10
				 */
				do_action( 'vishnu_before_content' );
				?>

				<header class="entry-header">
					<h1 class="entry-title" itemprop="headline"><?php echo apply_filters( 'vishnu_404_title', __( 'Oops! That page can&rsquo;t be found.', 'vishnu' ) ); // WPCS: XSS OK. ?></h1>
				</header><!-- .entry-header -->

				<?php
				/**
				 * vishnu_after_entry_header hook.
				 *
				 *
				 * @hooked vishnu_post_image - 10
				 */
				do_action( 'vishnu_after_entry_header' );
				?>

				<div class="entry-content" itemprop="text">
					<?php
					echo '<p>' . apply_filters( 'vishnu_404_text', __( 'It looks like nothing was found at this location. Maybe try searching?', 'vishnu' ) ) . '</p>'; // WPCS: XSS OK.

					get_search_form();
					?>
				</div><!-- .entry-content -->

				<?php
				/**
				 * vishnu_after_content hook.
				 *
				 */
				do_action( 'vishnu_after_content' );
				?>

			</div><!-- .inside-article -->

			<?php
			/**
			 * vishnu_after_main_content hook.
			 *
			 */
			do_action( 'vishnu_after_main_content' );
			?>
		</main><!-- #main -->
	</div><!-- #primary -->

	<?php
	/**
	 * vishnu_after_primary_content_area hook.
	 *
	 */
	 do_action( 'vishnu_after_primary_content_area' );

	 vishnu_construct_sidebars();

get_footer();
