<?php get_header(); ?>

	<div id="content" class="narrowcolumn">

	<?php if (have_posts()) : ?>

		<h2 class="pagetitle alts"><?php _e("Search Results"); ?></h2>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link( __('<cite>&#9835;</cite> Older Entries' ) ) ?></div>
			<div class="alignright"><?php previous_posts_link( __('Newer Entries <cite>&#9835;</cite>') ) ?></div>
		</div>


		<?php while (have_posts()) : the_post(); ?>

			<div class="post">
				<h3 id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
				<cite>&#9835;</cite> <small><?php the_time('F jS, Y') ?> <?php the_time() ?><!-- by <?php the_author() ?> --></small>

				<p class="postmetadata"><?php the_tags( __('Tags') . ': ', ', ', '<br />'); ?><cite>&#9835;</cite> <?php printf( __("Posted in %s"), get_the_category_list(', ') ); ?> | <?php edit_post_link( __('Edit'), '', ' | '); ?>  <?php comments_popup_link( __('No Comments') . ' &#187;', __('1 Comment') . ' &#187;', __('% Comments') . ' &#187;', '', __('Comments Off') . '&#187;' ); ?></p>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link( __('<cite>&#9835;</cite> Older Entries' ) ) ?></div>
			<div class="alignright"><?php previous_posts_link( __('Newer Entries <cite>&#9835;</cite>') ) ?></div>
		</div>

	<?php else : ?>

		<h2 class="center alts"><?php _e("No posts found. Try a different search?"); ?></h2>

		<form method="get" id="searchforms" action="<?php bloginfo('url'); ?>/">
		<label class="hidden" for="s"><?php _e('Search for:'); ?></label>
		<input type="text" value="Search this blog" name="s" id="s" onfocus="if ( value == 'Search this blog' ) { this.value='' }" onblur="if ( value == '' ) { this.value='Search this blog' }" />
		<input type="button" id="searchsubmit" class="submit" value="<?php _e('Search'); ?>" />
		</form>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>