<?php get_header(); ?>

	<div id="content" class="narrowcolumn">

	<?php if (have_posts()) : ?>

		<?php while (have_posts()) : the_post(); ?>

			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
				<cite>&#9835;</cite> <small><?php the_time('F jS, Y') ?> <?php the_time() ?><!-- by <?php the_author() ?> --></small>

				<div class="entry">
					<?php the_content('Read the rest of this entry &raquo;'); ?>
				</div>

				<p class="postmetadata"><?php the_tags( __('Tags') . ': ', ', ', '<br />'); ?><cite>&#9835;</cite> <?php printf( __("Posted in %s"), get_the_category_list(', ') ); ?> | <?php edit_post_link( __('Edit'), '', ' | '); ?>  <?php comments_popup_link( __('No Comments') . ' &#187;', __('1 Comment') . ' &#187;', __('% Comments') . ' &#187;', '', __('Comments Off') . '&#187;' ); ?></p>
			</div>

		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link( __('<cite>&#9835;</cite> Older Entries' ) ) ?></div>
			<div class="alignright"><?php previous_posts_link( __('Newer Entries <cite>&#9835;</cite>') ) ?></div>
		</div>

	<?php else : ?>

		<h2 class="center alts"><?php _e("Not Found"); ?></h2>
		<p class="center"><?php _e("Sorry, but you are looking for something that isn't here."); ?></p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
