<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

<title><?php if ( is_home() ) { ?><?php bloginfo('description'); ?> - <?php bloginfo('name'); ?><?php } else { ?><?php wp_title(''); ?> - <?php bloginfo('name'); ?><?php } ?></title>

<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<?php if ( get_bloginfo('language') == 'zh' ) { ?>
<style type='text/css'>
<!--
.narrowcolumn .entry, .widecolumn .entry {
	font-size: 1.1em;
}
-->
</style>
<?php } ?>

<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_head(); ?>
</head>
<body>
<div id="page">
<div id="header-menu">
	<ul>
			<li><a title="<?php bloginfo('name'); ?>" href="<?php echo get_option('home'); ?>/"><?php _e('Blog');?></a></li>
			<?php wp_list_pages('exclude=&depth=1&sort_column=menu_order&title_li='); ?>
	</ul>
</div>

<div id="header">
	<div id="headerimg">
		<?php if (is_home()) { ?>
			<h1><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
		<?php } elseif (is_category()) { ?>
			<h1><?php _e('Category')?>: <?php single_cat_title(''); ?></h1>
		<?php } elseif (is_day()) { ?>
			<h1><?php _e('Blog archives for the day')?> <?php the_time('l, F jS, Y'); ?></h1>
		<?php } elseif (is_month()) { ?>
			<h1><?php _e('Blog archives for')?> <?php the_time('F, Y'); ?></h1>
		<?php } elseif (is_year()) { ?>
			<h1><?php _e('Blog archives for the year')?> <?php the_time('Y'); ?></h1>
		<?php } elseif (is_search()) { ?>
			<h1><?php _e('Blog result for')?> <?php the_search_query(); ?></h1>
		<?php } elseif( is_tag() ) { ?>
			<h1><?php _e('Posts Tagged')?>: <?php single_tag_title(); ?></h1>
		<?php } else { ?>
			<h1><?php wp_title('');?></h1>
		<?php } ?>
		<!--<h1><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>-->
		<div class="description"><cite>&#9835;</cite> <?php bloginfo('description'); ?></div>
	</div>
</div>
<hr />
