<?php
/**
 * Video Film Portfolio - Minimalio Theme
 * Inline styles
 *
 * @package video-film-portfolio
 */

defined( 'ABSPATH' ) || exit();

function video_film_portfolio_child_dynamic_styles() {

	$styles = [
		'category_size'         => absint( get_theme_mod(
			'video_film_portfolio_settings_category_font_size'
		) ),
		'category_align'         => sanitize_text_field( get_theme_mod(
			'video_film_portfolio_settings_category_align'
		) ),
		'post_card_border_width'         => absint( get_theme_mod(
			'video_film_portfolio_settings_post_card_border_width'
		) ),
		'post_card_border_color'     => 
			sanitize_hex_color( get_theme_mod( 'video_film_portfolio_settings_post_card_border_color' )
		),
		'portfolio_card_title_size'         => absint( get_theme_mod(
			'video_film_portfolio_settings_portfolio_card_title_size'
		) ),
		'mobile_hamburger_icon_color'     =>
			sanitize_hex_color( get_theme_mod( 'video_film_portfolio_settings_mobile_hamburger_icon_color' )
		),
		'blog_post_card_body_color'     =>
			sanitize_hex_color( get_theme_mod( 'video_film_portfolio_settings_blog_post_card_body_color' )
		),
		'blog_post_card_overlay_color'         => sanitize_text_field( get_theme_mod(
			'video_film_portfolio_settings_blog_post_card_overlay_color'
		) ),
		'blog_post_card_font_size'         => absint( get_theme_mod(
			'video_film_portfolio_settings_blog_post_card_font_size'
		) ),
	];


		function video_film_portfolio_mapped_implode( $glue, $array, $symbol = '=' ) {
		return implode(
			$glue,
			array_map(
				function ( $k, $v ) use ( $symbol ) {
					return $k . $symbol . $v;
				},
				array_keys( $array ),
				array_values( $array )
			)
		);
	}


	global $video_film_portfolio_parameters;
	$video_film_portfolio_parameters = $styles;
	$css = require_once(__DIR__ . '/video-film-portfolio-customizer.css.php');

	wp_register_style( 'video-film-portfolio-options', false );
	wp_enqueue_style( 'video-film-portfolio-options' );

	wp_add_inline_style(
		'video-film-portfolio-options',
		$css,
	);
}
add_action( 'wp_enqueue_scripts', 'video_film_portfolio_child_dynamic_styles' );


