<?php

/**
 * Video Film Portfolio - videofilmportfolio Theme Customizer
 *
 * @package video-film-portfolio
 */

// Exit if accessed directly.
defined('ABSPATH') || exit();

new Video_Film_Portfolio_Child_Customizer();
class Video_Film_Portfolio_Child_Customizer
{
	/**
	 * Called on class initialisation
	 */
	public function __construct()
	{
		/* Add the WordPress actions to register customizer components */
		add_action('customize_register', [$this, 'video_film_portfolio_settings']);
	}

	/**
	 * Register photograpy portfolio customizer area
	 * @return null
	 */
	public function video_film_portfolio_settings($customizer)
	{
		if (! function_exists('video_film_portfolio_theme_slug_sanitize_select')) {
			/**
			 * Select sanitization function
			 * @param string               $input Ensure input is a slug.
			 * @param WP_Customize_Setting $setting Settings.
			 * @return string
			 */
			function video_film_portfolio_theme_slug_sanitize_select($input, $setting)
			{
				// Ensure input is a slug (lowercase alphanumeric characters, dashes and underscores are allowed only).
				$input = sanitize_key($input);
				// Get the list of possible select options.
				$choices = $setting->manager->get_control($setting->id)
					->choices;
				// If the input is a valid key, return it; otherwise, return the default.
				return array_key_exists($input, $choices)
					? $input
					: $setting->default;
			}
			// old definition here
		}

		// Include Alpha Color Picker from parent theme
		if (class_exists('Minimalio_Direction_Customizer_Alpha_Color_Control')) {
			// Already loaded by parent theme
		} else {
			require_once get_template_directory() . '/inc/theme-customizer/php/alpha-color-picker.php';
		}

		// Theme Layout options
		$customizer->add_section('video_film_portfolio_theme_child_options', [
			'title'      => esc_html__('Video Film Portfolio', 'video-film-portfolio'),
			'capability' => 'edit_theme_options',
			'panel'      => 'minimalio_panel',
		]);

		// Settings





		$customizer->add_setting('video_film_portfolio_settings_category_font_size', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);


		$customizer->add_setting('video_film_portfolio_settings_category_align', [
			'default'           => 'left',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);
		$customizer->add_setting('video_film_portfolio_settings_post_card_border_width', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);
		$customizer->add_setting('video_film_portfolio_settings_post_card_border_color', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('video_film_portfolio_settings_portfolio_card_title_size', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('video_film_portfolio_settings_mobile_hamburger_icon_color', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('video_film_portfolio_settings_blog_post_card_body_color', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_hex_color',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('video_film_portfolio_settings_blog_post_card_overlay_color', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		$customizer->add_setting('video_film_portfolio_settings_blog_post_card_font_size', [
			'default'           => '',
			'type'              => 'theme_mod',
			'sanitize_callback' => 'sanitize_text_field',
			'capability'        => 'edit_theme_options',
			'transport'         => 'refresh',
		]);

		// Controls





		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'video_film_portfolio_options_category_font_size',
				[
					'label'       => esc_html__('Portfolio/Blog Category Filtering Font Size', 'video-film-portfolio'),
					'description' => esc_html__(
						'Number in PX',
						'video-film-portfolio'
					),
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'    => 'video_film_portfolio_settings_category_font_size',
					'type'        => 'number',
				]
			)
		);


		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'video_film_portfolio_options_category_align',
				[
					'label'       => esc_html__('Portfolio/Blog Category Filtering Align ', 'video-film-portfolio'),
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'    => 'video_film_portfolio_settings_category_align',
					'type'     => 'select',
					'sanitize_callback' =>
					'video_film_portfolio_theme_slug_sanitize_select',
					'choices'  => [
						'justify-between' => esc_html__('Left', 'video-film-portfolio'),
						'flex-end' => esc_html__('Right', 'video-film-portfolio'),
						'center' => esc_html__('Center', 'video-film-portfolio'),
					],
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Color_Control(
				$customizer,
				'video_film_portfolio_options_blog_post_card_body_color',
				[
					'label'        => esc_html__(
						'Blog Post Card Body Color',
						'video-film-portfolio'
					),
					'description'  => '',
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'     => 'video_film_portfolio_settings_blog_post_card_body_color',
				]
			)
		);

		$customizer->add_control(
			new Minimalio_Direction_Customizer_Alpha_Color_Control(
				$customizer,
				'video_film_portfolio_options_blog_post_card_overlay_color',
				[
					'label'        => esc_html__(
						'Blog Post Card Overlay Color',
						'video-film-portfolio'
					),
					'section'      => 'video_film_portfolio_theme_child_options',
					'settings'     => 'video_film_portfolio_settings_blog_post_card_overlay_color',
					'show_opacity' => true,
					'palette'      => [
						'#ffffff',
						'#0a0a0a',
						'#002778',
						'#007392',
						'#3F0055',
						'#006D57',
						'#00CC99',
					],
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'video_film_portfolio_options_blog_post_card_font_size',
				[
					'label'       => esc_html__('Blog Post Card Font Size', 'video-film-portfolio'),
					'description' => esc_html__(
						'Number in PX',
						'video-film-portfolio'
					),
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'    => 'video_film_portfolio_settings_blog_post_card_font_size',
					'type'        => 'number',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'video_film_portfolio_options_post_card_border_width',
				[
					'label'       => esc_html__('Portfolio/Blog Post Card Border Width', 'video-film-portfolio'),
					'description' => esc_html__(
						'Number in PX',
						'video-film-portfolio'
					),
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'    => 'video_film_portfolio_settings_post_card_border_width',
					'type'        => 'number',
				]
			)
		);



		// Add controls for our settings, within a section
		$customizer->add_control(
			new WP_Customize_Color_Control(
				$customizer,
				'video_film_portfolio_options_post_card_border_color',
				[
					'label'        => esc_html__(
						'Portfolio/Blog Post Card Border Color',
						'video-film-portfolio'
					),
					'description'  => '',
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'     => 'video_film_portfolio_settings_post_card_border_color',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Control(
				$customizer,
				'video_film_portfolio_options_portfolio_card_title_size',
				[
					'label'       => esc_html__('Portfolio Card Title Size', 'video-film-portfolio'),
					'description' => esc_html__(
						'Number in PX',
						'video-film-portfolio'
					),
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'    => 'video_film_portfolio_settings_portfolio_card_title_size',
					'type'        => 'number',
				]
			)
		);

		$customizer->add_control(
			new WP_Customize_Color_Control(
				$customizer,
				'video_film_portfolio_options_mobile_hamburger_icon_color',
				[
					'label'        => esc_html__(
						'Mobile Hamburger Icon Color',
						'video-film-portfolio'
					),
					'description'  => '',
					'section'     => 'video_film_portfolio_theme_child_options',
					'settings'     => 'video_film_portfolio_settings_mobile_hamburger_icon_color',
				]
			)
		);

		return $customizer;
	}
}
