<?php
/**
 * Dynamyc CSS
 * Used to display Theme CSS options
 */
global $video_film_portfolio_parameters;

$css = '';





if ( isset( $video_film_portfolio_parameters['category_size'] ) && $video_film_portfolio_parameters['category_size'] ) :
	$css .= sprintf( '.posts__tab-label, .posts-ajax__tab-label {font-size: %spx!important } ', esc_attr( $video_film_portfolio_parameters['category_size'] ) );
endif;


if ( isset( $video_film_portfolio_parameters['category_align'] ) && $video_film_portfolio_parameters['category_align'] ) :
	$css .= sprintf( '.posts-ajax__row, .posts__categories-wrapper {justify-content: %s!important } ', esc_attr( $video_film_portfolio_parameters['category_align'] ) );
endif;

if ( isset( $video_film_portfolio_parameters['post_card_border_width'] ) && $video_film_portfolio_parameters['post_card_border_width'] !== '' ) :
	$css .= sprintf( '.post-card {border-width: %spx!important} ', esc_attr( $video_film_portfolio_parameters['post_card_border_width'] ) );
	$css .= sprintf( '.post-card .post-card__body {border: none!important} ');
endif;

if ( isset( $video_film_portfolio_parameters['post_card_border_color'] ) && $video_film_portfolio_parameters['post_card_border_color'] ) :
	if ( strlen( $video_film_portfolio_parameters['post_card_border_color'] ) <= 6 ) :
		$prefix2 = '#';
	else :
		$prefix2 = '';
	endif;
	$css .= sprintf( '.post-card {border-color:%s%s!important} ', $prefix2, esc_attr( $video_film_portfolio_parameters['post_card_border_color'] ) );
endif;

if ( isset( $video_film_portfolio_parameters['portfolio_card_title_size'] ) && $video_film_portfolio_parameters['portfolio_card_title_size'] ) :
	$css .= sprintf( '.portfolio-post-type .post-card .post-card__heading {font-size: %spx!important} ', esc_attr( $video_film_portfolio_parameters['portfolio_card_title_size'] ) );
	$css .= sprintf( '.portfolio-post-type .post-card .post-card__body {font-size: %spx!important} ', esc_attr( $video_film_portfolio_parameters['portfolio_card_title_size'] ) );
endif;

if ( isset( $video_film_portfolio_parameters['mobile_hamburger_icon_color'] ) && $video_film_portfolio_parameters['mobile_hamburger_icon_color'] ) :
	if ( strlen( $video_film_portfolio_parameters['mobile_hamburger_icon_color'] ) <= 6 ) :
		$prefix3 = '#';
	else :
		$prefix3 = '';
	endif;
	$css .= sprintf( '.site .header__mobile-button .mobile-menu__open-icon {color:%s%s} ', $prefix3, esc_attr( $video_film_portfolio_parameters['mobile_hamburger_icon_color'] ) );
endif;

// Blog Post Card Body Color
if ( isset( $video_film_portfolio_parameters['blog_post_card_body_color'] ) && $video_film_portfolio_parameters['blog_post_card_body_color'] ) :
	if ( strlen( $video_film_portfolio_parameters['blog_post_card_body_color'] ) <= 6 ) :
		$prefix4 = '#';
	else :
		$prefix4 = '';
	endif;
	$css .= sprintf( '.blog-post-type .post-card .post-card__body {color: %s%s!important} ', $prefix4, esc_attr( $video_film_portfolio_parameters['blog_post_card_body_color'] ) );
	$css .= sprintf( '.blog-post-type .post-card .post-card__body a {color: %s%s!important} ', $prefix4, esc_attr( $video_film_portfolio_parameters['blog_post_card_body_color'] ) );
endif;

// Blog Post Card Overlay Color
if ( isset( $video_film_portfolio_parameters['blog_post_card_overlay_color'] ) && $video_film_portfolio_parameters['blog_post_card_overlay_color'] ) :
	$css .= sprintf( '.blog-post-type .post-card .post-card__overlay {display: block; opacity: 1; background-color: %s} ', esc_attr( $video_film_portfolio_parameters['blog_post_card_overlay_color'] ) );
	$css .= sprintf( '.blog-post-type .post-card:hover .post-card__overlay {opacity: 0; transition: all 0.5s} ' );
endif;

// Blog Post Card Font Size
if ( isset( $video_film_portfolio_parameters['blog_post_card_font_size'] ) && $video_film_portfolio_parameters['blog_post_card_font_size'] ) :
	$css .= sprintf( '.blog-post-type .post-card__heading {font-size: %spx!important} ', esc_attr( $video_film_portfolio_parameters['blog_post_card_font_size'] ) );
	$css .= sprintf( '.blog-post-type .post-card__body {font-size: %spx!important} ', esc_attr( $video_film_portfolio_parameters['blog_post_card_font_size'] ) );
endif;


return $css;
