<?php

/**
 * Video Film Portfolio Welcome Notice
 *
 * @package video-film-portfolio
 */

// Add custom welcome notice for Video Film Portfolio
add_action( 'after_switch_theme', 'video_film_portfolio_set_activation_flag' );
add_action( 'admin_notices', 'video_film_portfolio_welcome_notice' );
add_action( 'wp_ajax_video_film_portfolio_dismiss_notice', 'video_film_portfolio_dismiss_notice' );

// Hide parent theme's welcome notice when child theme is active
add_action( 'init', 'video_film_portfolio_hide_parent_notice' );
function video_film_portfolio_hide_parent_notice() {
    // Remove parent theme's welcome notice
    remove_action( 'admin_notices', 'minimalio_welcome_notice' );
}

function video_film_portfolio_set_activation_flag() {
    set_transient( 'video_film_portfolio_show_welcome_notice', true, WEEK_IN_SECONDS );
}


function video_film_portfolio_welcome_notice() {
    $screen = get_current_screen();
    if ( $screen->id !== 'themes' ) {
        return;
    }

    if ( ! get_transient( 'video_film_portfolio_show_welcome_notice' ) ) {
        return;
    }

    if ( get_user_meta( get_current_user_id(), 'video_film_portfolio_dismissed_notice', true ) ) {
        return;
    }

    // Get current theme info
    $theme = wp_get_theme();
    $theme_name = $theme->get( 'Name' );
    $screenshot = $theme->get_screenshot();

    // Prepare welcome message
    $welcome_title = sprintf( __( 'Thank you for using %s!', 'video-film-portfolio' ), $theme_name );
    $welcome_text = __( 'You are using a child theme based on Minimalio. Please checkout the Minimalio admin page, where you can find the demos, tutorials and more.', 'video-film-portfolio' );
    $customizer_text = __( 'And please, also check out the video tutorial how to achieve the exact look of this theme!', 'video-film-portfolio' );
    $screenshot_alt = sprintf( __( '%s Theme Screenshot', 'video-film-portfolio' ), $theme_name );
    ?>
    <div class="notice notice-success is-dismissible minimalio-welcome-notice video-film-portfolio-welcome-notice">
        <div class="minimalio-notice-content">
            <div class="minimalio-notice-text">
                <h1><?php echo esc_html( $welcome_title ); ?></h1>
                <p><?php echo esc_html( $welcome_text ); ?></p>
                <p><?php echo esc_html( $customizer_text ); ?></p>
                <div>
                    <a href="https://minimalio.org/video-film-portfolio-child-theme/" target="_blank" class="button minimalio-premium-button">
                        <?php _e( 'How to Set Up Video Tutorial', 'video-film-portfolio' ); ?>
                    </a>
                    <a href="<?php echo admin_url( 'admin.php?page=minimalio-dashboard' ); ?>" style="margin-top: 10px; margin-left: 10px;" class="button">
                        <?php _e( 'Minimalio Admin Page', 'video-film-portfolio' ); ?>
                    </a>
                </div>
            </div>
            <?php if ( $screenshot ) : ?>
            <div class="minimalio-notice-image">
                <img src="<?php echo esc_url( $screenshot ); ?>" alt="<?php echo esc_attr( $screenshot_alt ); ?>">
            </div>
            <?php endif; ?>
        </div>
    </div>
        <script>
        jQuery(document).ready(function($) {
            $('.video-film-portfolio-welcome-notice').on('click', '.notice-dismiss', function() {
                $.post(ajaxurl, {
                    action: 'video_film_portfolio_dismiss_notice',
                    notice: 'video-film-portfolio-welcome-notice',
                    nonce: '<?php echo wp_create_nonce( 'video_film_portfolio_dismiss_notice' ); ?>'
                });
            });
        });
        </script>
    <?php
}

function video_film_portfolio_dismiss_notice() {
    check_ajax_referer( 'video_film_portfolio_dismiss_notice', 'nonce' );

    if ( isset( $_POST['notice'] ) && $_POST['notice'] === 'video-film-portfolio-welcome-notice' ) {
        // Set user meta to permanently dismiss the notice for this user
        update_user_meta( get_current_user_id(), 'video_film_portfolio_dismissed_notice', true );
        delete_transient( 'video_film_portfolio_show_welcome_notice' );
        wp_die();
    }

    wp_die();
}