<?php

/**
 * Video Film Portfolio Admin Redirect and Dashboard Customization
 *
 * @package video-film-portfolio
 */

// Add Video Film Portfolio section to the top of Minimalio admin page
add_action( 'admin_init', 'video_film_portfolio_modify_admin_output' );
function video_film_portfolio_modify_admin_output() {
    add_action( 'admin_head', 'video_film_portfolio_buffer_admin_page' );
}

function video_film_portfolio_buffer_admin_page() {
    global $pagenow;
    if ( isset( $_GET['page'] ) && $_GET['page'] === 'minimalio-dashboard' ) {
        ob_start( 'video_film_portfolio_inject_admin_content' );
    }
}

function video_film_portfolio_inject_admin_content( $buffer ) {
    // Find the position after the h1 title
    $search = '<h1>' . __( 'Minimalio Dashboard', 'video-film-portfolio' ) . '</h1>';
    $pos = strpos( $buffer, $search );

    if ( $pos !== false ) {
        $video_film_portfolio_section = '
        <div class="minimalio-admin-card video-film-portfolio-welcome-section">
            <div class="minimalio-two-columns">
                <div class="minimalio-column-text">
                    <h2>' . __( 'Welcome to Video Film Portfolio!', 'video-film-portfolio' ) . '</h2>
                    <p class="minimalio-moto">' . __( 'Child theme of Minimalio', 'video-film-portfolio' ) . '</p>

                    <p>' . __( 'Video Film Portfolio extends Minimalio with additional Theme Settings.', 'video-film-portfolio' ) . '</p>

                    <p>' . __( 'Please, check out this tutorial for using this child theme.', 'video-film-portfolio' ) . '</p>

                    <a href="https://minimalio.org/video-film-portfolio-child-theme/" target="_blank" class="button button-primary">
                        ' . __( 'Video Film Portfolio Tutorial', 'video-film-portfolio' ) . '
                    </a>

                    <a href="https://hal.minimalio.org"  target="_blank" class="button button-secondary">
                        ' . __( 'View Demo Site', 'video-film-portfolio' ) . '
                    </a>
                </div>
                <div class="minimalio-column-video">

                    <img style="max-width:300px; float:right; border: 1px solid #000;" src="' . esc_url( get_stylesheet_directory_uri() . '/screenshot.jpg' ) . '" style="" alt="' . esc_attr__( 'Video Film Portfolio Theme Screenshot', 'video-film-portfolio' ) . '">
                </div>
            </div>
        </div>';

        // Insert after the h1 title
        $insert_pos = $pos + strlen( $search );
        $buffer = substr_replace( $buffer, $video_film_portfolio_section, $insert_pos, 0 );
    }

    return $buffer;
}
