<?php

/**
 * Video Film Portfolio - Minimalio Child Theme
 *
 * @package videofilmportfolio
 */

//Add Minimalio default styles
add_action('wp_enqueue_scripts', 'video_film_portfolio_theme_enqueue_styles', 97);
function video_film_portfolio_theme_enqueue_styles()
{
    $parenthandle = 'video-film-portfolio-parent-style';
    $theme = wp_get_theme();
    wp_enqueue_style(
        $parenthandle,
        get_template_directory_uri() . '/style.css',
        array(),  // if the parent theme code has a dependency, copy it to here
        $theme->parent()->get('Version')
    );
}

//Add Video Film Portfolio styles
add_action('wp_enqueue_scripts', 'video_film_portfolio_child_add_stylesheet', 99);
function video_film_portfolio_child_add_stylesheet()
{
    wp_enqueue_style('video-film-portfolio-child-style', get_stylesheet_directory_uri() . '/style.css', false, '1.0', 'all');
}


//Add Video Film Portfolio custom styles
add_action('wp_enqueue_scripts', 'video_film_portfolio_child_add_custom_stylesheet', 98);
function video_film_portfolio_child_add_custom_stylesheet()
{
    wp_enqueue_style('video-film-portfolio-child-custom-style', get_stylesheet_directory_uri() . '/assets/video-film-portfolio-styles.min.css', false, '1.0', 'all');
}

//Make Video Film Portfolio available for translation.
load_theme_textdomain('video-film-portfolio', get_stylesheet_directory_uri() . '/languages');

// Set up the WordPress Theme logo feature.
add_theme_support( 'custom-logo' );

// Override parent theme welcome notice
function video_film_portfolio_remove_parent_welcome_notice() {
    remove_action( 'admin_notices', 'minimalio_welcome_notice' );
}
add_action( 'admin_init', 'video_film_portfolio_remove_parent_welcome_notice' );


// Include files for the Video Film Portfolio Customizer options
$video_film_portfolio_includes = [
    '/video-film-portfolio-customizer/video-film-portfolio-customizer.php',
    '/video-film-portfolio-customizer/video-film-portfolio-theme-customizer.php',
    '/preview-content/preview-content.php',
    '/preview-content/admin-redirect.php',
    '/preview-content/welcome-notice.php'
];

foreach ($video_film_portfolio_includes as $file) {
    $filepath = locate_template($file);
    if (! $filepath) {
        trigger_error(sprintf('Error locating /inc%s for inclusion', $file), E_USER_ERROR);
    }
    require_once $filepath;
}