<?php

// Global variables define
define('VICE_PARENT_TEMPLATE_DIR_URI',get_template_directory_uri());
define('VICE_TEMPLATE_DIR_URI',get_stylesheet_directory_uri());
define('VICE_TEMPLATE_DIR',trailingslashit(get_stylesheet_directory()));

add_action( 'wp_enqueue_scripts', 'vice_theme_css',999);
function vice_theme_css() {

    $vice_options = theme_setup_data();
    $current_options = wp_parse_args(  get_option( 'appointment_options', array() ), $vice_options );

    wp_enqueue_style('vice-parent-style', VICE_PARENT_TEMPLATE_DIR_URI . '/style.css' );
    wp_style_add_data('vice-parent-style', 'rtl', 'replace');
    wp_enqueue_style('bootstrap-style', VICE_PARENT_TEMPLATE_DIR_URI . '/css/bootstrap.css' );
    wp_style_add_data('bootstrap-style', 'rtl', 'replace');
  	wp_enqueue_style('vice-theme-menu', VICE_PARENT_TEMPLATE_DIR_URI . '/css/theme-menu.css' );
    wp_style_add_data('vice-theme-menu', 'rtl', 'replace');
    if($current_options['link_color_enable'] == true) {
        appointment_custom_light();
    }
    else {
  	   wp_enqueue_style('vice-default-css', VICE_TEMPLATE_DIR_URI."/css/default.css" );
    }
  	wp_enqueue_style('vice-element-style', VICE_PARENT_TEMPLATE_DIR_URI . '/css/element.css' );
  	wp_enqueue_style('vice-media-responsive', VICE_PARENT_TEMPLATE_DIR_URI. '/css/media-responsive.css');
    wp_style_add_data('vice-media-responsive', 'rtl', 'replace');
  	wp_dequeue_style('vice-default',VICE_PARENT_TEMPLATE_DIR_URI .'/css/default.css');
  	wp_enqueue_script('vice-mp-masonry-js', VICE_TEMPLATE_DIR_URI . '/js/masonry/mp.mansory.js');
}


add_action('wp_enqueue_scripts', 'vice_update_theme');
function vice_update_theme()
{
update_option('template', 'appointment');
}

/*
	 * Let WordPress manage the document title.
	 */
function vice_setup() {
   require( VICE_TEMPLATE_DIR. '/functions/customizer/customizer-copyright.php' );
   load_theme_textdomain('vice', VICE_TEMPLATE_DIR . '/languages' );
   //About Theme
    $theme = wp_get_theme(); // gets the current theme
    if ('vice' == $theme->name) {
        if (is_admin()) {
            require VICE_TEMPLATE_DIR . '/admin/admin-init.php';
        }
    }
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
}
add_action( 'after_setup_theme', 'vice_setup' );

function vice_default_data(){
	return array(
	// general settings
	'footer_copyright_text' => __( 'Proudly powered by <a href="https://wordpress.org">WordPress</a>', 'vice' ),
	'footer_menu_bar_enabled' => 0,
	'footer_social_media_enabled' => 0,
	'footer_social_media_facebook_link' => '',
	'footer_facebook_media_enabled' => 1,
	'footer_social_media_twitter_link' => '',
	'footer_twitter_media_enabled'=>1,
	'footer_social_media_linkedin_link' => '',
	'footer_linkedin_media_enabled'=>1,
	'footer_social_media_skype_link' => '',
	'footer_skype_media_enabled' => 1,

	);
}

// footer custom script
function vice_footer_custom_script()
{
    ?>
<script>
jQuery(document).ready(function ( jQuery ) {
	jQuery("#blog-masonry").mpmansory(
		{
			childrenClass: 'item', // default is a div
			columnClasses: 'padding', //add classes to items
			breakpoints:{
				lg: 3, //Change masonry column here like 2, 3, 4 column
				md: 6,
				sm: 6,
				xs: 12
			},
			distributeBy: { order: false, height: false, attr: 'data-order', attrOrder: 'asc' }, //default distribute by order, options => order: true/false, height: true/false, attr => 'data-order', attrOrder=> 'asc'/'desc'
			onload: function (items) {
				//make somthing with items
			}
		}
	);
});
</script>
<?php
}
add_action('wp_footer', 'vice_footer_custom_script');

$vice_theme = wp_get_theme();
if( $vice_theme->name == 'vice' || $vice_theme->name == 'vice child' || $vice_theme->name == 'vice Child' ) {
    // Notice to add required plugin
    function vice_admin_plugin_notice_warn() {
        $screen = get_current_screen();
        if( $screen->id == 'themes'){
            $theme_name = wp_get_theme();
            if ( get_option( 'dismissed-vice_comanion_plugin', false ) ) {
               return;
            }
            if ( function_exists('webriti_companion_activate')) {
                return;
            }?>

            <div class="updated notice is-dismissible vice-theme-notice">

                <div class="owc-header">
                    <h2 class="theme-owc-title">               
                        <svg height="60" width="60" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 70"><defs><style>.cls-1{font-size:33px;font-family:Verdana-Bold, Verdana;font-weight:700;}</style></defs><title>Artboard 1</title><text class="cls-1" transform="translate(-0.56 51.25)">WC</text></svg>
                        <?php echo esc_html('Webriti Companion','vice');?>
                    </h2>
                </div>

                <div class="vice-theme-content">
                    <h3><?php printf (esc_html__('Thank you for installing the %1$s theme.', 'vice'), esc_html($theme_name)); ?></h3>

                    <p><?php esc_html_e( 'We highly recommend you to install and activate the', 'vice' ); ?>
                        <b><?php esc_html_e( 'Webriti Companion', 'vice' ); ?></b> plugin.
                        <br>
                        <?php esc_html_e( 'This plugin will unlock enhanced features to build a beautiful website.', 'vice' ); ?>
                    </p>
                    <button class="install-plugin-button-welcome-page" data-plugin-url="<?php echo esc_url( 'https://webriti.com/extensions/webriti-companion.zip');?>" data-plugin-slug="<?php esc_attr_e( 'webriti-companion','vice');?>"><?php echo esc_html__( 'Install', 'vice' ); ?></button>
                </div>
            </div>
            
            <script type="text/javascript">
                jQuery(function($) {
                $( document ).on( 'click', '.vice-theme-notice .notice-dismiss', function () {
                    var type = $( this ).closest( '.vice-theme-notice' ).data( 'notice' );
                    $.ajax( ajaxurl,
                      {
                        type: 'POST',
                        data: {
                          action: 'dismissed_notice_handler',
                          type: type,
                        }
                      } );
                  } );
              });
            </script>
            <?php
        }
    }
    add_action( 'admin_notices', 'vice_admin_plugin_notice_warn' );
    add_action( 'wp_ajax_dismissed_notice_handler', 'vice_ajax_notice_handler');

    function vice_ajax_notice_handler() {
        update_option( 'dismissed-vice_comanion_plugin', TRUE );
    }

    function vice_notice_style(){?>
        <style type="text/css">
            label.tg-label.breadcrumbs img {
                width: 6%;
                padding: 0;
            }
            .vice-theme-notice .theme-owc-title{
                display: flex;
                align-items: center;
                height: 100%;
                margin: 0;
                font-size: 1.5em;
            }
            .vice-theme-notice p{
                font-size: 14px;
            }
            .updated.notice.vice-theme-notice h3{
                margin: 0;
            }
            div.vice-theme-notice.updated {
                border-left-color: #ee591f;
            }
            .vice-theme-content{
                padding: 0 0 1.2rem 3.57rem;
            }
        </style>
    <?php
    }
    add_action('admin_enqueue_scripts','vice_notice_style');
}

// Hook the AJAX action for logged-in users
add_action('wp_ajax_vice_check_plugin_status', 'vice_check_plugin_status');

function vice_check_plugin_status() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to manage plugins.');
        return;
    }

    if (!isset($_POST['plugin_slug'])) {
        wp_send_json_error('No plugin slug provided.');
        return;
    }

    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Adjust this based on your plugin structure

    // Check if the plugin exists
    $plugins = get_plugins();
    if (isset($plugins[$plugin_main_file])) {
        if (is_plugin_active($plugin_main_file)) {
            wp_send_json_success(array('status' => 'activated'));
        } else {
            wp_send_json_success(array('status' => 'installed'));
        }
    } else {
        wp_send_json_success(array('status' => 'not_installed'));
    }
}

// Existing AJAX installation function for installing and activating
add_action('wp_ajax_vice_install_activate_plugin', 'vice_install_and_activate_plugin');

function vice_install_and_activate_plugin() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to install plugins.');
        return;
    }

    if (!isset($_POST['plugin_url'])) {
        wp_send_json_error('No plugin URL provided.');
        return;
    }

    // Include necessary WordPress files for plugin installation
    include_once(ABSPATH . 'wp-admin/includes/file.php');
    include_once(ABSPATH . 'wp-admin/includes/misc.php');
    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');

    $plugin_url = esc_url($_POST['plugin_url']);
    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Ensure this matches your plugin structure

    // Download the plugin file
    WP_Filesystem();
    $temp_file = download_url($plugin_url);

    if (is_wp_error($temp_file)) {
        wp_send_json_error($temp_file->get_error_message());
        return;
    }

    // Unzip the plugin to the plugins folder
    $plugin_folder = WP_PLUGIN_DIR;
    $result = unzip_file($temp_file, $plugin_folder);
    
    // Clean up temporary file
    unlink($temp_file);

    if (is_wp_error($result)) {
        wp_send_json_error($result->get_error_message());
        return;
    }

    // Activate the plugin if it was installed
    $activate_result = activate_plugin($plugin_main_file);

    

    // Return success with redirect URL
    wp_send_json_success(array('redirect_url' => admin_url('admin.php?page=vice-welcome')));
}

// Enqueue JavaScript for the button functionality
add_action('admin_enqueue_scripts', 'vice_enqueue_plugin_installer_script',11);

function vice_enqueue_plugin_installer_script(){
    global $hook_suffix;
    wp_dequeue_script('appointment-plugin-installer-js');
    wp_enqueue_script('vice-plugin-installer-js',  VICE_TEMPLATE_DIR_URI . '/admin/assets/js/plugin-installer.js', array('jquery'), null, true);
    wp_localize_script('vice-plugin-installer-js', 'pluginInstallerAjax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'hook_suffix' => $hook_suffix,
        'nonce' => wp_create_nonce('plugin_installer_nonce'),

    ));
}