<?php
	$vice_actions = $this->recommended_actions;
	$vice_actions_todo = get_option( 'recommending_actions', false );
?>
<div id="recommended_actions" class="vice-tab-pane panel-close">
	<div class="action-list">
		<?php if($vice_actions): foreach ($vice_actions as $key => $vice_actionValue): 
            $excluded_ids = ['install_spice-starter-sites', 'install_one-click-demo-import', 'install_spice-blocks', 'install_elementor']; 
            if (!in_array($vice_actionValue['id'], $excluded_ids)):?>
				<div class="action" id="<?php echo esc_attr($vice_actionValue['id']); ?>">
					<div class="recommended_box col-md-6 col-sm-6 col-xs-12">
						<img width="696" height="180" src="<?php echo esc_url(VICE_PARENT_TEMPLATE_DIR_URI).'/images/'.str_replace(' ', '-', strtolower($vice_actionValue['title'])).'.png';?>">
						<div class="action-inner">
							<h3 class="action-title"><?php echo esc_html($vice_actionValue['title']); ?></h3>
							<div class="action-desc"><?php echo esc_html($vice_actionValue['desc']); ?></div>
							<?php echo wp_kses_post($vice_actionValue['link']); ?>
							<div class="action-watch">
								<?php if(!$vice_actionValue['is_done']): ?>
									<?php if(!isset($vice_actions_todo[$vice_actionValue['id']]) || !$vice_actions_todo[$vice_actionValue['id']]): ?>
										<span class="dashicons dashicons-visibility"></span>
									<?php else: ?>
										<span class="dashicons dashicons-hidden"></span>
									<?php endif; ?>
								<?php else: ?>
									<span class="dashicons dashicons-yes"></span>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			<?php endif;
            endforeach;
        endif; ?>
    </div>
</div>