<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package viburno
 */

get_header();
?>



  <main id="site-content" role="main"  class="col-100">


    <?php if (have_posts()) :?><?php while(have_posts()) : the_post(); ?>

      <!-- loop content -->

      <article <?php post_class(); ?>>

        <h1 class="mb-3 mt-2 aligncenter"><?php the_title(); ?></h1>

        <p class="small aligncenter"> <?php the_time(get_option('date_format')); ?> by <?php the_author_posts_link(); ?> </p>

        <?php
        if(has_post_thumbnail()) {
          the_post_thumbnail('', array( 'class' => 'img-res', 'alt' => get_the_title() ));
        }
        ?>
        <div class="entry-content">
          <?php
          the_content(
            sprintf(
              wp_kses(
                /* translators: %s: Name of current post. Only visible to screen readers */
                __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'viburno' ),
                array(
                  'span' => array(
                    'class' => array(),
                  ),
                )
              ),
              get_the_title()
              )
            );
            ?>
</div>
<div class="entry-content-bottom">
            <?php wp_link_pages('pagelink=Page %'); ?>

            <?php the_tags(); ?>
<div class="spacer"></div>


            <?php
            the_post_navigation(
              array(
                'prev_text' => '<span class="nav-title">        
                <svg
                viewBox="0 0 1792 1792"
                xmlns="http://www.w3.org/2000/svg" >
                <path d="m 880,1251 q -13,0 -23,-10 L 391,775 q -10,-10 -10,-23 0,-13 10,-23 l 50,-50 q 10,-10 23,-10 13,0 23,10 l 393,393 393,-393 q 10,-10 23,-10 13,0 23,10 l 50,50 q 10,10 10,23 0,13 -10,23 l -466,466 q -10,10 -23,10 z"/>
                </svg> %title</span>',
                'next_text' => '<span class="nav-title">%title         
                <svg
                viewBox="0 0 1792 1792"
                xmlns="http://www.w3.org/2000/svg" >
                <path d="m 880,1251 q -13,0 -23,-10 L 391,775 q -10,-10 -10,-23 0,-13 10,-23 l 50,-50 q 10,-10 23,-10 13,0 23,10 l 393,393 393,-393 q 10,-10 23,-10 13,0 23,10 l 50,50 q 10,10 10,23 0,13 -10,23 l -466,466 q -10,10 -23,10 z"/>
                </svg></span>',
              )
            );
            ?>


<div class="spacer"></div>
            <div class="comments">

              <?php comments_template(); ?>

            </div>
        </div>

      </article>

      <?php endwhile; ?>

    <?php else : ?>
      <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'viburno'); ?></p>
    <?php endif; ?>

 

  <aside id="site-complementary" role="complementary" class="mxy-1 pxy-1 grid-between">

    <?php get_sidebar(); ?>

  </aside>
 </main>

<?php get_footer(); ?>
