<?php
/**
 * Sample implementation of the Custom feature
 *
 *
 * @link https://developer.wordpress.org/themes/functionality/custom-headers/
 * @link https://developer.wordpress.org/themes/customize-api/customizer-objects/
 *
 * @package viburno
 */

function viburno_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'viburno_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => '000000',
				'width'              => 1400,
				'height'             => 400,
				'flex-height'        => true,
			)
		)
	);
}
add_action( 'after_setup_theme', 'viburno_custom_header_setup' );


function viburno_customize_register( $wp_customize ) {
/* Link color */
	$wp_customize->add_setting( 'viburno_link_color' , array(
    'default'   => '#ad541c',
    'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'viburno_link_color_control', array(
		'label'      => __( 'Link Color', 'viburno' ),
		'section'    => 'colors',
		'settings'   => 'viburno_link_color',
	)));
		/* Link color hover */
	$wp_customize->add_setting( 'viburno_link_color_hover' , array(
    'default'   => '#d50000',
    'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'viburno_link_color_hover_control', array(
		'label'      => __( 'Link Color Hover', 'viburno' ),
		'section'    => 'colors',
		'settings'   => 'viburno_link_color_hover',
	)));
		/* Header Color */
	$wp_customize->add_setting( 'viburno_header_color' , array(
    'default'   => '#fff',
    'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'viburno_header_color_control', array(
		'label'      => __( 'Header Color', 'viburno' ),
		'section'    => 'colors',
		'settings'   => 'viburno_header_color',
	)));

	/* primary-menu Color */
	$wp_customize->add_setting( 'viburno_primary_color' , array(
    'default'   => '#ad541c',
    'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'viburno_primary_color_control', array(
		'label'      => __( 'Primary menu Color', 'viburno' ),
		'section'    => 'colors',
		'settings'   => 'viburno_primary_color',
	)));
	/* Header title Color */
	$wp_customize->add_setting( 'viburno_text_color' , array(
    'default'   => '#ad541c',
    'transport' => 'refresh',
		'sanitize_callback' => 'sanitize_hex_color',
	));

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'viburno_text_color_control', array(
		'label'      => __( 'Title Color', 'viburno' ),
		'section'    => 'colors',
		'settings'   => 'viburno_text_color',
	)));
	$wp_customize->remove_control( 'header_textcolor' );

}
add_action( 'customize_register', 'viburno_customize_register' );	

add_action( 'wp_head', 'viburno_customize_css' );
function viburno_customize_css() {
    ?>
         <style type="text/css">
			 a { color:<?php echo esc_html(get_theme_mod( 'viburno_link_color', '#ad541c' )); ?>; }
			 a:hover { color:<?php echo esc_html(get_theme_mod( 'viburno_link_color_hover', '#d50000' )); ?>; }
			 span.nav-title{ fill:<?php echo esc_html(get_theme_mod( 'viburno_link_color', '#d50000' )); ?>; }
			 #site-header, body.is-scrolled #site-header, nav .menu .sub-menu { background-color:<?php echo esc_html(get_theme_mod( 'viburno_header_color', '#ffffff' )); ?>; }
			 ul#primary-menu li a{ color:<?php echo esc_html(get_theme_mod( 'viburno_primary_color', '#ad541c' )); ?>; }
			 span.icon path{ fill:<?php echo esc_html(get_theme_mod( 'viburno_primary_color', '#ad541c' )); ?>; }
			 button.menu-toggle{ color:<?php echo esc_html(get_theme_mod( 'viburno_primary_color', '#ad541c' )); ?>; }
			 .icon-hamburger span{ background:<?php echo esc_html(get_theme_mod( 'viburno_primary_color', '#ad541c' )); ?>; }
			 .site-title, .site-description{ color:<?php echo esc_html(get_theme_mod( 'viburno_text_color', '#ad541c' )); ?>; }
         </style>
    <?php
}

