<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package viburno
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <meta name="description" content="<?php bloginfo('description'); ?>">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <a class="skip-link" href="#site-content"><?php esc_html_e('Skip to the content', 'viburno'); ?></a>
 
  <header id="site-header" role="banner">
    <div class="header container">
      <div class="branding">

        <?php
        if (has_custom_logo()) {
          the_custom_logo();
        } else { ?>
          <a class="site-title" href="<?php echo esc_url(home_url()); ?>"><?php bloginfo('title'); ?> </a>
        <?php }
        $ilex_description = get_bloginfo('description', 'display');
        if ($ilex_description || is_customize_preview()) :
        ?>
          <p class="site-description"><?php echo $ilex_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
                                      ?></p>
        <?php endif; ?>

       
      </div><!-- .branding -->

		 <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false" aria-label="open primary-menu"><?php esc_html_e('Menu', 'viburno'); ?>
            <div class='icon-hamburger'>
              <span></span>
              <span></span>
            </div>
         </button> 	

        <nav id="site-navigation" class="main-navigation" role="navigation" aria-label="primary-menu">

          <?php
          wp_nav_menu(
            array(
              'theme_location' => 'menu-1',
			  'container' => false,
              'menu_id'        => 'primary-menu',
            )
          );
          ?>
        </nav><!-- #site-navigation -->


      <div class="search">

        <?php get_search_form(); ?>

      </div><!-- .search-banner -->

    </div>

  </header>
<div class="container">

  <?php if (get_header_image()) : ?>

    <div class="header-image" style="background:url(<?php header_image(); ?>) no-repeat center center; background-size: cover">
    </div>

  <?php endif; ?>