<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package viburno
 */

?>

<footer id="site-footer" role="contentinfo" class="footer">
  <div class="grid-center">
    <div class="col-33 alignleft"> 
         <?php
        if (has_custom_logo()) {
          the_custom_logo();
        } else { ?>
          <a class="site-title" href="<?php echo esc_url(home_url()); ?>"><?php bloginfo('title'); ?> </a>
        <?php }
		$ilex_description = get_bloginfo('description', 'display');
		if ($ilex_description || is_customize_preview()) :
		?>
		<p class="site-description"><?php echo $ilex_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
		?></p>
		<?php endif; ?>        

      <p>&nbsp; &copy; Copyright
        <?php
        echo date_i18n( 'Y' );
        ?>
      </p><!-- .footer-copyright -->

    </div>
    <div class="col-33 aligncenter">
      <div class="social">
        <?php
        wp_nav_menu(
          array(
            'theme_location' => 'social',
            'menu_id'        => 'social-menu',
          )
        );
        ?>
      </div>
    </div>
    <div class="col-33 alignright">
      <!-- Menu -->

      <?php
      wp_nav_menu(
        array(
          'theme_location' => 'footer',
          'menu_id'        => 'footer-menu',
        )
      );
      ?>

    </div>

  </div><!-- end grid-center -->


</footer>
</div><!-- end container -->
<?php wp_footer(); ?>


</body>
</html>
